/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.api.IAsterixAppRuntimeContext;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.AsterixLSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataSecondaryIndexes;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalFile;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicy;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entitytupletranslators.CompactionPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasetTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasourceAdapterTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatatypeTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DataverseTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.ExternalFileTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FunctionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.IndexTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.LibraryTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.NodeGroupTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.NodeTupleTranslator;
import org.apache.asterix.metadata.valueextractors.DatasetNameValueExtractor;
import org.apache.asterix.metadata.valueextractors.DatatypeNameValueExtractor;
import org.apache.asterix.metadata.valueextractors.MetadataEntityValueExtractor;
import org.apache.asterix.metadata.valueextractors.NestedDatatypeNameValueExtractor;
import org.apache.asterix.metadata.valueextractors.TupleCopyValueExtractor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.util.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManager;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class MetadataNode
implements IMetadataNode {
    private static final long serialVersionUID = 1L;
    private static final DatasetId METADATA_DATASET_ID = new DatasetId(0);
    private IIndexLifecycleManager indexLifecycleManager;
    private ITransactionSubsystem transactionSubsystem;
    public static final MetadataNode INSTANCE = new MetadataNode();

    private MetadataNode() {
    }

    public void initialize(IAsterixAppRuntimeContext runtimeContext) {
        this.transactionSubsystem = runtimeContext.getTransactionSubsystem();
        this.indexLifecycleManager = runtimeContext.getIndexLifecycleManager();
    }

    @Override
    public void beginTransaction(JobId transactionId) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().beginTransaction(transactionId);
        txnCtx.setMetadataTransaction(true);
    }

    @Override
    public void commitTransaction(JobId jobId) throws RemoteException, ACIDException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getTransactionManager().commitTransaction(txnCtx, new DatasetId(-1), -1);
    }

    @Override
    public void abortTransaction(JobId jobId) throws RemoteException, ACIDException {
        try {
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            this.transactionSubsystem.getTransactionManager().abortTransaction(txnCtx, new DatasetId(-1), -1);
        }
        catch (ACIDException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void lock(JobId jobId, byte lockMode) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getLockManager().lock(METADATA_DATASET_ID, -1, lockMode, txnCtx);
    }

    @Override
    public void unlock(JobId jobId, byte lockMode) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getLockManager().unlock(METADATA_DATASET_ID, -1, lockMode, txnCtx);
    }

    @Override
    public void addDataverse(JobId jobId, Dataverse dataverse) throws MetadataException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = new DataverseTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(dataverse);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A dataverse with this name " + dataverse.getDataverseName() + " already exists.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addDataset(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            DatasetTupleTranslator tupleReaderWriter = new DatasetTupleTranslator(true);
            ITupleReference datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            ITupleReference nodeGroupTuple = this.createTuple(dataset.getNodeGroupName(), dataset.getDataverseName(), dataset.getDatasetName());
            this.insertTupleIntoIndex(jobId, MetadataSecondaryIndexes.GROUPNAME_ON_DATASET_INDEX, nodeGroupTuple);
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                InternalDatasetDetails id = (InternalDatasetDetails)dataset.getDatasetDetails();
                Index primaryIndex = new Index(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, id.getPrimaryKey(), id.getPrimaryKeyType(), false, true, dataset.getPendingOp());
                this.addIndex(jobId, primaryIndex);
            }
            ITupleReference dataTypeTuple = this.createTuple(dataset.getDataverseName(), dataset.getItemTypeName(), dataset.getDatasetName());
            this.insertTupleIntoIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATASET_INDEX, dataTypeTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A dataset with this name " + dataset.getDatasetName() + " already exists in dataverse '" + dataset.getDataverseName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addIndex(JobId jobId, Index index) throws MetadataException, RemoteException {
        try {
            IndexTupleTranslator tupleWriter = new IndexTupleTranslator(jobId, this, true);
            ITupleReference tuple = tupleWriter.getTupleFromMetadataEntity(index);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("An index with name '" + index.getIndexName() + "' already exists.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addNode(JobId jobId, Node node) throws MetadataException, RemoteException {
        try {
            NodeTupleTranslator tupleReaderWriter = new NodeTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(node);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.NODE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A node with name '" + node.getNodeName() + "' already exists.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addNodeGroup(JobId jobId, NodeGroup nodeGroup) throws MetadataException, RemoteException {
        try {
            NodeGroupTupleTranslator tupleReaderWriter = new NodeGroupTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(nodeGroup);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A nodegroup with name '" + nodeGroup.getNodeGroupName() + "' already exists.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addDatatype(JobId jobId, Datatype datatype) throws MetadataException, RemoteException {
        try {
            DatatypeTupleTranslator tupleReaderWriter = new DatatypeTupleTranslator(jobId, this, true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(datatype);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A datatype with name '" + datatype.getDatatypeName() + "' already exists.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addFunction(JobId jobId, Function function) throws MetadataException, RemoteException {
        try {
            FunctionTupleTranslator tupleReaderWriter = new FunctionTupleTranslator(true);
            ITupleReference functionTuple = tupleReaderWriter.getTupleFromMetadataEntity(function);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A function with this name " + function.getName() + " and arity " + function.getArity() + " already exists in dataverse '" + function.getDataverseName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public void insertIntoDatatypeSecondaryIndex(JobId jobId, String dataverseName, String nestedTypeName, String topTypeName) throws Exception {
        ITupleReference tuple = this.createTuple(dataverseName, nestedTypeName, topTypeName);
        this.insertTupleIntoIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX, tuple);
    }

    private void insertTupleIntoIndex(JobId jobId, IMetadataIndex metadataIndex, ITupleReference tuple) throws Exception {
        long resourceID = metadataIndex.getResourceID();
        ILSMIndex lsmIndex = (ILSMIndex)this.indexLifecycleManager.getIndex(resourceID);
        try {
            this.indexLifecycleManager.open(resourceID);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(jobId, resourceID, metadataIndex, lsmIndex, IndexOperation.INSERT);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            txnCtx.setWriteTxn(true);
            txnCtx.registerIndexAndCallback(resourceID, lsmIndex, (AbstractOperationCallback)modCallback, metadataIndex.isPrimaryIndex());
            AsterixLSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            indexAccessor.forceInsert(tuple);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.indexLifecycleManager.close(resourceID);
        }
    }

    private IModificationOperationCallback createIndexModificationCallback(JobId jobId, long resourceId, IMetadataIndex metadataIndex, ILSMIndex lsmIndex, IndexOperation indexOp) throws Exception {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        if (metadataIndex.isPrimaryIndex()) {
            return new PrimaryIndexModificationOperationCallback(metadataIndex.getDatasetId().getId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, resourceId, 0, indexOp);
        }
        return new SecondaryIndexModificationOperationCallback(metadataIndex.getDatasetId().getId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, resourceId, 0, indexOp);
    }

    @Override
    public void dropDataverse(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            List<FeedPolicy> feedPolicies;
            List<Feed> dataverseFeeds;
            List<DatasourceAdapter> dataverseAdapters;
            List<Function> dataverseFunctions;
            List<Datatype> dataverseDatatypes;
            List<Dataset> dataverseDatasets = this.getDataverseDatasets(jobId, dataverseName);
            if (dataverseDatasets != null && dataverseDatasets.size() > 0) {
                for (int i = 0; i < dataverseDatasets.size(); ++i) {
                    Dataset ds = dataverseDatasets.get(i);
                    this.dropDataset(jobId, dataverseName, ds.getDatasetName());
                }
            }
            if ((dataverseDatatypes = this.getDataverseDatatypes(jobId, dataverseName)) != null && dataverseDatatypes.size() > 0) {
                for (int i = 0; i < dataverseDatatypes.size(); ++i) {
                    this.forceDropDatatype(jobId, dataverseName, dataverseDatatypes.get(i).getDatatypeName());
                }
            }
            if ((dataverseFunctions = this.getDataverseFunctions(jobId, dataverseName)) != null && dataverseFunctions.size() > 0) {
                for (Function function : dataverseFunctions) {
                    this.dropFunction(jobId, new FunctionSignature(dataverseName, function.getName(), function.getArity()));
                }
            }
            if ((dataverseAdapters = this.getDataverseAdapters(jobId, dataverseName)) != null && dataverseAdapters.size() > 0) {
                for (DatasourceAdapter adapter : dataverseAdapters) {
                    this.dropAdapter(jobId, dataverseName, adapter.getAdapterIdentifier().getName());
                }
            }
            if ((dataverseFeeds = this.getDataverseFeeds(jobId, dataverseName)) != null && dataverseFeeds.size() > 0) {
                for (int i = 0; i < dataverseFeeds.size(); ++i) {
                    Feed feed = dataverseFeeds.get(i);
                    this.dropFeed(jobId, dataverseName, feed.getFeedName());
                }
            }
            if ((feedPolicies = this.getDataversePolicies(jobId, dataverseName)) != null && feedPolicies.size() > 0) {
                for (FeedPolicy feedPolicy : feedPolicies) {
                    this.dropFeedPolicy(jobId, dataverseName, feedPolicy.getPolicyName());
                }
            }
            ITupleReference searchKey = this.createTuple(dataverseName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop dataverse '" + dataverseName + "' because it doesn't exist.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDataset(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        Dataset dataset;
        try {
            dataset = this.getDataset(jobId, dataverseName, datasetName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (dataset == null) {
            throw new MetadataException("Cannot drop dataset '" + datasetName + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datasetName);
            ITupleReference datasetTuple = null;
            try {
                List<ExternalFile> datasetFiles;
                datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
                ITupleReference groupNameSearchKey = this.createTuple(dataset.getNodeGroupName(), dataverseName, datasetName);
                try {
                    ITupleReference groupNameTuple = this.getTupleToBeDeleted(jobId, MetadataSecondaryIndexes.GROUPNAME_ON_DATASET_INDEX, groupNameSearchKey);
                    this.deleteTupleFromIndex(jobId, MetadataSecondaryIndexes.GROUPNAME_ON_DATASET_INDEX, groupNameTuple);
                }
                catch (TreeIndexException groupNameTuple) {
                    // empty catch block
                }
                ITupleReference dataTypeSearchKey = this.createTuple(dataverseName, dataset.getItemTypeName(), datasetName);
                try {
                    ITupleReference dataTypeTuple = this.getTupleToBeDeleted(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATASET_INDEX, dataTypeSearchKey);
                    this.deleteTupleFromIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATASET_INDEX, dataTypeTuple);
                }
                catch (TreeIndexException dataTypeTuple) {
                    // empty catch block
                }
                List<Index> datasetIndexes = this.getDatasetIndexes(jobId, dataverseName, datasetName);
                if (datasetIndexes != null) {
                    for (Index index : datasetIndexes) {
                        this.dropIndex(jobId, dataverseName, datasetName, index.getIndexName());
                    }
                }
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (datasetFiles = this.getExternalFiles(jobId, dataset)) != null && datasetFiles.size() > 0) {
                    for (ExternalFile file : datasetFiles) {
                        this.dropExternalFile(jobId, dataverseName, file.getDatasetName(), file.getFileNumber());
                    }
                }
            }
            catch (TreeIndexException treeIndexException) {
            }
            finally {
                this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            }
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropIndex(JobId jobId, String dataverseName, String datasetName, String indexName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datasetName, indexName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop index '" + datasetName + "." + indexName + "' because it doesn't exist.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropNodegroup(JobId jobId, String nodeGroupName) throws MetadataException, RemoteException {
        List<String> datasetNames;
        try {
            datasetNames = this.getDatasetNamesPartitionedOnThisNodeGroup(jobId, nodeGroupName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (!datasetNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Nodegroup '" + nodeGroupName + "' cannot be dropped; it was used for partitioning these datasets:");
            for (int i = 0; i < datasetNames.size(); ++i) {
                sb.append("\n" + (i + 1) + "- " + datasetNames.get(i) + ".");
            }
            throw new MetadataException(sb.toString());
        }
        try {
            ITupleReference searchKey = this.createTuple(nodeGroupName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop nodegroup '" + nodeGroupName + "' because it doesn't exist", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        List<String> usedDatatypes;
        List<String> datasetNames;
        try {
            datasetNames = this.getDatasetNamesDeclaredByThisDatatype(jobId, dataverseName, datatypeName);
            usedDatatypes = this.getDatatypeNamesUsingThisDatatype(jobId, dataverseName, datatypeName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (!datasetNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot drop type '" + datatypeName + "'; it was used when creating these datasets:");
            for (int i = 0; i < datasetNames.size(); ++i) {
                sb.append("\n" + (i + 1) + "- " + datasetNames.get(i) + ".");
            }
            throw new MetadataException(sb.toString());
        }
        if (!usedDatatypes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot drop type '" + datatypeName + "'; it is used in these datatypes:");
            for (int i = 0; i < usedDatatypes.size(); ++i) {
                sb.append("\n" + (i + 1) + "- " + usedDatatypes.get(i) + ".");
            }
            throw new MetadataException(sb.toString());
        }
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            List<String> nestedTypes = this.getNestedDatatypeNames(jobId, dataverseName, datatypeName);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
            this.deleteFromDatatypeSecondaryIndex(jobId, dataverseName, datatypeName);
            for (String nestedType : nestedTypes) {
                Datatype dt = this.getDatatype(jobId, dataverseName, nestedType);
                if (dt == null || !dt.getIsAnonymous()) continue;
                this.dropDatatype(jobId, dataverseName, dt.getDatatypeName());
            }
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop type '" + datatypeName + "' because it doesn't exist", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private void forceDropDatatype(JobId jobId, String dataverseName, String datatypeName) throws AsterixException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
            this.deleteFromDatatypeSecondaryIndex(jobId, dataverseName, datatypeName);
        }
        catch (TreeIndexException e) {
            throw new AsterixException("Cannot drop type '" + datatypeName + "' because it doesn't exist", (Throwable)e);
        }
        catch (AsterixException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
    }

    private void deleteFromDatatypeSecondaryIndex(JobId jobId, String dataverseName, String datatypeName) throws AsterixException {
        try {
            List<String> nestedTypes = this.getNestedDatatypeNames(jobId, dataverseName, datatypeName);
            for (String nestedType : nestedTypes) {
                ITupleReference searchKey = this.createTuple(dataverseName, nestedType, datatypeName);
                ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX, searchKey);
                this.deleteTupleFromIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX, tuple);
            }
        }
        catch (TreeIndexException e) {
            throw new AsterixException("Cannot drop type '" + datatypeName + "' because it doesn't exist", (Throwable)e);
        }
        catch (AsterixException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
    }

    private void deleteTupleFromIndex(JobId jobId, IMetadataIndex metadataIndex, ITupleReference tuple) throws Exception {
        long resourceID = metadataIndex.getResourceID();
        ILSMIndex lsmIndex = (ILSMIndex)this.indexLifecycleManager.getIndex(resourceID);
        try {
            this.indexLifecycleManager.open(resourceID);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(jobId, resourceID, metadataIndex, lsmIndex, IndexOperation.DELETE);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            txnCtx.setWriteTxn(true);
            txnCtx.registerIndexAndCallback(resourceID, lsmIndex, (AbstractOperationCallback)modCallback, metadataIndex.isPrimaryIndex());
            AsterixLSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            indexAccessor.forceDelete(tuple);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.indexLifecycleManager.close(resourceID);
        }
    }

    @Override
    public List<Dataverse> getDataverses(JobId jobId) throws MetadataException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = new DataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList<Dataverse> results = new ArrayList<Dataverse>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, null, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Dataverse getDataverse(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            DataverseTupleTranslator tupleReaderWriter = new DataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataverse)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Dataset> getDataverseDatasets(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            DatasetTupleTranslator tupleReaderWriter = new DatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Feed> getDataverseFeeds(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            FeedTupleTranslator tupleReaderWriter = new FeedTupleTranslator(false);
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            ArrayList<Feed> results = new ArrayList<Feed>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Library> getDataverseLibraries(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            LibraryTupleTranslator tupleReaderWriter = new LibraryTupleTranslator(false);
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            ArrayList<Library> results = new ArrayList<Library>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private List<Datatype> getDataverseDatatypes(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            DatatypeTupleTranslator tupleReaderWriter = new DatatypeTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Dataset getDataset(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datasetName);
            DatasetTupleTranslator tupleReaderWriter = new DatasetTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataset)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private List<String> getDatasetNamesDeclaredByThisDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datatypeName);
            ArrayList<String> results = new ArrayList<String>();
            DatasetNameValueExtractor valueExtractor = new DatasetNameValueExtractor();
            this.searchIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATASET_INDEX, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public List<String> getDatatypeNamesUsingThisDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datatypeName);
            ArrayList<String> results = new ArrayList<String>();
            DatatypeNameValueExtractor valueExtractor = new DatatypeNameValueExtractor(dataverseName, this);
            this.searchIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private List<String> getNestedDatatypeNames(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            ArrayList<String> results = new ArrayList<String>();
            NestedDatatypeNameValueExtractor valueExtractor = new NestedDatatypeNameValueExtractor(datatypeName);
            this.searchIndex(jobId, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public List<String> getDatasetNamesPartitionedOnThisNodeGroup(JobId jobId, String nodegroup) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(nodegroup);
            ArrayList<String> results = new ArrayList<String>();
            DatasetNameValueExtractor valueExtractor = new DatasetNameValueExtractor();
            this.searchIndex(jobId, MetadataSecondaryIndexes.GROUPNAME_ON_DATASET_INDEX, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Index getIndex(JobId jobId, String dataverseName, String datasetName, String indexName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datasetName, indexName);
            IndexTupleTranslator tupleReaderWriter = new IndexTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Index)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Index> getDatasetIndexes(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datasetName);
            IndexTupleTranslator tupleReaderWriter = new IndexTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList<Index> results = new ArrayList<Index>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Datatype getDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, datatypeName);
            DatatypeTupleTranslator tupleReaderWriter = new DatatypeTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Datatype)results.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetadataException(e);
        }
    }

    @Override
    public NodeGroup getNodeGroup(JobId jobId, String nodeGroupName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(nodeGroupName);
            NodeGroupTupleTranslator tupleReaderWriter = new NodeGroupTupleTranslator(false);
            MetadataEntityValueExtractor<NodeGroup> valueExtractor = new MetadataEntityValueExtractor<NodeGroup>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (NodeGroup)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Function getFunction(JobId jobId, FunctionSignature functionSignature) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            FunctionTupleTranslator tupleReaderWriter = new FunctionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Function)results.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFunction(JobId jobId, FunctionSignature functionSignature) throws MetadataException, RemoteException {
        Function function;
        try {
            function = this.getFunction(jobId, functionSignature);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (function == null) {
            throw new MetadataException("Cannot drop function '" + functionSignature.toString() + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = this.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            ITupleReference functionTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("There is no function with the name " + functionSignature.getName() + " and arity " + functionSignature.getArity(), e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private ITupleReference getTupleToBeDeleted(JobId jobId, IMetadataIndex metadataIndex, ITupleReference searchKey) throws Exception {
        TupleCopyValueExtractor valueExtractor = new TupleCopyValueExtractor(metadataIndex.getTypeTraits());
        ArrayList results = new ArrayList();
        this.searchIndex(jobId, metadataIndex, searchKey, valueExtractor, results);
        if (results.isEmpty()) {
            throw new TreeIndexException("Could not find entry to be deleted.");
        }
        return (ITupleReference)results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMetadata() {
        StringBuilder sb = new StringBuilder();
        try {
            IMetadataIndex index = MetadataPrimaryIndexes.DATAVERSE_DATASET;
            long resourceID = index.getResourceID();
            IIndex indexInstance = this.indexLifecycleManager.getIndex(resourceID);
            this.indexLifecycleManager.open(resourceID);
            IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            RangePredicate rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.indexLifecycleManager.close(resourceID);
            index = MetadataPrimaryIndexes.DATASET_DATASET;
            resourceID = index.getResourceID();
            indexInstance = this.indexLifecycleManager.getIndex(resourceID);
            this.indexLifecycleManager.open(resourceID);
            indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.indexLifecycleManager.close(resourceID);
            index = MetadataPrimaryIndexes.INDEX_DATASET;
            resourceID = index.getResourceID();
            indexInstance = this.indexLifecycleManager.getIndex(resourceID);
            this.indexLifecycleManager.open(resourceID);
            indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.indexLifecycleManager.close(resourceID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResultType> void searchIndex(JobId jobId, IMetadataIndex index, ITupleReference searchKey, IValueExtractor<ResultType> valueExtractor, List<ResultType> results) throws Exception {
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        long resourceID = index.getResourceID();
        IIndex indexInstance = this.indexLifecycleManager.getIndex(resourceID);
        this.indexLifecycleManager.open(resourceID);
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
        IBinaryComparator[] searchCmps = null;
        MultiComparator searchCmp = null;
        RangePredicate rangePred = null;
        if (searchKey != null) {
            searchCmps = new IBinaryComparator[searchKey.getFieldCount()];
            for (int i = 0; i < searchKey.getFieldCount(); ++i) {
                searchCmps[i] = comparatorFactories[i].createBinaryComparator();
            }
            searchCmp = new MultiComparator(searchCmps);
        }
        rangePred = new RangePredicate(searchKey, searchKey, true, true, searchCmp, searchCmp);
        indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
        try {
            while (rangeCursor.hasNext()) {
                rangeCursor.next();
                ResultType result = valueExtractor.getValue(jobId, rangeCursor.getTuple());
                if (result == null) continue;
                results.add(result);
            }
        }
        finally {
            rangeCursor.close();
        }
        this.indexLifecycleManager.close(resourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDatasetIdFactory(JobId jobId) throws MetadataException, RemoteException {
        int mostRecentDatasetId = 100;
        long resourceID = MetadataPrimaryIndexes.DATASET_DATASET.getResourceID();
        try {
            IIndex indexInstance = this.indexLifecycleManager.getIndex(resourceID);
            this.indexLifecycleManager.open(resourceID);
            try {
                IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
                DatasetTupleTranslator tupleReaderWriter = new DatasetTupleTranslator(false);
                MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
                RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        ITupleReference ref = rangeCursor.getTuple();
                        Dataset ds = (Dataset)valueExtractor.getValue(jobId, ref);
                        int datasetId = ds.getDatasetId();
                        if (mostRecentDatasetId >= datasetId) continue;
                        mostRecentDatasetId = datasetId;
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                this.indexLifecycleManager.close(resourceID);
            }
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        DatasetIdFactory.initialize((int)mostRecentDatasetId);
    }

    public ITupleReference createTuple(String ... fields) throws HyracksDataException {
        ISerializerDeserializer stringSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(fields.length);
        for (String s : fields) {
            aString.setValue(s);
            stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
            tupleBuilder.addFieldEndOffset();
        }
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public List<Function> getDataverseFunctions(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            FunctionTupleTranslator tupleReaderWriter = new FunctionTupleTranslator(false);
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            ArrayList<Function> results = new ArrayList<Function>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addAdapter(JobId jobId, DatasourceAdapter adapter) throws MetadataException, RemoteException {
        try {
            DatasourceAdapterTupleTranslator tupleReaderWriter = new DatasourceAdapterTupleTranslator(true);
            ITupleReference adapterTuple = tupleReaderWriter.getTupleFromMetadataEntity(adapter);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, adapterTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A adapter with this name " + adapter.getAdapterIdentifier().getName() + " already exists in dataverse '" + adapter.getAdapterIdentifier().getNamespace() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropAdapter(JobId jobId, String dataverseName, String adapterName) throws MetadataException, RemoteException {
        DatasourceAdapter adapter;
        try {
            adapter = this.getAdapter(jobId, dataverseName, adapterName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (adapter == null) {
            throw new MetadataException("Cannot drop adapter '" + adapter + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, adapterName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop adapter '" + adapterName, e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public DatasourceAdapter getAdapter(JobId jobId, String dataverseName, String adapterName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, adapterName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = new DatasourceAdapterTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (DatasourceAdapter)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addCompactionPolicy(JobId jobId, CompactionPolicy compactionPolicy) throws MetadataException, RemoteException {
        try {
            CompactionPolicyTupleTranslator tupleReaderWriter = new CompactionPolicyTupleTranslator(true);
            ITupleReference compactionPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(compactionPolicy);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, compactionPolicyTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A compcation policy with this name " + compactionPolicy.getPolicyName() + " already exists in dataverse '" + compactionPolicy.getPolicyName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public CompactionPolicy getCompactionPolicy(JobId jobId, String dataverse, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverse, policyName);
            CompactionPolicyTupleTranslator tupleReaderWriter = new CompactionPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<CompactionPolicy> valueExtractor = new MetadataEntityValueExtractor<CompactionPolicy>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (CompactionPolicy)results.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = new DatasourceAdapterTupleTranslator(false);
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            ArrayList<DatasourceAdapter> results = new ArrayList<DatasourceAdapter>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addLibrary(JobId jobId, Library library) throws MetadataException, RemoteException {
        try {
            LibraryTupleTranslator tupleReaderWriter = new LibraryTupleTranslator(true);
            ITupleReference libraryTuple = tupleReaderWriter.getTupleFromMetadataEntity(library);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, libraryTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A library with this name " + library.getDataverseName() + " already exists in dataverse '" + library.getDataverseName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropLibrary(JobId jobId, String dataverseName, String libraryName) throws MetadataException, RemoteException {
        Library library;
        try {
            library = this.getLibrary(jobId, dataverseName, libraryName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (library == null) {
            throw new MetadataException("Cannot drop library '" + library + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, libraryName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop library '" + libraryName, e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Library getLibrary(JobId jobId, String dataverseName, String libraryName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, libraryName);
            LibraryTupleTranslator tupleReaderWriter = new LibraryTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Library)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws MetadataException, RemoteException {
        return DatasetIdFactory.getMostRecentDatasetId();
    }

    @Override
    public void addFeedPolicy(JobId jobId, FeedPolicy feedPolicy) throws MetadataException, RemoteException {
        try {
            FeedPolicyTupleTranslator tupleReaderWriter = new FeedPolicyTupleTranslator(true);
            ITupleReference feedPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedPolicy);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, feedPolicyTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A feed policy with this name " + feedPolicy.getPolicyName() + " already exists in dataverse '" + feedPolicy.getPolicyName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public FeedPolicy getFeedPolicy(JobId jobId, String dataverse, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverse, policyName);
            FeedPolicyTupleTranslator tupleReaderWriter = new FeedPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedPolicy> valueExtractor = new MetadataEntityValueExtractor<FeedPolicy>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedPolicy)results.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addFeed(JobId jobId, Feed feed) throws MetadataException, RemoteException {
        try {
            FeedTupleTranslator tupleReaderWriter = new FeedTupleTranslator(true);
            ITupleReference feedTuple = tupleReaderWriter.getTupleFromMetadataEntity(feed);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, feedTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A feed with this name " + feed.getFeedName() + " already exists in dataverse '" + feed.getDataverseName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Feed getFeed(JobId jobId, String dataverse, String feedName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverse, feedName);
            FeedTupleTranslator tupleReaderWriter = new FeedTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (Feed)results.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFeed(JobId jobId, String dataverse, String feedName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverse, feedName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop feed '" + feedName + "' because it doesn't exist", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFeedPolicy(JobId jobId, String dataverseName, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverseName, policyName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Unknown feed policy " + policyName, e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<FeedPolicy> getDataversePolicies(JobId jobId, String dataverse) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataverse);
            FeedPolicyTupleTranslator tupleReaderWriter = new FeedPolicyTupleTranslator(false);
            MetadataEntityValueExtractor<FeedPolicy> valueExtractor = new MetadataEntityValueExtractor<FeedPolicy>(tupleReaderWriter);
            ArrayList<FeedPolicy> results = new ArrayList<FeedPolicy>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addExternalFile(JobId jobId, ExternalFile externalFile) throws MetadataException, RemoteException {
        try {
            ExternalFileTupleTranslator tupleReaderWriter = new ExternalFileTupleTranslator(true);
            ITupleReference externalFileTuple = tupleReaderWriter.getTupleFromMetadataEntity(externalFile);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, externalFileTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("An externalFile with this number " + externalFile.getFileNumber() + " already exists in dataset '" + externalFile.getDatasetName() + "' in dataverse '" + externalFile.getDataverseName() + "'.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<ExternalFile> getExternalFiles(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ExternalFileTupleTranslator tupleReaderWriter = new ExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList<ExternalFile> results = new ArrayList<ExternalFile>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropExternalFile(JobId jobId, String dataverseName, String datasetName, int fileNumber) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Couldn't drop externalFile.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropExternalFiles(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        List<ExternalFile> files;
        try {
            files = this.getExternalFiles(jobId, dataset);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        try {
            for (int i = 0; i < files.size(); ++i) {
                this.dropExternalFile(jobId, files.get(i).getDataverseName(), files.get(i).getDatasetName(), files.get(i).getFileNumber());
            }
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public ITupleReference createExternalFileSearchTuple(String dataverseName, String datasetName, int fileNumber) throws HyracksDataException {
        ISerializerDeserializer stringSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer intSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(3);
        aString.setValue(dataverseName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        aString.setValue(datasetName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        intSerde.serialize((Object)new AInt32(fileNumber), tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public ExternalFile getExternalFile(JobId jobId, String dataverseName, String datasetName, Integer fileNumber) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ExternalFileTupleTranslator tupleReaderWriter = new ExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (ExternalFile)results.get(0);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void updateDataset(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            DatasetTupleTranslator tupleReaderWriter = new DatasetTupleTranslator(true);
            datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }
}

