/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicy;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;

public class MetadataCache {
    private static final long TEMP_DATASET_INACTIVE_TIME_THRESHOLD = 2592000000L;
    protected final Map<String, Dataverse> dataverses = new HashMap<String, Dataverse>();
    protected final Map<String, Map<String, Dataset>> datasets = new HashMap<String, Map<String, Dataset>>();
    protected final Map<String, Map<String, Map<String, Index>>> indexes = new HashMap<String, Map<String, Map<String, Index>>>();
    protected final Map<String, Map<String, Datatype>> datatypes = new HashMap<String, Map<String, Datatype>>();
    protected final Map<String, NodeGroup> nodeGroups = new HashMap<String, NodeGroup>();
    protected final Map<FunctionSignature, Function> functions = new HashMap<FunctionSignature, Function>();
    protected final Map<String, Map<String, DatasourceAdapter>> adapters = new HashMap<String, Map<String, DatasourceAdapter>>();
    protected final Map<String, Map<String, FeedPolicy>> feedPolicies = new HashMap<String, Map<String, FeedPolicy>>();
    protected final Map<String, Map<String, Library>> libraries = new HashMap<String, Map<String, Library>>();
    protected final Map<String, Map<String, Feed>> feeds = new HashMap<String, Map<String, Feed>>();
    protected final Map<String, Map<String, CompactionPolicy>> compactionPolicies = new HashMap<String, Map<String, CompactionPolicy>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(MetadataTransactionContext ctx) {
        int logIx = 0;
        ArrayList<MetadataLogicalOperation> opLog = ctx.getOpLog();
        try {
            for (logIx = 0; logIx < opLog.size(); ++logIx) {
                this.doOperation(opLog.get(logIx));
            }
        }
        catch (Exception e) {
            try {
                for (int i = logIx - 1; i >= 0; --i) {
                    this.undoOperation(opLog.get(i));
                }
            }
            catch (Exception e2) {
                this.clear();
            }
        }
        finally {
            ctx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<String, NodeGroup> map2 = this.nodeGroups;
            synchronized (map2) {
                Map<String, Map<String, Dataset>> map3 = this.datasets;
                synchronized (map3) {
                    Map<String, Map<String, Map<String, Index>>> map4 = this.indexes;
                    synchronized (map4) {
                        Map<String, Map<String, Datatype>> map5 = this.datatypes;
                        synchronized (map5) {
                            Map<FunctionSignature, Function> map6 = this.functions;
                            synchronized (map6) {
                                Map<String, Map<String, DatasourceAdapter>> map7 = this.adapters;
                                synchronized (map7) {
                                    Map<String, Map<String, Library>> map8 = this.libraries;
                                    synchronized (map8) {
                                        Map<String, Map<String, CompactionPolicy>> map9 = this.compactionPolicies;
                                        synchronized (map9) {
                                            this.dataverses.clear();
                                            this.nodeGroups.clear();
                                            this.datasets.clear();
                                            this.indexes.clear();
                                            this.datatypes.clear();
                                            this.functions.clear();
                                            this.adapters.clear();
                                            this.libraries.clear();
                                            this.compactionPolicies.clear();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addDataverseIfNotExists(Dataverse dataverse) {
        Map<String, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<String, Map<String, Dataset>> map2 = this.datasets;
            synchronized (map2) {
                Map<String, Map<String, Datatype>> map3 = this.datatypes;
                synchronized (map3) {
                    if (!this.dataverses.containsKey(dataverse)) {
                        this.datasets.put(dataverse.getDataverseName(), new HashMap());
                        this.datatypes.put(dataverse.getDataverseName(), new HashMap());
                        this.adapters.put(dataverse.getDataverseName(), new HashMap());
                        return this.dataverses.put(dataverse.getDataverseName(), dataverse);
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addDatasetIfNotExists(Dataset dataset) {
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Map<String, Map<String, Index>>> map2 = this.indexes;
            synchronized (map2) {
                Map<String, Dataset> m;
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                    InternalDatasetDetails id = (InternalDatasetDetails)dataset.getDatasetDetails();
                    Index index = new Index(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, id.getPartitioningKey(), id.getPrimaryKeyType(), false, true, dataset.getPendingOp());
                    this.addIndexIfNotExistsInternal(index);
                }
                if ((m = this.datasets.get(dataset.getDataverseName())) == null) {
                    m = new HashMap<String, Dataset>();
                    this.datasets.put(dataset.getDataverseName(), m);
                }
                if (!m.containsKey(dataset.getDatasetName())) {
                    return m.put(dataset.getDatasetName(), dataset);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addIndexIfNotExists(Index index) {
        Map<String, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            return this.addIndexIfNotExistsInternal(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addDatatypeIfNotExists(Datatype datatype) {
        Map<String, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(datatype.getDataverseName());
            if (m == null) {
                m = new HashMap<String, Datatype>();
                this.datatypes.put(datatype.getDataverseName(), m);
            }
            if (!m.containsKey(datatype.getDatatypeName())) {
                return m.put(datatype.getDatatypeName(), datatype);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addNodeGroupIfNotExists(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            if (!this.nodeGroups.containsKey(nodeGroup.getNodeGroupName())) {
                return this.nodeGroups.put(nodeGroup.getNodeGroupName(), nodeGroup);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addCompactionPolicyIfNotExists(CompactionPolicy compactionPolicy) {
        CompactionPolicy compactionPolicy2 = compactionPolicy;
        synchronized (compactionPolicy2) {
            Map<String, CompactionPolicy> p = this.compactionPolicies.get(compactionPolicy.getDataverseName());
            if (p == null) {
                p = new HashMap<String, CompactionPolicy>();
                p.put(compactionPolicy.getPolicyName(), compactionPolicy);
                this.compactionPolicies.put(compactionPolicy.getDataverseName(), p);
            } else if (p.get(compactionPolicy.getPolicyName()) == null) {
                p.put(compactionPolicy.getPolicyName(), compactionPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropCompactionPolicy(CompactionPolicy compactionPolicy) {
        Map<String, Map<String, CompactionPolicy>> map = this.compactionPolicies;
        synchronized (map) {
            Map<String, CompactionPolicy> p = this.compactionPolicies.get(compactionPolicy.getDataverseName());
            if (p != null && p.get(compactionPolicy.getPolicyName()) != null) {
                return p.remove(compactionPolicy).getPolicyName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropDataverse(Dataverse dataverse) {
        Map<String, Dataverse> map = this.dataverses;
        synchronized (map) {
            Map<String, Map<String, Dataset>> map2 = this.datasets;
            synchronized (map2) {
                Map<String, Map<String, Map<String, Index>>> map3 = this.indexes;
                synchronized (map3) {
                    Map<String, Map<String, Datatype>> map4 = this.datatypes;
                    synchronized (map4) {
                        Map<FunctionSignature, Function> map5 = this.functions;
                        synchronized (map5) {
                            Map<String, Map<String, DatasourceAdapter>> map6 = this.adapters;
                            synchronized (map6) {
                                Map<String, Map<String, Library>> map7 = this.libraries;
                                synchronized (map7) {
                                    Map<String, Map<String, Feed>> map8 = this.feeds;
                                    synchronized (map8) {
                                        Map<String, Map<String, CompactionPolicy>> map9 = this.compactionPolicies;
                                        synchronized (map9) {
                                            this.datasets.remove(dataverse.getDataverseName());
                                            this.indexes.remove(dataverse.getDataverseName());
                                            this.datatypes.remove(dataverse.getDataverseName());
                                            this.adapters.remove(dataverse.getDataverseName());
                                            this.compactionPolicies.remove(dataverse.getDataverseName());
                                            ArrayList<FunctionSignature> markedFunctionsForRemoval = new ArrayList<FunctionSignature>();
                                            for (FunctionSignature signature : this.functions.keySet()) {
                                                if (!signature.getNamespace().equals(dataverse.getDataverseName())) continue;
                                                markedFunctionsForRemoval.add(signature);
                                            }
                                            for (FunctionSignature signature : markedFunctionsForRemoval) {
                                                this.functions.remove(signature);
                                            }
                                            this.libraries.remove(dataverse.getDataverseName());
                                            this.feeds.remove(dataverse.getDataverseName());
                                            return this.dataverses.remove(dataverse.getDataverseName());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropDataset(Dataset dataset) {
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Map<String, Map<String, Index>>> map2 = this.indexes;
            synchronized (map2) {
                Map<String, Dataset> m;
                Map<String, Map<String, Index>> datasetMap = this.indexes.get(dataset.getDataverseName());
                if (datasetMap != null) {
                    datasetMap.remove(dataset.getDatasetName());
                }
                if ((m = this.datasets.get(dataset.getDataverseName())) == null) {
                    return null;
                }
                return m.remove(dataset.getDatasetName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropIndex(Index index) {
        Map<String, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            Map<String, Map<String, Index>> datasetMap = this.indexes.get(index.getDataverseName());
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(index.getDatasetName());
            if (indexMap == null) {
                return null;
            }
            return indexMap.remove(index.getIndexName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropDatatype(Datatype datatype) {
        Map<String, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(datatype.getDataverseName());
            if (m == null) {
                return null;
            }
            return m.remove(datatype.getDatatypeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropNodeGroup(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.remove(nodeGroup.getNodeGroupName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse getDataverse(String dataverseName) {
        Map<String, Dataverse> map = this.dataverses;
        synchronized (map) {
            return this.dataverses.get(dataverseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset(String dataverseName, String datasetName) {
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Dataset> m = this.datasets.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(datasetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getIndex(String dataverseName, String datasetName, String indexName) {
        Map<String, Map<String, Map<String, Index>>> map = this.indexes;
        synchronized (map) {
            Map<String, Map<String, Index>> datasetMap = this.indexes.get(dataverseName);
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(datasetName);
            if (indexMap == null) {
                return null;
            }
            return indexMap.get(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getDatatype(String dataverseName, String datatypeName) {
        Map<String, Map<String, Datatype>> map = this.datatypes;
        synchronized (map) {
            Map<String, Datatype> m = this.datatypes.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(datatypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup getNodeGroup(String nodeGroupName) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.get(nodeGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(FunctionSignature functionSignature) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            return this.functions.get(functionSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> getDataverseDatasets(String dataverseName) {
        ArrayList<Dataset> retDatasets = new ArrayList<Dataset>();
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Dataset> m = this.datasets.get(dataverseName);
            if (m == null) {
                return retDatasets;
            }
            for (Map.Entry<String, Dataset> entry : m.entrySet()) {
                retDatasets.add(entry.getValue());
            }
            return retDatasets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getDatasetIndexes(String dataverseName, String datasetName) {
        ArrayList<Index> retIndexes = new ArrayList<Index>();
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            Map<String, Index> map2 = this.indexes.get(dataverseName).get(datasetName);
            if (map2 == null) {
                return retIndexes;
            }
            for (Map.Entry<String, Index> entry : map2.entrySet()) {
                retIndexes.add(entry.getValue());
            }
            return retIndexes;
        }
    }

    protected void doOperation(MetadataLogicalOperation op) {
        if (op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    protected void undoOperation(MetadataLogicalOperation op) {
        if (!op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addFunctionIfNotExists(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return this.functions.put(signature, function);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropFunction(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return null;
            }
            return this.functions.remove(signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addFeedPolicyIfNotExists(FeedPolicy feedPolicy) {
        FeedPolicy feedPolicy2 = feedPolicy;
        synchronized (feedPolicy2) {
            Map<String, FeedPolicy> p = this.feedPolicies.get(feedPolicy.getDataverseName());
            if (p == null) {
                p = new HashMap<String, FeedPolicy>();
                p.put(feedPolicy.getPolicyName(), feedPolicy);
                this.feedPolicies.put(feedPolicy.getDataverseName(), p);
            } else if (p.get(feedPolicy.getPolicyName()) == null) {
                p.put(feedPolicy.getPolicyName(), feedPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropFeedPolicy(FeedPolicy feedPolicy) {
        Map<String, Map<String, FeedPolicy>> map = this.feedPolicies;
        synchronized (map) {
            Map<String, FeedPolicy> p = this.feedPolicies.get(feedPolicy.getDataverseName());
            if (p != null && p.get(feedPolicy.getPolicyName()) != null) {
                return p.remove(feedPolicy).getPolicyName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addAdapterIfNotExists(DatasourceAdapter adapter) {
        Map<String, Map<String, DatasourceAdapter>> map = this.adapters;
        synchronized (map) {
            DatasourceAdapter adapterObject;
            Map<String, DatasourceAdapter> adaptersInDataverse = this.adapters.get(adapter.getAdapterIdentifier().getNamespace());
            if (adaptersInDataverse == null) {
                adaptersInDataverse = new HashMap<String, DatasourceAdapter>();
                this.adapters.put(adapter.getAdapterIdentifier().getNamespace(), adaptersInDataverse);
            }
            if ((adapterObject = adaptersInDataverse.get(adapter.getAdapterIdentifier().getName())) == null) {
                return adaptersInDataverse.put(adapter.getAdapterIdentifier().getName(), adapter);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropAdapter(DatasourceAdapter adapter) {
        Map<String, Map<String, DatasourceAdapter>> map = this.adapters;
        synchronized (map) {
            Map<String, DatasourceAdapter> adaptersInDataverse = this.adapters.get(adapter.getAdapterIdentifier().getNamespace());
            if (adaptersInDataverse != null) {
                return adaptersInDataverse.remove(adapter.getAdapterIdentifier().getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addLibraryIfNotExists(Library library) {
        Map<String, Map<String, Library>> map = this.libraries;
        synchronized (map) {
            boolean needToAddd;
            Map<String, Library> libsInDataverse = this.libraries.get(library.getDataverseName());
            boolean bl = needToAddd = libsInDataverse == null || libsInDataverse.get(library.getName()) != null;
            if (needToAddd) {
                if (libsInDataverse == null) {
                    libsInDataverse = new HashMap<String, Library>();
                    this.libraries.put(library.getDataverseName(), libsInDataverse);
                }
                return libsInDataverse.put(library.getDataverseName(), library);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropLibrary(Library library) {
        Map<String, Map<String, Library>> map = this.libraries;
        synchronized (map) {
            Map<String, Library> librariesInDataverse = this.libraries.get(library.getDataverseName());
            if (librariesInDataverse != null) {
                return librariesInDataverse.remove(library.getName());
            }
            return null;
        }
    }

    public Object addFeedIfNotExists(Feed feed) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropFeed(Feed feed) {
        Map<String, Map<String, Feed>> map = this.feeds;
        synchronized (map) {
            Map<String, Feed> feedsInDataverse = this.feeds.get(feed.getDataverseName());
            if (feedsInDataverse != null) {
                return feedsInDataverse.remove(feed.getFeedName());
            }
            return null;
        }
    }

    private Object addIndexIfNotExistsInternal(Index index) {
        Map<String, Index> indexMap;
        Map<String, Map<String, Index>> datasetMap = this.indexes.get(index.getDataverseName());
        if (datasetMap == null) {
            datasetMap = new HashMap<String, Map<String, Index>>();
            this.indexes.put(index.getDataverseName(), datasetMap);
        }
        if ((indexMap = datasetMap.get(index.getDatasetName())) == null) {
            indexMap = new HashMap<String, Index>();
            datasetMap.put(index.getDatasetName(), indexMap);
        }
        if (!indexMap.containsKey(index.getIndexName())) {
            return indexMap.put(index.getIndexName(), index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupTempDatasets() {
        Map<String, Map<String, Dataset>> map = this.datasets;
        synchronized (map) {
            for (Map<String, Dataset> map2 : this.datasets.values()) {
                Iterator<Dataset> datasetIterator = map2.values().iterator();
                while (datasetIterator.hasNext()) {
                    long currentTime;
                    long duration;
                    Dataset dataset = datasetIterator.next();
                    if (!dataset.getDatasetDetails().isTemp() || (duration = (currentTime = System.currentTimeMillis()) - dataset.getDatasetDetails().getLastAccessTime()) <= 2592000000L) continue;
                    datasetIterator.remove();
                }
            }
        }
    }

    protected class MetadataLogicalOperation {
        public final IMetadataEntity entity;
        public final boolean isAdd;

        public MetadataLogicalOperation(IMetadataEntity entity, boolean isAdd) {
            this.entity = entity;
            this.isAdd = isAdd;
        }
    }
}

