/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.metadata.feeds;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.asterix.common.feeds.api.IFeedWork;
import org.apache.asterix.common.feeds.api.IFeedWorkEventListener;
import org.apache.asterix.common.feeds.api.IFeedWorkManager;

/**
 * Handles asynchronous execution of feed management related tasks.
 */
public class FeedWorkManager implements IFeedWorkManager {

    public static final FeedWorkManager INSTANCE = new FeedWorkManager();

    private final ExecutorService executorService = Executors.newCachedThreadPool();

    private FeedWorkManager() {
    }

    public void submitWork(IFeedWork work, IFeedWorkEventListener listener) {
        Runnable runnable = work.getRunnable();
        try {
            executorService.execute(runnable);
            listener.workCompleted(work);
        } catch (Exception e) {
            listener.workFailed(work, e);
        }
    }

}