/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.extensions;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PortCheckExtension
implements Extension,
BeforeEachCallback,
AfterEachCallback {
    final int[] ports;

    public PortCheckExtension(int ... ports) {
        this.ports = ports;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        String testName = context.getRequiredTestMethod().getName();
        for (int p : this.ports) {
            if (PortCheckExtension.checkAvailable(p)) continue;
            Assertions.fail((String)("a previous test is using port " + p + " before " + testName));
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        String testName = context.getRequiredTestMethod().getName();
        for (int p : this.ports) {
            if (PortCheckExtension.checkAvailable(p)) continue;
            Assertions.fail((String)(testName + " has left a server socket open on port " + p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAvailable(int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            s.bind(new InetSocketAddress("localhost", port));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

