/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;

public class AssertionLoggerHandler
extends AbstractAppender
implements Closeable {
    private final Deque<LogEntry> messages = new ConcurrentLinkedDeque<LogEntry>();
    private final boolean captureStackTrace;

    public AssertionLoggerHandler() {
        this(false);
    }

    public AssertionLoggerHandler(boolean captureStackTrace) {
        super("AssertionLoggerHandler" + System.currentTimeMillis(), null, null, true, Property.EMPTY_ARRAY);
        this.captureStackTrace = captureStackTrace;
        org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        rootLogger.addAppender((Appender)this);
        super.start();
    }

    public void append(LogEvent event) {
        LogEntry logEntry = new LogEntry();
        logEntry.message = event.getMessage().getFormattedMessage();
        logEntry.level = event.getLevel();
        logEntry.loggerName = event.getLoggerName();
        if (this.captureStackTrace && event.getThrown() != null) {
            StringWriter stackOutput = new StringWriter();
            event.getThrown().printStackTrace(new PrintWriter(stackOutput));
            logEntry.stackTrace = stackOutput.toString();
        }
        this.messages.addFirst(logEntry);
    }

    @Override
    public void close() throws IOException {
        org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        rootLogger.removeAppender((Appender)this);
    }

    public boolean hasLevel(LogLevel level) {
        Level implLevel = level.toImplLevel();
        for (LogEntry logEntry : this.messages) {
            if (implLevel != logEntry.level) continue;
            return true;
        }
        return false;
    }

    public static LogLevel setLevel(String loggerName, LogLevel level) {
        Level newLevel;
        Logger logger = LogManager.getLogger((String)loggerName);
        Level existingLevel = logger.getLevel();
        if (!existingLevel.equals((Object)(newLevel = level.toImplLevel()))) {
            Configurator.setLevel((Logger)logger, (Level)newLevel);
        }
        return LogLevel.fromImplLevel(existingLevel);
    }

    public boolean findText(String ... text) {
        for (LogEntry logEntry : this.messages) {
            String txtCheck;
            boolean found = false;
            String[] stringArray = text;
            int n = stringArray.length;
            for (int i = 0; i < n && (found = logEntry.message.contains(txtCheck = stringArray[i])); ++i) {
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public boolean findTrace(String trace) {
        if (!this.captureStackTrace) {
            throw new IllegalStateException("captureStackTrace must be enabled to use this method");
        }
        for (LogEntry logEntry : this.messages) {
            if (logEntry.stackTrace == null || !logEntry.stackTrace.contains(trace)) continue;
            return true;
        }
        return false;
    }

    public int countText(String ... text) {
        int found = 0;
        for (LogEntry logEntry : this.messages) {
            for (String txtCheck : text) {
                if (!logEntry.message.contains(txtCheck)) continue;
                ++found;
            }
        }
        return found;
    }

    public boolean matchText(String pattern) {
        Pattern r = Pattern.compile(pattern);
        for (LogEntry logEntry : this.messages) {
            if (!r.matcher(logEntry.message).matches()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.messages.clear();
    }

    public List<LogEntry> getLogEntries() {
        return this.messages.stream().collect(Collectors.toList());
    }

    public int getNumberOfMessages() {
        return this.messages.size();
    }

    public static class LogEntry {
        private String message;
        private String stackTrace;
        private Level level;
        private String loggerName;

        public String getMessage() {
            return this.message;
        }

        public LogLevel getLogLevel() {
            return LogLevel.fromImplLevel(this.level);
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }
    }

    public static enum LogLevel {
        OFF(Level.OFF),
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE);

        Level implLevel;

        private LogLevel(Level implLevel) {
            this.implLevel = implLevel;
        }

        private Level toImplLevel() {
            return this.implLevel;
        }

        private static LogLevel fromImplLevel(Level implLevel) {
            for (LogLevel logLevel : LogLevel.values()) {
                if (logLevel.implLevel != implLevel) continue;
                return logLevel;
            }
            throw new IllegalArgumentException("Unexpected level:" + String.valueOf(implLevel));
        }
    }
}

