/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.util.HashMap;
import java.util.Map;

public class LockCoordinatorConfiguration {
    String name;
    String lockId;
    String className;
    int checkPeriod;
    Map<String, String> properties;

    public LockCoordinatorConfiguration() {
        this.properties = new HashMap<String, String>();
    }

    public LockCoordinatorConfiguration(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public LockCoordinatorConfiguration setName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("LockCoordinator name cannot be null or empty");
        }
        this.name = name;
        return this;
    }

    public String getLockId() {
        return this.lockId;
    }

    public LockCoordinatorConfiguration setLockId(String lockId) {
        if (lockId == null || lockId.trim().isEmpty()) {
            throw new IllegalArgumentException("LockCoordinator lockId cannot be null or empty");
        }
        this.lockId = lockId;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public LockCoordinatorConfiguration setClassName(String className) {
        this.className = className;
        return this;
    }

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public LockCoordinatorConfiguration setCheckPeriod(int checkPeriod) {
        if (checkPeriod <= 0) {
            throw new IllegalArgumentException("LockCoordinator checkPeriod must be positive, got: " + checkPeriod);
        }
        this.checkPeriod = checkPeriod;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "LockCoordinatorConfiguration{name='" + this.name + "', lockId='" + this.lockId + "', className='" + this.className + "', checkPeriod=" + this.checkPeriod + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

