/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.osgi;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.osgi.DataSourceTracker;
import org.apache.activemq.artemis.osgi.ProtocolTracker;
import org.apache.activemq.artemis.osgi.ServerTrackerCallBack;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"org.apache.activemq.artemis"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class OsgiBroker {
    private String name;
    private String configurationUrl;
    private String rolePrincipalClass;
    private String userPrincipalClass;
    private Map<String, ActiveMQComponent> components;
    private Map<String, ServiceRegistration<?>> registrations;
    private ServiceTracker tracker;
    private ServiceTracker dataSourceTracker;

    @Activate
    public void activate(ComponentContext cctx) throws Exception {
        BundleContext context = cctx.getBundleContext();
        Dictionary properties = cctx.getProperties();
        this.configurationUrl = this.getMandatory(properties, "config");
        this.name = this.getMandatory(properties, "name");
        this.rolePrincipalClass = (String)properties.get("rolePrincipalClass");
        this.userPrincipalClass = (String)properties.get("userPrincipalClass");
        String domain = this.getMandatory(properties, "domain");
        ActiveMQJAASSecurityManager security = new ActiveMQJAASSecurityManager(domain);
        if (this.rolePrincipalClass != null) {
            security.setRolePrincipalClass(this.rolePrincipalClass);
        }
        if (this.userPrincipalClass != null) {
            security.setUserPrincipalClass(this.userPrincipalClass);
        }
        String brokerInstance = null;
        String artemisDataDir = System.getProperty("artemis.data");
        if (artemisDataDir != null) {
            brokerInstance = artemisDataDir + "/artemis/" + this.name;
        } else {
            String karafDataDir = System.getProperty("karaf.data");
            if (karafDataDir != null) {
                brokerInstance = karafDataDir + "/artemis/" + this.name;
            }
        }
        FileConfiguration configuration = new FileConfiguration();
        if (brokerInstance != null) {
            configuration.setBrokerInstance(new File(brokerInstance));
        }
        FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(this.configurationUrl);
        fileDeploymentManager.addDeployable((Deployable)configuration).addDeployable((Deployable)jmsConfiguration).readConfiguration();
        this.components = fileDeploymentManager.buildService((ActiveMQSecurityManager)security, ManagementFactory.getPlatformMBeanServer(), null);
        ActiveMQServer server = (ActiveMQServer)this.components.get("core");
        String[] requiredProtocols = this.getRequiredProtocols(server.getConfiguration().getAcceptorConfigurations());
        ServerTrackerCallBackImpl callback = new ServerTrackerCallBackImpl(server, context, properties);
        StoreConfiguration storeConfiguration = server.getConfiguration().getStoreConfiguration();
        String dataSourceName = (String)String.class.cast(properties.get("dataSourceName"));
        if (storeConfiguration != null && storeConfiguration.getStoreType() == StoreConfiguration.StoreType.DATABASE && dataSourceName != null && !dataSourceName.isEmpty()) {
            callback.setDataSourceDependency(true);
            String filter = "(&(objectClass=javax.sql.DataSource)(osgi.jndi.service.name=" + dataSourceName + "))";
            DataSourceTracker trackerCust = new DataSourceTracker(this.name, context, (DatabaseStorageConfiguration)DatabaseStorageConfiguration.class.cast(storeConfiguration), callback);
            this.dataSourceTracker = new ServiceTracker(context, context.createFilter(filter), (ServiceTrackerCustomizer)trackerCust);
            this.dataSourceTracker.open();
        }
        ProtocolTracker trackerCust = new ProtocolTracker(this.name, context, requiredProtocols, callback);
        this.tracker = new ServiceTracker(context, ProtocolManagerFactory.class, (ServiceTrackerCustomizer)trackerCust);
        this.tracker.open();
    }

    private String getMandatory(Dictionary<String, ?> properties, String key) {
        String value = (String)properties.get(key);
        if (value == null) {
            throw new IllegalStateException("Property " + key + " must be set");
        }
        return value;
    }

    private String[] getRequiredProtocols(Set<TransportConfiguration> acceptors) {
        ArrayList<String> protocols = new ArrayList<String>();
        for (TransportConfiguration acceptor : acceptors) {
            String[] protocolsSplit;
            Object protocolsFromAcceptor = acceptor.getParams().get("protocols");
            if (protocolsFromAcceptor == null) continue;
            for (String protocol : protocolsSplit = protocolsFromAcceptor.toString().split(",")) {
                if (protocols.contains(protocol)) continue;
                protocols.add(protocol);
            }
        }
        return protocols.toArray(new String[protocols.size()]);
    }

    @Deactivate
    public void stop() throws Exception {
        this.tracker.close();
        if (this.dataSourceTracker != null) {
            this.dataSourceTracker.close();
        }
    }

    public Map<String, ActiveMQComponent> getComponents() {
        return this.components;
    }

    public List<ActiveMQComponent> getComponentsByStartOrder(Map<String, ActiveMQComponent> components) {
        ArrayList<ActiveMQComponent> activeMQComponents = new ArrayList<ActiveMQComponent>();
        ActiveMQComponent jmsComponent = components.get("jms");
        if (jmsComponent != null) {
            activeMQComponents.add(jmsComponent);
        }
        activeMQComponents.add(components.get("core"));
        return activeMQComponents;
    }

    public void register(BundleContext context, Dictionary<String, ?> properties) {
        this.registrations = new HashMap();
        for (Map.Entry<String, ActiveMQComponent> component : this.getComponents().entrySet()) {
            String[] classes = this.getInterfaces(component.getValue());
            Hashtable props = new Hashtable();
            Enumeration<String> keyEnum = properties.keys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                Object val = properties.get(key);
                props.put(key, val);
            }
            ServiceRegistration registration = context.registerService(classes, (Object)component.getValue(), props);
            this.registrations.put(component.getKey(), registration);
        }
    }

    private String[] getInterfaces(ActiveMQComponent value) {
        HashSet<String> interfaces = new HashSet<String>();
        this.getInterfaces(value.getClass(), interfaces);
        return interfaces.toArray(new String[interfaces.size()]);
    }

    private void getInterfaces(Class<?> clazz, Set<String> interfaces) {
        for (Class<?> itf : clazz.getInterfaces()) {
            if (!interfaces.add(itf.getName())) continue;
            this.getInterfaces(itf, interfaces);
        }
        if (clazz.getSuperclass() != null) {
            this.getInterfaces(clazz.getSuperclass(), interfaces);
        }
    }

    public void unregister() {
        if (this.registrations != null) {
            for (ServiceRegistration<?> reg : this.registrations.values()) {
                reg.unregister();
            }
        }
    }

    private class ServerTrackerCallBackImpl
    implements ServerTrackerCallBack {
        private volatile boolean dataSourceDependency = false;
        private final ActiveMQServer server;
        private final BundleContext context;
        private final Dictionary<String, Object> properties;

        ServerTrackerCallBackImpl(ActiveMQServer server, BundleContext context, Dictionary<String, Object> properties) {
            this.server = server;
            this.context = context;
            this.properties = properties;
        }

        @Override
        public void addFactory(ProtocolManagerFactory<Interceptor> pmf) {
            this.server.addProtocolManagerFactory(pmf);
        }

        @Override
        public void removeFactory(ProtocolManagerFactory<Interceptor> pmf) {
            this.server.removeProtocolManagerFactory(pmf);
        }

        public void stop() throws Exception {
            ActiveMQComponent[] mqComponents = new ActiveMQComponent[OsgiBroker.this.components.size()];
            OsgiBroker.this.components.values().toArray(mqComponents);
            for (int i = mqComponents.length - 1; i >= 0; --i) {
                mqComponents[i].stop();
            }
            OsgiBroker.this.unregister();
        }

        public void start() throws Exception {
            if (!this.dataSourceDependency) {
                List<ActiveMQComponent> componentsByStartOrder = OsgiBroker.this.getComponentsByStartOrder(OsgiBroker.this.components);
                for (ActiveMQComponent component : componentsByStartOrder) {
                    component.start();
                }
                OsgiBroker.this.register(this.context, this.properties);
            }
        }

        public boolean isStarted() {
            return this.server.isStarted();
        }

        @Override
        public void setDataSourceDependency(boolean dataSourceDependency) {
            this.dataSourceDependency = dataSourceDependency;
        }
    }
}

