/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.spi.InvalidPropertyException;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;

public final class ActiveMQActivationValidationUtils {
    private ActiveMQActivationValidationUtils() {
    }

    public static int validateAcknowledgeMode(String value) {
        if ("DUPS_OK_ACKNOWLEDGE".equalsIgnoreCase(value) || "Dups-ok-acknowledge".equalsIgnoreCase(value)) {
            return 3;
        }
        if ("AUTO_ACKNOWLEDGE".equalsIgnoreCase(value) || "Auto-acknowledge".equalsIgnoreCase(value)) {
            return 1;
        }
        throw new IllegalArgumentException(value);
    }

    public static void validate(String destination, String destinationType, Boolean subscriptionDurability, String subscriptionName) throws InvalidPropertyException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (destination == null || destination.trim().isEmpty()) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
                errorMessages.add("Destination is mandatory.");
            }
            if (destinationType != null && !Topic.class.getName().equals(destinationType) && !Queue.class.getName().equals(destinationType)) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
                errorMessages.add("If set, the destinationType must be either 'javax.jms.Topic' or 'javax.jms.Queue'.");
            }
            if ((destinationType == null || destinationType.isEmpty() || Topic.class.getName().equals(destinationType)) && subscriptionDurability.booleanValue() && (subscriptionName == null || subscriptionName.isEmpty())) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
                errorMessages.add("If subscription is durable then subscription name must be specified.");
            }
        }
        catch (IntrospectionException e) {
            ActiveMQRALogger.LOGGER.unableToValidateProperties(e);
        }
        ActiveMQActivationValidationUtils.buildAndThrowExceptionIfNeeded(propsNotSet, errorMessages);
    }

    private static void buildAndThrowExceptionIfNeeded(List<PropertyDescriptor> propsNotSet, List<String> errorMessages) throws InvalidPropertyException {
        if (!propsNotSet.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Invalid settings:");
            for (String errorMessage : errorMessages) {
                b.append(" ");
                b.append(errorMessage);
            }
            InvalidPropertyException e = new InvalidPropertyException(b.toString());
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }
}

