/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessagePull;

public class AMQCompositeConsumerBrokerExchange
extends AMQConsumerBrokerExchange {
    private final Map<ActiveMQDestination, AMQConsumer> consumerMap = new HashMap<ActiveMQDestination, AMQConsumer>();

    public AMQCompositeConsumerBrokerExchange(AMQSession amqSession, List<AMQConsumer> consumerList) {
        super(amqSession);
        for (AMQConsumer consumer : consumerList) {
            this.consumerMap.put(consumer.getOpenwireDestination(), consumer);
        }
    }

    @Override
    public void processMessagePull(MessagePull messagePull) throws Exception {
        AMQConsumer amqConsumer = this.consumerMap.get(messagePull.getDestination());
        if (amqConsumer != null) {
            amqConsumer.processMessagePull(messagePull);
        }
    }

    @Override
    public void acknowledge(MessageAck ack) throws Exception {
        AMQConsumer amqConsumer = this.consumerMap.get(ack.getDestination());
        if (amqConsumer != null) {
            amqConsumer.acknowledge(ack);
        }
    }

    @Override
    public void removeConsumer() throws Exception {
        for (AMQConsumer amqConsumer : this.consumerMap.values()) {
            amqConsumer.removeConsumer();
        }
    }

    @Override
    public void updateConsumerPrefetchSize(int prefetch) {
        for (AMQConsumer amqConsumer : this.consumerMap.values()) {
            amqConsumer.setPrefetchSize(prefetch);
        }
    }
}

