/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs.annotation.processor;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.activemq.artemis.logs.annotation.GetLogger;
import org.apache.activemq.artemis.logs.annotation.LogBundle;
import org.apache.activemq.artemis.logs.annotation.LogMessage;
import org.apache.activemq.artemis.logs.annotation.Message;

@SupportedAnnotationTypes(value={"org.apache.activemq.artemis.logs.annotation.LogBundle"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class LogAnnotationProcessor
extends AbstractProcessor {
    private static final boolean DEBUG;

    protected static void debug(String debugMessage) {
        if (DEBUG) {
            System.out.println(debugMessage);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<Integer, String> messages = new HashMap<Integer, String>();
        try {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    TypeElement annotatedType = (TypeElement)element;
                    LogBundle bundleAnnotation = annotatedType.getAnnotation(LogBundle.class);
                    LogAnnotationProcessor.validateRetiredIDsAreValidAndSorted(annotatedType, bundleAnnotation);
                    List<Integer> activeIDs = LogAnnotationProcessor.collectActiveIDs(annotatedType);
                    String fullClassName = String.valueOf(annotatedType.getQualifiedName()) + "_impl";
                    String interfaceName = annotatedType.getSimpleName().toString();
                    String simpleClassName = interfaceName + "_impl";
                    JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(fullClassName, new Element[0]);
                    if (DEBUG) {
                        LogAnnotationProcessor.debug("");
                        LogAnnotationProcessor.debug("*******************************************************************************************************************************");
                        LogAnnotationProcessor.debug("processing " + fullClassName + ", generating: " + fileObject.getName());
                    }
                    PrintWriter writerOutput = new PrintWriter(fileObject.openWriter());
                    writerOutput.println("/* This class is auto generated by " + LogAnnotationProcessor.class.getCanonicalName());
                    writerOutput.println("   and it inherits whatever license is declared at " + String.valueOf(annotatedType) + " */");
                    writerOutput.println();
                    writerOutput.println("package " + String.valueOf(annotatedType.getEnclosingElement()) + ";");
                    writerOutput.println();
                    writerOutput.println("import org.slf4j.Logger;");
                    writerOutput.println("import org.slf4j.LoggerFactory;");
                    writerOutput.println("import org.slf4j.helpers.FormattingTuple;");
                    writerOutput.println("import org.slf4j.helpers.MessageFormatter;");
                    writerOutput.println();
                    writerOutput.println("// " + bundleAnnotation.toString());
                    writerOutput.println("public class " + simpleClassName + " implements " + interfaceName);
                    writerOutput.println("{");
                    writerOutput.println("   private final Logger logger;");
                    writerOutput.println();
                    writerOutput.println("   private static void _copyStackTraceMinusOne(final Throwable e) {");
                    writerOutput.println("      final StackTraceElement[] st = e.getStackTrace();");
                    writerOutput.println("      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));");
                    writerOutput.println("   }");
                    writerOutput.println();
                    writerOutput.println("   public " + simpleClassName + "(Logger logger) {");
                    writerOutput.println("      this.logger = logger;");
                    writerOutput.println("   }");
                    writerOutput.println();
                    for (Element element2 : annotatedType.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.METHOD) continue;
                        ExecutableElement executableMember = (ExecutableElement)element2;
                        Message messageAnnotation = element2.getAnnotation(Message.class);
                        LogMessage logAnnotation = element2.getAnnotation(LogMessage.class);
                        GetLogger getLogger = element2.getAnnotation(GetLogger.class);
                        if (DEBUG) {
                            LogAnnotationProcessor.debug("Generating " + String.valueOf(executableMember));
                        }
                        int generatedPaths = 0;
                        if (messageAnnotation != null) {
                            LogAnnotationProcessor.validateRegexID(bundleAnnotation.regexID(), executableMember, messageAnnotation.id());
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + String.valueOf(messageAnnotation));
                            }
                            LogAnnotationProcessor.generateMessage(bundleAnnotation, writerOutput, executableMember, messageAnnotation, messages, activeIDs);
                        }
                        if (logAnnotation != null) {
                            LogAnnotationProcessor.validateRegexID(bundleAnnotation.regexID(), executableMember, logAnnotation.id());
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + String.valueOf(logAnnotation));
                            }
                            LogAnnotationProcessor.generateLogger(bundleAnnotation, writerOutput, executableMember, logAnnotation, messages, activeIDs);
                        }
                        if (getLogger != null) {
                            ++generatedPaths;
                            if (DEBUG) {
                                LogAnnotationProcessor.debug("... annotated with " + String.valueOf(getLogger));
                            }
                            LogAnnotationProcessor.generateGetLogger(bundleAnnotation, writerOutput, executableMember, getLogger);
                        }
                        if (generatedPaths <= 1) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot use combined annotations  on " + String.valueOf(executableMember));
                        return false;
                    }
                    writerOutput.println("}");
                    writerOutput.close();
                    if (!DEBUG) continue;
                    LogAnnotationProcessor.debug("done processing " + fullClassName);
                    LogAnnotationProcessor.debug("*******************************************************************************************************************************");
                    LogAnnotationProcessor.debug("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private static void validateRegexID(String regexID, ExecutableElement executableMember, long id) {
        if (!LogAnnotationProcessor.isAllowedIDValue(regexID, id)) {
            String enclosingClass = executableMember.getEnclosingElement().toString();
            throw new IllegalArgumentException(enclosingClass + ": Code " + id + " does not match regular expression specified on the LogBundle: " + regexID);
        }
    }

    private static boolean isAllowedIDValue(String regexID, long id) {
        if (regexID != null && !regexID.isEmpty()) {
            String toStringID = Long.toString(id);
            return toStringID.matches(regexID);
        }
        return true;
    }

    private static void generateMessage(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, Message messageAnnotation, Map<Integer, String> processedMessages, List<Integer> activeIDs) {
        LogAnnotationProcessor.verifyIdNotRetiredOrProcessedPreviously(bundleAnnotation, executableMember, messageAnnotation.id(), messageAnnotation.value(), processedMessages, activeIDs);
        LogAnnotationProcessor.verifyMessagePlaceholders(messageAnnotation.value(), executableMember);
        processedMessages.put(messageAnnotation.id(), messageAnnotation.value());
        writerOutput.println("   // " + LogAnnotationProcessor.encodeSpecialChars(messageAnnotation.toString()));
        writerOutput.println("   @Override");
        writerOutput.write("   public " + String.valueOf(executableMember.getReturnType()) + " " + String.valueOf(executableMember.getSimpleName()) + "(");
        Iterator<? extends VariableElement> parameters = executableMember.getParameters().iterator();
        boolean hasParameters = false;
        VariableElement exceptionParameter = null;
        StringBuilder callList = new StringBuilder();
        while (parameters.hasNext()) {
            hasParameters = true;
            VariableElement parameter = parameters.next();
            boolean isException = LogAnnotationProcessor.verifyIfExceptionArgument(executableMember, parameter, parameters.hasNext(), exceptionParameter != null);
            if (isException) {
                exceptionParameter = parameter;
            }
            writerOutput.write(String.valueOf(parameter.asType()) + " " + String.valueOf(parameter.getSimpleName()));
            callList.append(parameter.getSimpleName());
            if (!parameters.hasNext()) continue;
            writerOutput.write(", ");
            callList.append(", ");
        }
        writerOutput.println(") {");
        String formattingString = LogAnnotationProcessor.encodeSpecialChars(bundleAnnotation.projectCode() + messageAnnotation.id() + ": " + messageAnnotation.value());
        if (!hasParameters) {
            writerOutput.println("      String returnString = \"" + formattingString + "\";");
        } else {
            writerOutput.println("      String returnString = MessageFormatter.arrayFormat(\"" + formattingString + "\", new Object[]{" + String.valueOf(callList) + "}).getMessage();");
        }
        if (executableMember.getReturnType().toString().equals(String.class.getName())) {
            writerOutput.println("      return returnString;");
        } else {
            writerOutput.println();
            writerOutput.println("      {");
            String exceptionVariableName = "objReturn_" + String.valueOf(executableMember.getSimpleName());
            writerOutput.println("         " + executableMember.getReturnType().toString() + " " + exceptionVariableName + " = new " + executableMember.getReturnType().toString() + "(returnString);");
            if (exceptionParameter != null) {
                writerOutput.println("         " + exceptionVariableName + ".initCause(" + String.valueOf(exceptionParameter.getSimpleName()) + ");");
            }
            writerOutput.println("         _copyStackTraceMinusOne(" + exceptionVariableName + ");");
            writerOutput.println("         return " + exceptionVariableName + ";");
            writerOutput.println("      }");
        }
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static boolean isException(TypeMirror parameterType, VariableElement methodParameter) {
        DeclaredType declaredType;
        Element element;
        String parameterClazz;
        if (parameterType == null) {
            return false;
        }
        if (DEBUG && methodParameter != null) {
            LogAnnotationProcessor.debug("... checking if parameter \"" + String.valueOf(parameterType) + " " + String.valueOf(methodParameter) + "\" is an exception");
        }
        if ((parameterClazz = parameterType.toString()).equals("java.lang.Throwable") || parameterClazz.endsWith("Exception")) {
            if (DEBUG) {
                LogAnnotationProcessor.debug("... Class " + parameterClazz + " was considered an exception");
            }
            return true;
        }
        switch (parameterClazz) {
            case "java.lang.String": 
            case "java.lang.Object": 
            case "java.lang.Long": 
            case "java.lang.Integer": 
            case "java.lang.Number": 
            case "java.lang.Thread": 
            case "java.lang.ThreadGroup": 
            case "org.apache.activemq.artemis.api.core.SimpleString": 
            case "none": {
                if (DEBUG) {
                    LogAnnotationProcessor.debug("... " + parameterClazz + " is a known type, not an exception!");
                }
                return false;
            }
        }
        if (parameterType instanceof DeclaredType && (element = (declaredType = (DeclaredType)parameterType).asElement()) instanceof TypeElement) {
            TypeElement theElement = (TypeElement)element;
            if (DEBUG) {
                LogAnnotationProcessor.debug("... ... recursively inspecting super class for Exception on " + parameterClazz + ", looking at superClass " + String.valueOf(theElement.getSuperclass()));
            }
            return LogAnnotationProcessor.isException(theElement.getSuperclass(), null);
        }
        return false;
    }

    private static String encodeSpecialChars(String input) {
        return input.replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"");
    }

    private static void generateGetLogger(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, GetLogger loggerAnnotation) {
        writerOutput.println("   // " + loggerAnnotation.toString());
        writerOutput.println("   @Override");
        writerOutput.println("   public Logger " + String.valueOf(executableMember.getSimpleName()) + "() {");
        writerOutput.println("      return logger;");
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static void generateLogger(LogBundle bundleAnnotation, PrintWriter writerOutput, ExecutableElement executableMember, LogMessage messageAnnotation, Map<Integer, String> processedMessages, List<Integer> activeIDs) {
        Object loggerFieldName;
        LogAnnotationProcessor.verifyIdNotRetiredOrProcessedPreviously(bundleAnnotation, executableMember, messageAnnotation.id(), messageAnnotation.value(), processedMessages, activeIDs);
        LogAnnotationProcessor.verifyMessagePlaceholders(messageAnnotation.value(), executableMember);
        processedMessages.put(messageAnnotation.id(), messageAnnotation.value());
        if (messageAnnotation.loggerName().isBlank()) {
            loggerFieldName = "logger";
        } else {
            loggerFieldName = "logger_" + messageAnnotation.id();
            writerOutput.println("   private static final Logger " + (String)loggerFieldName + " = LoggerFactory.getLogger(\"" + messageAnnotation.loggerName() + "\");");
            writerOutput.println();
        }
        writerOutput.println("   // " + LogAnnotationProcessor.encodeSpecialChars(messageAnnotation.toString()));
        writerOutput.println("   @Override");
        writerOutput.write("   public void " + String.valueOf(executableMember.getSimpleName()) + "(");
        List<? extends VariableElement> parametersList = executableMember.getParameters();
        boolean hasParameters = false;
        VariableElement exceptionParameter = null;
        Iterator<? extends VariableElement> parameters = parametersList.iterator();
        while (parameters.hasNext()) {
            hasParameters = true;
            VariableElement parameter = parameters.next();
            boolean isException = LogAnnotationProcessor.verifyIfExceptionArgument(executableMember, parameter, parameters.hasNext(), exceptionParameter != null);
            if (isException) {
                exceptionParameter = parameter;
            }
            writerOutput.write(String.valueOf(parameter.asType()) + " " + String.valueOf(parameter.getSimpleName()));
            if (!parameters.hasNext()) continue;
            writerOutput.write(", ");
        }
        writerOutput.println(") {");
        StringBuilder callList = null;
        if (hasParameters) {
            callList = new StringBuilder();
            parameters = parametersList.iterator();
            while (parameters.hasNext()) {
                VariableElement parameter = parameters.next();
                callList.append(parameter.getSimpleName());
                if (!parameters.hasNext()) continue;
                callList.append(", ");
            }
        }
        String isEnabledMethodName = LogAnnotationProcessor.getLoggerIsEnabledMethodName(messageAnnotation);
        String methodName = LogAnnotationProcessor.getLoggerOutputMethodName(messageAnnotation);
        String formattingString = LogAnnotationProcessor.encodeSpecialChars(bundleAnnotation.projectCode() + messageAnnotation.id() + ": " + messageAnnotation.value());
        writerOutput.println("      if (" + (String)loggerFieldName + "." + isEnabledMethodName + "()) {");
        if (hasParameters) {
            writerOutput.println("         " + (String)loggerFieldName + "." + methodName + "(\"" + formattingString + "\", " + String.valueOf(callList) + ");");
        } else {
            writerOutput.println("         " + (String)loggerFieldName + "." + methodName + "(\"" + formattingString + "\");");
        }
        writerOutput.println("      }");
        writerOutput.println("   }");
        writerOutput.println();
    }

    private static String getLoggerOutputMethodName(LogMessage messageAnnotation) {
        return switch (messageAnnotation.level()) {
            case LogMessage.Level.WARN -> "warn";
            case LogMessage.Level.INFO -> "info";
            case LogMessage.Level.ERROR -> "error";
            case LogMessage.Level.DEBUG -> "debug";
            case LogMessage.Level.TRACE -> "trace";
            default -> throw new IllegalStateException("Illegal log level: " + String.valueOf((Object)messageAnnotation.level()));
        };
    }

    private static String getLoggerIsEnabledMethodName(LogMessage messageAnnotation) {
        return switch (messageAnnotation.level()) {
            case LogMessage.Level.WARN -> "isWarnEnabled";
            case LogMessage.Level.INFO -> "isInfoEnabled";
            case LogMessage.Level.ERROR -> "isErrorEnabled";
            case LogMessage.Level.DEBUG -> "isDebugEnabled";
            case LogMessage.Level.TRACE -> "isTraceEnabled";
            default -> throw new IllegalStateException("Illegal log level: " + String.valueOf((Object)messageAnnotation.level()));
        };
    }

    private static void tupples(String arg, char open, char close, Consumer<String> stringConsumer) {
        int openAt = -1;
        for (int i = 0; i < arg.length(); ++i) {
            char charAt = arg.charAt(i);
            if (charAt == open) {
                openAt = i;
                continue;
            }
            if (charAt != close) continue;
            if (openAt >= 0) {
                stringConsumer.accept(arg.substring(openAt + 1, i));
            }
            openAt = -1;
        }
    }

    private static void verifyMessagePlaceholders(String message, ExecutableElement holder) {
        Objects.requireNonNull(message, "message must not be null");
        LogAnnotationProcessor.tupples(message, '{', '}', tupple -> {
            if (!tupple.isEmpty()) {
                throw new IllegalArgumentException("Invalid placeholder argument {" + tupple + "} on message '" + message + "' as part of " + String.valueOf(holder) + "\nreplace it by {}");
            }
        });
        if (message.contains("%s") || message.contains("%d")) {
            throw new IllegalArgumentException("Cannot use %s or %d in loggers. Please use {} on message '" + message + "'");
        }
    }

    private static void verifyIdNotRetiredOrProcessedPreviously(LogBundle bundleAnnotation, ExecutableElement executableMember, Integer id, String message, Map<Integer, String> processedMessages, List<Integer> activeIDs) {
        Objects.requireNonNull(id, "id must not be null");
        boolean retiredID = LogAnnotationProcessor.isRetiredID(bundleAnnotation, id);
        if (processedMessages.containsKey(id) || retiredID) {
            StringBuilder failure = new StringBuilder();
            failure.append(executableMember.getEnclosingElement().toString()).append(": ");
            if (processedMessages.containsKey(id)) {
                String previousMessage = processedMessages.get(id);
                failure.append("ID ").append(id).append(" with message '").append(message).append("' was previously used already, to define message '").append(previousMessage).append("'. ");
            }
            if (retiredID) {
                failure.append("ID ").append(id).append(" was previously retired, another ID must be used. ");
            }
            Integer nextId = Collections.max(activeIDs) + 1;
            while (LogAnnotationProcessor.isRetiredID(bundleAnnotation, nextId)) {
                Integer n = nextId;
                nextId = nextId + 1;
            }
            if (LogAnnotationProcessor.isAllowedIDValue(bundleAnnotation.regexID(), nextId.intValue())) {
                failure.append("Consider trying ID ").append(nextId).append(" which is the next unused value.");
            } else {
                failure.append("There are no new IDs available within the given ID regex: " + bundleAnnotation.regexID());
            }
            throw new IllegalStateException(failure.toString());
        }
    }

    private static boolean isRetiredID(LogBundle bundleAnnotation, Integer id) {
        return Arrays.binarySearch(bundleAnnotation.retiredIDs(), id) >= 0;
    }

    private static boolean verifyIfExceptionArgument(ExecutableElement executableMember, VariableElement parameter, boolean hasMoreParams, boolean hasExistingException) {
        boolean isException = LogAnnotationProcessor.isException(parameter.asType(), parameter);
        if (DEBUG) {
            LogAnnotationProcessor.debug("Parameter " + String.valueOf(parameter) + (isException ? "is" : "is not") + " an exception");
        }
        if (isException) {
            if (hasMoreParams) {
                throw new IllegalArgumentException("Exception argument " + String.valueOf(parameter) + " has to be the last argument on the list. Look at: " + String.valueOf(executableMember));
            }
            if (hasExistingException) {
                throw new IllegalStateException("You can only have one exception argument defined per message/annotation, Look at: " + String.valueOf(executableMember));
            }
        }
        return isException;
    }

    private static void validateRetiredIDsAreValidAndSorted(TypeElement annotatedType, LogBundle bundleAnnotation) {
        int[] retiredIDs = bundleAnnotation.retiredIDs();
        if (retiredIDs.length == 0) {
            return;
        }
        String regexID = bundleAnnotation.regexID();
        for (int id : retiredIDs) {
            if (LogAnnotationProcessor.isAllowedIDValue(regexID, id)) continue;
            throw new IllegalArgumentException(String.valueOf(annotatedType) + ": The retiredIDs elements must each match the configured regexID. The ID " + id + " does not match: " + regexID);
        }
        int[] sortedRetiredIDs = Arrays.copyOf(retiredIDs, retiredIDs.length);
        Arrays.sort(sortedRetiredIDs);
        if (!Arrays.equals(retiredIDs, sortedRetiredIDs)) {
            StringBuilder sortedIDsMessage = new StringBuilder();
            sortedIDsMessage.append("{");
            int count = 1;
            for (int id : sortedRetiredIDs) {
                sortedIDsMessage.append(id);
                if (count == sortedRetiredIDs.length) continue;
                sortedIDsMessage.append(", ");
                ++count;
            }
            sortedIDsMessage.append("}");
            throw new IllegalArgumentException(String.valueOf(annotatedType) + ": The retiredIDs value must be sorted. Try using: " + sortedIDsMessage.toString());
        }
        LogAnnotationProcessor.debug("Found retired IDs: " + Arrays.toString(retiredIDs));
    }

    private static List<Integer> collectActiveIDs(TypeElement annotatedType) {
        ArrayList<Integer> activeIds = new ArrayList<Integer>();
        for (Element element : annotatedType.getEnclosedElements()) {
            LogMessage logAnnotation;
            if (element.getKind() != ElementKind.METHOD) continue;
            Message messageAnnotation = element.getAnnotation(Message.class);
            if (messageAnnotation != null) {
                activeIds.add(messageAnnotation.id());
            }
            if ((logAnnotation = element.getAnnotation(LogMessage.class)) == null) continue;
            activeIds.add(logAnnotation.id());
        }
        activeIds.sort(null);
        LogAnnotationProcessor.debug("Found active IDs: " + String.valueOf(activeIds));
        return activeIds;
    }

    static {
        boolean debugResult = false;
        try {
            String debugEnvVariable = System.getenv("ARTEMIS_LOG_ANNOTATION_PROCESSOR_DEBUG");
            if (debugEnvVariable != null) {
                debugResult = Boolean.parseBoolean(debugEnvVariable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEBUG = debugResult;
    }
}

