/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Average;

public class Credit {
    protected final Lock lock;
    protected final Condition credits_available;
    protected boolean done;
    protected long credits_left;
    protected int num_blockings;
    protected long last_credit_request;
    protected final Average avg_blockings = new Average();

    public Credit(long credits) {
        this(credits, new ReentrantLock());
    }

    public Credit(long credits, Lock lock) {
        this.credits_left = credits;
        this.lock = lock;
        this.credits_available = lock.newCondition();
    }

    public int getNumBlockings() {
        return this.num_blockings;
    }

    public long get() {
        this.lock.lock();
        try {
            long l = this.credits_left;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public double getAverageBlockTime() {
        return this.avg_blockings.getAverage();
    }

    public void resetStats() {
        this.num_blockings = 0;
        this.avg_blockings.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementIfEnoughCredits(Message msg, int credits, long timeout) {
        this.lock.lock();
        try {
            if (this.done) {
                boolean bl = false;
                return bl;
            }
            if (this.decrement(credits)) {
                boolean bl = true;
                return bl;
            }
            if (timeout <= 0L) {
                boolean bl = false;
                return bl;
            }
            long start = System.nanoTime();
            try {
                this.credits_available.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.done) {
                boolean bl = false;
                return bl;
            }
            ++this.num_blockings;
            this.avg_blockings.add(System.nanoTime() - start);
            boolean bl = this.decrement(credits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementAndGet(long credits, long min_credits, long max_credits) {
        this.lock.lock();
        try {
            this.credits_left = Math.max(0L, this.credits_left - credits);
            if (min_credits - this.credits_left >= 0L) {
                long credit_response = Math.min(max_credits, max_credits - this.credits_left);
                this.credits_left = max_credits;
                long l = credit_response;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long credits, long max_credits) {
        this.lock.lock();
        try {
            this.credits_left = Math.min(max_credits, this.credits_left + credits);
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credit reset() {
        this.lock.lock();
        try {
            if (!this.done) {
                this.done = true;
                this.credits_available.signalAll();
            }
            Credit credit = this;
            return credit;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needToSendCreditRequest(long max_block_time) {
        this.lock.lock();
        try {
            long current_time = System.nanoTime();
            if (current_time - this.last_credit_request >= TimeUnit.NANOSECONDS.convert(max_block_time, TimeUnit.MILLISECONDS)) {
                this.last_credit_request = current_time;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.valueOf(this.credits_left);
    }

    protected boolean decrement(long credits) {
        if (this.credits_left - credits >= 0L) {
            this.credits_left -= credits;
            return true;
        }
        return false;
    }
}

