/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.PropertyConverters;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Discovery;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingData;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TUNNEL;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.RouterStub;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.RouterStubManager;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NameCache;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Responses;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class TCPGOSSIP
extends Discovery
implements RouterStub.MembersNotification {
    @Property(description="Max time for socket creation. Default is 1000 ms", type=AttributeType.TIME)
    protected int sock_conn_timeout = 1000;
    @Property(description="Interval (ms) by which a disconnected stub attempts to reconnect to the GossipRouter", type=AttributeType.TIME)
    protected long reconnect_interval = 10000L;
    @Property(description="Whether to use blocking (false) or non-blocking (true) connections. If GossipRouter is used, this needs to be false; if GossipRouterNio is used, it needs to be true")
    protected boolean use_nio;
    private final List<InetSocketAddress> initial_hosts = new CopyOnWriteArrayList<InetSocketAddress>();
    protected volatile RouterStubManager stubManager;

    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts2.class)
    public TCPGOSSIP setInitialHosts(List<InetSocketAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        this.initial_hosts.addAll(hosts);
        return this;
    }

    public TCPGOSSIP setInitialHosts(Collection<InetSocketAddress> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        this.initial_hosts.addAll(hosts);
        return this;
    }

    public List<InetSocketAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @ManagedAttribute(description="The list of GossipRouters to connect to")
    public String initialHosts() {
        return this.initial_hosts.toString();
    }

    public long sockConnTimeout() {
        return this.sock_conn_timeout;
    }

    public TCPGOSSIP sockConnTimeout(int t) {
        this.sock_conn_timeout = t;
        return this;
    }

    public long reconnectInterval() {
        return this.reconnect_interval;
    }

    public TCPGOSSIP reconnectInterval(long r) {
        this.reconnect_interval = r;
        return this;
    }

    public RouterStubManager getStubManager() {
        return this.stubManager;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this.log, this.timer).useNio(this.use_nio);
        TP tp = this.getTransport();
        if (tp instanceof TUNNEL) {
            throw new IllegalStateException("TCPGOSSIP cannot be used with TUNNEL; use either TUNNEL:PING or TCP:TCPGOSSIP as valid configurations");
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.stubManager.disconnectStubs();
    }

    @Override
    public void destroy() {
        if (this.stubManager != null) {
            this.stubManager.destroyStubs();
        }
        super.destroy();
    }

    @Override
    public void handleConnect() {
        if (this.cluster_name == null || this.local_addr == null) {
            this.log.error(Util.getMessage("GroupaddrOrLocaladdrIsNullCannotRegisterWithGossipRouterS"));
        } else {
            InetAddress bind_addr = this.getTransport().getBindAddress();
            this.log.trace("registering " + this.local_addr + " under " + this.cluster_name + " with GossipRouter");
            this.stubManager.destroyStubs();
            PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
            this.stubManager = new RouterStubManager(this.log, this.timer, this.cluster_name, this.local_addr, NameCache.get(this.local_addr), physical_addr, this.reconnect_interval).useNio(this.use_nio);
            for (InetSocketAddress host : this.initial_hosts) {
                InetSocketAddress target = host.isUnresolved() ? new InetSocketAddress(host.getHostString(), host.getPort()) : new InetSocketAddress(host.getAddress(), host.getPort());
                RouterStub stub = this.stubManager.createAndRegisterStub(new InetSocketAddress(bind_addr, 0), target);
                stub.socketConnectionTimeout(this.sock_conn_timeout);
            }
            this.stubManager.connectStubs();
        }
    }

    @ManagedOperation(description="Prints all stubs and the reconnect list")
    public String print() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.print() : "n/a";
    }

    @ManagedOperation(description="Prints all currently connected stubs")
    public String printStubs() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printStubs() : "n/a";
    }

    @ManagedOperation(description="Prints the reconnect list")
    public String printReconnectList() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printReconnectList() : "n/a";
    }

    @Override
    public void handleDisconnect() {
        this.stubManager.disconnectStubs();
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        if (this.cluster_name == null) {
            this.log.error(Util.getMessage("ClusternameIsNullCannotGetMembership"));
            return;
        }
        this.log.trace("fetching members from GossipRouter(s)");
        this.stubManager.forEach(stub -> {
            try {
                stub.getMembers(this.cluster_name, this);
            }
            catch (Throwable t) {
                this.log.warn("failed fetching members from %s: %s, cause: %s", stub.gossipRouterAddress(), t, t.getCause());
            }
        });
    }

    @Override
    public void members(List<PingData> mbrs) {
        PhysicalAddress own_physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, false, NameCache.get(this.local_addr), own_physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        Set physical_addrs = mbrs.stream().filter(ping_data -> ping_data != null && ping_data.getPhysicalAddr() != null).map(PingData::getPhysicalAddr).collect(Collectors.toSet());
        for (PhysicalAddress physical_addr : physical_addrs) {
            if (own_physical_addr.equals(physical_addr)) continue;
            Message msg = new BytesMessage(physical_addr).putHeader(this.id, hdr).setArray(TCPGOSSIP.marshal(data)).setFlag(Message.Flag.DONT_BUNDLE, Message.Flag.OOB);
            this.log.trace("%s: sending discovery request to %s", this.local_addr, msg.getDest());
            this.down_prot.down(msg);
        }
    }

    @ManagedOperation
    public void addInitialHost(String hostname, int port) {
        this.removeInitialHost(hostname, port);
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        this.initial_hosts.add(isa);
        this.stubManager.createAndRegisterStub(null, new InetSocketAddress(isa.getAddress(), isa.getPort()));
        this.stubManager.connectStubs();
    }

    @ManagedOperation
    public boolean removeInitialHost(String hostname, int port) {
        InetSocketAddress isa = new InetSocketAddress(hostname, port);
        this.stubManager.unregisterStub(new InetSocketAddress(isa.getAddress(), isa.getPort()));
        return this.initial_hosts.remove(isa);
    }
}

