/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.BaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.Client;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.Connection;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.ConnectionListener;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.NioClient;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpClient;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class PubClient
implements Receiver,
ConnectionListener {
    protected BaseServer client;
    protected final String name;
    protected volatile boolean running = true;
    protected InputStream in;

    public PubClient(String name) {
        this.name = name;
    }

    @Override
    public void receive(Address sender, ByteBuffer buf) {
        byte[] buffer = buf.array();
        String msg = new String(buffer, buf.arrayOffset(), buf.remaining());
        System.out.printf("-- %s\n", msg);
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        String msg = new String(buf, offset, length);
        System.out.printf("-- %s\n", msg);
    }

    @Override
    public void receive(Address sender, DataInput in, int length) throws Exception {
        byte[] buf = new byte[length];
        in.readFully(buf);
        String msg = new String(buf);
        System.out.printf("-- %s\n", msg);
    }

    @Override
    public void connectionClosed(Connection conn) {
        this.client.stop();
        this.running = false;
        Util.close((Closeable)this.in);
        System.out.printf("connection to %s closed", conn.peerAddress());
    }

    @Override
    public void connectionEstablished(Connection conn) {
    }

    protected void start(InetAddress srv_addr, int srv_port, boolean nio) throws Exception {
        this.client = nio ? new NioClient(InetAddress.getLocalHost(), 0, srv_addr, srv_port) : new TcpClient(InetAddress.getLocalHost(), 0, srv_addr, srv_port);
        this.client.receiver(this);
        this.client.addConnectionListener(this);
        this.client.start();
        this.send(String.format("%s joined", this.name));
        this.eventLoop();
        this.client.stop();
    }

    protected void eventLoop() {
        this.in = new BufferedInputStream(System.in);
        while (this.running) {
            try {
                System.out.print("> ");
                System.out.flush();
                String line = Util.readLine(this.in);
                if (line == null || line.startsWith("quit") || line.startsWith("exit")) break;
                this.send(String.format("%s: %s", this.name, line));
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    protected void send(String str) throws Exception {
        byte[] buf = str.getBytes();
        ((Client)((Object)this.client)).send(buf, 0, buf.length);
    }

    public static void main(String[] args) throws Exception {
        InetAddress server_addr = InetAddress.getLocalHost();
        int server_port = 7500;
        String name = null;
        boolean nio = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-addr")) {
                server_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                server_port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-nio")) {
                nio = Boolean.parseBoolean(args[++i]);
                continue;
            }
            PubClient.help();
            return;
        }
        if (name == null) {
            throw new IllegalStateException("name needs to be defined");
        }
        PubClient client = new PubClient(name);
        client.start(server_addr, server_port, nio);
    }

    protected static void help() {
        System.out.println("PubClient -name name [-addr <server address>] [-port <server port>] [-nio true|false]");
    }
}

