/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.MBeanServer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.ChannelListener;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.MergeView;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.demos.DrawCommand;
import org.apache.activemq.artemis.shaded.org.jgroups.jmx.JmxConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.AddressGenerator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.OneTimeAddressGenerator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Draw
implements Receiver,
ActionListener,
ChannelListener {
    protected String cluster_name = "draw";
    private JChannel channel = null;
    private int member_size = 1;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Color draw_color = this.selectColor();
    private static final Color background_color = Color.white;
    boolean no_channel = false;
    boolean jmx;
    private boolean use_state = false;
    private long state_timeout = 5000L;
    private boolean use_unicasts = false;
    protected boolean send_own_state_on_merge = true;
    private final List<Address> members = new ArrayList<Address>();

    public Draw(String props, boolean no_channel, boolean jmx, boolean use_state, long state_timeout, boolean use_unicasts, String name, boolean send_own_state_on_merge, AddressGenerator gen) throws Exception {
        this.no_channel = no_channel;
        this.jmx = jmx;
        this.use_state = use_state;
        this.state_timeout = state_timeout;
        this.use_unicasts = use_unicasts;
        if (no_channel) {
            return;
        }
        this.channel = new JChannel(props).addAddressGenerator(gen).setName(name);
        this.channel.setReceiver(this).addChannelListener(this);
        this.send_own_state_on_merge = send_own_state_on_merge;
    }

    public Draw(JChannel channel) throws Exception {
        this.channel = channel;
        channel.setReceiver(this);
        channel.addChannelListener(this);
    }

    public Draw(JChannel channel, boolean use_state, long state_timeout) throws Exception {
        this.channel = channel;
        channel.setReceiver(this);
        channel.addChannelListener(this);
        this.use_state = use_state;
        this.state_timeout = state_timeout;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String clustername) {
        if (clustername != null) {
            this.cluster_name = clustername;
        }
    }

    public static void main(String[] args) {
        Draw draw = null;
        String props = null;
        boolean no_channel = false;
        boolean jmx = true;
        boolean use_state = false;
        String group_name = null;
        long state_timeout = 5000L;
        boolean use_unicasts = false;
        String name = null;
        boolean send_own_state_on_merge = true;
        OneTimeAddressGenerator generator = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Draw.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-no_channel".equals(args[i])) {
                no_channel = true;
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if ("-clustername".equals(args[i])) {
                group_name = args[++i];
                continue;
            }
            if ("-state".equals(args[i])) {
                use_state = true;
                continue;
            }
            if ("-timeout".equals(args[i])) {
                state_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if ("-use_unicasts".equals(args[i])) {
                use_unicasts = true;
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            if ("-send_own_state_on_merge".equals(args[i])) {
                send_own_state_on_merge = Boolean.getBoolean(args[++i]);
                continue;
            }
            if ("-uuid".equals(args[i])) {
                generator = new OneTimeAddressGenerator(Long.parseLong(args[++i]));
                continue;
            }
            Draw.help();
            return;
        }
        try {
            draw = new Draw(props, no_channel, jmx, use_state, state_timeout, use_unicasts, name, send_own_state_on_merge, generator);
            if (group_name != null) {
                draw.setClusterName(group_name);
            }
            draw.go();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("\nDraw [-help] [-no_channel] [-props <protocol stack definition>] [-clustername <name>] [-state] [-timeout <state timeout>] [-use_unicasts] [-jmx <true | false>] [-name <logical name>] [-send_own_state_on_merge true|false] [-uuid <UUID>]");
        System.out.println("-no_channel: doesn't use JGroups at all, any drawing will be relected on the whiteboard directly");
        System.out.println("-props: argument can be an old-style protocol stack specification, or it can be a URL. In the latter case, the protocol specification will be read from the URL\n");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt() % 255);
        int green = Math.abs(this.random.nextInt() % 255);
        int blue = Math.abs(this.random.nextInt() % 255);
        return new Color(red, green, blue);
    }

    private void sendToAll(byte[] buf) throws Exception {
        for (Address mbr : this.members) {
            this.channel.send(new BytesMessage(mbr, buf));
        }
    }

    public void go() throws Exception {
        if (!this.no_channel && !this.use_state) {
            this.channel.connect(this.cluster_name);
        }
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.panel = new DrawPanel(this.use_state);
        this.panel.setBackground(background_color);
        this.sub_panel = new JPanel();
        this.mainFrame.getContentPane().add("Center", this.panel);
        this.clear_button = new JButton("Clear");
        this.clear_button.addActionListener(this);
        this.leave_button = new JButton("Leave");
        this.leave_button.addActionListener(this);
        this.sub_panel.add("South", this.clear_button);
        this.sub_panel.add("South", this.leave_button);
        this.mainFrame.getContentPane().add("South", this.sub_panel);
        this.mainFrame.setBackground(background_color);
        this.clear_button.setForeground(Color.blue);
        this.leave_button.setForeground(Color.blue);
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(250, 250));
        if (!this.no_channel && this.use_state) {
            this.channel.connect(this.cluster_name, null, this.state_timeout);
        }
        this.mainFrame.setVisible(true);
        this.setTitle();
    }

    void setTitle(String title) {
        Object tmp = "";
        if (this.no_channel) {
            this.mainFrame.setTitle(" Draw Demo ");
            return;
        }
        if (title != null) {
            this.mainFrame.setTitle(title);
        } else {
            if (this.channel.getAddress() != null) {
                tmp = (String)tmp + this.channel.getAddress();
            }
            tmp = (String)tmp + " (" + this.member_size + ")";
            this.mainFrame.setTitle((String)tmp);
        }
    }

    void setTitle() {
        this.setTitle(null);
    }

    @Override
    public void receive(Message msg) {
        byte[] buf = msg.getArray();
        if (buf == null) {
            System.err.printf("%s: received null buffer from %s, headers: %s\n", this.channel.getAddress(), msg.getSrc(), msg.printHeaders());
            return;
        }
        try {
            DrawCommand comm = Util.streamableFromByteBuffer(DrawCommand::new, buf, msg.getOffset(), msg.getLength());
            switch (comm.mode) {
                case 1: {
                    if (this.panel != null) {
                        this.panel.drawPoint(comm);
                    }
                    break;
                }
                case 2: {
                    this.clearPanel();
                    break;
                }
                default: {
                    System.err.println("***** received invalid draw command " + comm.mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewAccepted(View v) {
        this.member_size = v.size();
        if (this.mainFrame != null) {
            this.setTitle();
        }
        this.members.clear();
        this.members.addAll(v.getMembers());
        if (v instanceof MergeView) {
            System.out.println("** " + v);
            if (this.use_state && !this.members.isEmpty()) {
                Address coord = this.members.get(0);
                Address local_addr = this.channel.getAddress();
                if (local_addr != null && !local_addr.equals(coord)) {
                    try {
                        LinkedHashMap<Point, Color> copy = null;
                        if (this.send_own_state_on_merge) {
                            Map<Point, Color> map = this.panel.state;
                            synchronized (map) {
                                copy = new LinkedHashMap<Point, Color>(this.panel.state);
                            }
                        }
                        System.out.println("fetching state from " + coord);
                        this.channel.getState(coord, 5000L);
                        if (copy != null) {
                            this.sendOwnState(copy);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("** View=" + v);
        }
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        this.panel.writeState(ostream);
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        this.panel.readState(istream);
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            if (this.use_unicasts) {
                this.sendToAll(buf);
            } else {
                this.channel.send(new BytesMessage(null, buf));
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command;
        switch (command = e.getActionCommand()) {
            case "Clear": {
                if (this.no_channel) {
                    this.clearPanel();
                    return;
                }
                this.sendClearPanelMsg();
                break;
            }
            case "Leave": {
                this.stop();
                break;
            }
            default: {
                System.out.println("Unknown action");
            }
        }
    }

    public void stop() {
        if (!this.no_channel) {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    protected void sendOwnState(Map<Point, Color> copy) {
        if (copy == null) {
            return;
        }
        for (Point point : copy.keySet()) {
            DrawCommand comm = new DrawCommand(1, point.x, point.y, this.draw_color.getRGB());
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                if (this.use_unicasts) {
                    this.sendToAll(buf);
                    continue;
                }
                this.channel.send(new BytesMessage(null, buf));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    @Override
    public void channelConnected(JChannel channel) {
        if (this.jmx) {
            Util.registerChannel(channel, "jgroups");
        }
    }

    @Override
    public void channelDisconnected(JChannel channel) {
        MBeanServer server;
        if (this.jmx && (server = Util.getMBeanServer()) != null) {
            try {
                JmxConfigurator.unregisterChannel(channel, server, this.cluster_name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        protected final Dimension preferred_size = new Dimension(235, 170);
        protected Image img;
        protected Dimension d;
        protected Dimension imgsize;
        protected Graphics gr;
        protected final Map<Point, Color> state;

        public DrawPanel(boolean use_state) {
            this.state = use_state ? new LinkedHashMap<Point, Color>() : null;
            this.createOffscreenImage(false);
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DrawPanel.this.getWidth() <= 0 || DrawPanel.this.getHeight() <= 0) {
                        return;
                    }
                    DrawPanel.this.createOffscreenImage(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeState(OutputStream outstream) throws IOException {
            if (this.state == null) {
                return;
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(outstream));
                dos.writeInt(this.state.size());
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point point = entry.getKey();
                    Color col = entry.getValue();
                    dos.writeInt(point.x);
                    dos.writeInt(point.y);
                    dos.writeInt(col.getRGB());
                }
                dos.flush();
                System.out.println("wrote " + this.state.size() + " elements");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readState(InputStream instream) throws IOException {
            DataInputStream in = new DataInputStream(new BufferedInputStream(instream));
            LinkedHashMap<Point, Color> new_state = new LinkedHashMap<Point, Color>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                Point point = new Point(in.readInt(), in.readInt());
                Color col = new Color(in.readInt());
                new_state.put(point, col);
            }
            Map<Point, Color> map = this.state;
            synchronized (map) {
                this.state.clear();
                this.state.putAll(new_state);
                System.out.println("read " + this.state.size() + " elements");
                this.createOffscreenImage(true);
            }
        }

        void createOffscreenImage(boolean discard_image) {
            this.d = this.getSize();
            if (discard_image) {
                this.img = null;
                this.imgsize = null;
            }
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                if (this.img != null) {
                    this.gr = this.img.getGraphics();
                    if (this.gr != null && this.state != null) {
                        this.drawState();
                    }
                }
                this.imgsize = this.d;
            }
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, Draw.this.draw_color.getRGB());
            if (Draw.this.no_channel) {
                this.drawPoint(comm);
                return;
            }
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                if (Draw.this.use_unicasts) {
                    Draw.this.sendToAll(buf);
                } else {
                    Draw.this.channel.send(new BytesMessage(null, buf));
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawPoint(DrawCommand c) {
            if (c == null || this.gr == null) {
                return;
            }
            Color col = new Color(c.rgb);
            this.gr.setColor(col);
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.put(new Point(c.x, c.y), col);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.gr == null) {
                return;
            }
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
            if (this.state != null) {
                Map<Point, Color> map = this.state;
                synchronized (map) {
                    this.state.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawState() {
            Map<Point, Color> map = this.state;
            synchronized (map) {
                for (Map.Entry<Point, Color> entry : this.state.entrySet()) {
                    Point pt = entry.getKey();
                    Color col = entry.getValue();
                    this.gr.setColor(col);
                    this.gr.fillOval(pt.x, pt.y, 10, 10);
                }
            }
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

