/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import org.apache.activemq.artemis.utils.sm.SecurityManagerShim;

public class DefaultConnectionProperties {
    public static final String AMQ_HOST = "AMQ_HOST";
    public static final String AMQ_PORT = "AMQ_PORT";
    public static final String AMQ_USER = "AMQ_USER";
    public static final String AMQ_PASSWORD = "AMQ_PASSWORD";
    public static final String AMQ_PASSWORD_CODEC = "AMQ_PASSWORD_CODEC";
    public static final String BROKER_BIND_URL = "BROKER_BIND_URL";
    public static final String PREFIX = "org.apache.activemq.";
    public static String DEFAULT_BROKER_HOST;
    public static int DEFAULT_BROKER_PORT;
    public static String DEFAULT_BROKER_BIND_URL;
    public static String DEFAULT_BROKER_URL;
    public static String DEFAULT_USER;
    public static String DEFAULT_PASSWORD;
    public static String DEFAULT_PASSWORD_CODEC;

    static String getProperty(String defaultValue, String ... propertyNames) {
        return SecurityManagerShim.doPrivileged(() -> {
            for (String name : propertyNames) {
                String property = System.getProperty(name);
                if (property == null || property.isEmpty()) continue;
                return property;
            }
            return defaultValue;
        });
    }

    public static void initialize() {
        String host = DefaultConnectionProperties.getProperty("localhost", AMQ_HOST, "org.apache.activemq.AMQ_HOST");
        String port = DefaultConnectionProperties.getProperty("61616", AMQ_PORT, "org.apache.activemq.AMQ_PORT");
        DEFAULT_BROKER_HOST = host;
        DEFAULT_BROKER_PORT = Integer.parseInt(port);
        String url = DefaultConnectionProperties.getProperty("tcp://" + host + ":" + port, "org.apache.activemq.BROKER_BIND_URL", BROKER_BIND_URL);
        DEFAULT_USER = DefaultConnectionProperties.getProperty(null, AMQ_USER, "org.apache.activemq.AMQ_USER");
        DEFAULT_PASSWORD = DefaultConnectionProperties.getProperty(null, AMQ_PASSWORD, "org.apache.activemq.AMQ_PASSWORD");
        DEFAULT_PASSWORD_CODEC = DefaultConnectionProperties.getProperty(null, AMQ_PASSWORD_CODEC, "org.apache.activemq.AMQ_PASSWORD_CODEC");
        DEFAULT_BROKER_URL = DEFAULT_BROKER_BIND_URL = url;
    }

    static {
        DefaultConnectionProperties.initialize();
    }
}

