/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSContext;
import org.apache.activemq.artemis.jms.client.JmsExceptionUtils;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public final class ActiveMQJMSProducer
implements JMSProducer {
    private final ActiveMQJMSContext context;
    private final MessageProducer producer;
    private final TypedProperties properties = new TypedProperties();
    private final List<SimpleString> stringPropertyNames = new ArrayList<SimpleString>();
    private volatile CompletionListener completionListener;
    private Destination jmsHeaderReplyTo;
    private String jmsHeaderCorrelationID;
    private byte[] jmsHeaderCorrelationIDAsBytes;
    private String jmsHeaderType;

    ActiveMQJMSProducer(ActiveMQJMSContext context, MessageProducer producer) {
        this.context = context;
        this.producer = producer;
    }

    @Override
    public JMSProducer send(Destination destination, Message message) {
        if (message == null) {
            throw new MessageFormatRuntimeException("null message");
        }
        try {
            if (this.jmsHeaderCorrelationID != null) {
                message.setJMSCorrelationID(this.jmsHeaderCorrelationID);
            }
            if (this.jmsHeaderCorrelationIDAsBytes != null && this.jmsHeaderCorrelationIDAsBytes.length > 0) {
                message.setJMSCorrelationIDAsBytes(this.jmsHeaderCorrelationIDAsBytes);
            }
            if (this.jmsHeaderReplyTo != null) {
                message.setJMSReplyTo(this.jmsHeaderReplyTo);
            }
            if (this.jmsHeaderType != null) {
                message.setJMSType(this.jmsHeaderType);
            }
            this.setProperties(message);
            if (this.completionListener != null) {
                CompletionListenerWrapper wrapped = new CompletionListenerWrapper(this.completionListener);
                this.producer.send(destination, message, wrapped);
            } else {
                this.producer.send(destination, message);
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    private void setProperties(Message message) throws JMSException {
        this.properties.forEach((k, v) -> {
            try {
                message.setObjectProperty(k.toString(), v);
            }
            catch (JMSException e) {
                throw JmsExceptionUtils.convertToRuntimeException(e);
            }
        });
    }

    @Override
    public JMSProducer send(Destination destination, String body) {
        TextMessage message = this.context.createTextMessage(body);
        this.send(destination, message);
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage message = this.context.createMapMessage();
        if (body != null) {
            try {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String name = entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof String) {
                        String string = (String)v;
                        message.setString(name, string);
                        continue;
                    }
                    if (v instanceof Long) {
                        Long longValue = (Long)v;
                        message.setLong(name, longValue);
                        continue;
                    }
                    if (v instanceof Double) {
                        Double doubleValue = (Double)v;
                        message.setDouble(name, doubleValue);
                        continue;
                    }
                    if (v instanceof Integer) {
                        Integer integer = (Integer)v;
                        message.setInt(name, integer);
                        continue;
                    }
                    if (v instanceof Character) {
                        Character character = (Character)v;
                        message.setChar(name, character.charValue());
                        continue;
                    }
                    if (v instanceof Short) {
                        Short shortValue = (Short)v;
                        message.setShort(name, shortValue);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        Boolean booleanValue = (Boolean)v;
                        message.setBoolean(name, booleanValue);
                        continue;
                    }
                    if (v instanceof Float) {
                        Float floatValue = (Float)v;
                        message.setFloat(name, floatValue.floatValue());
                        continue;
                    }
                    if (v instanceof Byte) {
                        Byte byteValue = (Byte)v;
                        message.setByte(name, byteValue);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        byte[] bytes = (byte[])v;
                        message.setBytes(name, bytes, 0, bytes.length);
                        continue;
                    }
                    message.setObject(name, v);
                }
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException(e.getMessage());
            }
        }
        this.send(destination, message);
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, byte[] body) {
        BytesMessage message = this.context.createBytesMessage();
        if (body != null) {
            try {
                message.writeBytes(body);
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException(e.getMessage());
            }
        }
        this.send(destination, message);
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage message = this.context.createObjectMessage(body);
        this.send(destination, message);
        return this;
    }

    @Override
    public JMSProducer setDisableMessageID(boolean value) {
        try {
            this.producer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean getDisableMessageID() {
        try {
            return this.producer.getDisableMessageID();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setDisableMessageTimestamp(boolean value) {
        try {
            this.producer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        try {
            return this.producer.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSProducer setDeliveryMode(int deliveryMode) {
        try {
            this.producer.setDeliveryMode(deliveryMode);
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        return this;
    }

    @Override
    public int getDeliveryMode() {
        try {
            return this.producer.getDeliveryMode();
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public JMSProducer setPriority(int priority) {
        try {
            this.producer.setPriority(priority);
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        return this;
    }

    @Override
    public int getPriority() {
        try {
            return this.producer.getPriority();
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public JMSProducer setTimeToLive(long timeToLive) {
        try {
            this.producer.setTimeToLive(timeToLive);
            return this;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public long getTimeToLive() {
        long timeToLive = 0L;
        try {
            timeToLive = this.producer.getTimeToLive();
            return timeToLive;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        try {
            this.producer.setDeliveryDelay(deliveryDelay);
            return this;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public long getDeliveryDelay() {
        long deliveryDelay = 0L;
        try {
            deliveryDelay = this.producer.getDeliveryDelay();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deliveryDelay;
    }

    @Override
    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    @Override
    public CompletionListener getAsync() {
        return this.completionListener;
    }

    @Override
    public JMSProducer setProperty(String name, boolean value) {
        this.checkName(name);
        this.properties.putBooleanProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, byte value) {
        this.checkName(name);
        this.properties.putByteProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, short value) {
        this.checkName(name);
        this.properties.putShortProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, int value) {
        this.checkName(name);
        this.properties.putIntProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, long value) {
        this.checkName(name);
        this.properties.putLongProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, float value) {
        this.checkName(name);
        this.properties.putFloatProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, double value) {
        this.checkName(name);
        this.properties.putDoubleProperty(SimpleString.of(name), value);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, String value) {
        this.checkName(name);
        SimpleString key = SimpleString.of(name);
        this.properties.putSimpleStringProperty(key, SimpleString.of(value));
        this.stringPropertyNames.add(key);
        return this;
    }

    @Override
    public JMSProducer setProperty(String name, Object value) {
        this.checkName(name);
        try {
            TypedProperties.setObjectProperty(SimpleString.of(name), value, this.properties);
        }
        catch (ActiveMQPropertyConversionException amqe) {
            throw new MessageFormatRuntimeException(amqe.getMessage());
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        return this;
    }

    @Override
    public JMSProducer clearProperties() {
        try {
            this.stringPropertyNames.clear();
            this.properties.clear();
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        return this;
    }

    @Override
    public boolean propertyExists(String name) {
        return this.properties.containsProperty(SimpleString.of(name));
    }

    @Override
    public boolean getBooleanProperty(String name) {
        try {
            return this.properties.getBooleanProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    @Override
    public byte getByteProperty(String name) {
        try {
            return this.properties.getByteProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public short getShortProperty(String name) {
        try {
            return this.properties.getShortProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public int getIntProperty(String name) {
        try {
            return this.properties.getIntProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public long getLongProperty(String name) {
        try {
            return this.properties.getLongProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public float getFloatProperty(String name) {
        try {
            return this.properties.getFloatProperty(SimpleString.of(name)).floatValue();
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public double getDoubleProperty(String name) {
        try {
            return this.properties.getDoubleProperty(SimpleString.of(name));
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
    }

    @Override
    public String getStringProperty(String name) {
        try {
            SimpleString prop = this.properties.getSimpleStringProperty(SimpleString.of(name));
            if (prop == null) {
                return null;
            }
            return prop.toString();
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    @Override
    public Object getObjectProperty(String name) {
        try {
            SimpleString key = SimpleString.of(name);
            Object property = this.properties.getProperty(key);
            if (this.stringPropertyNames.contains(key)) {
                property = property.toString();
            }
            return property;
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        try {
            return this.properties.getMapNames();
        }
        catch (ActiveMQPropertyConversionException ce) {
            throw new MessageFormatRuntimeException(ce.getMessage());
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSRuntimeException("Please specify a non-zero length byte[]");
        }
        this.jmsHeaderCorrelationIDAsBytes = Arrays.copyOf(correlationID, correlationID.length);
        return this;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        return Arrays.copyOf(this.jmsHeaderCorrelationIDAsBytes, this.jmsHeaderCorrelationIDAsBytes.length);
    }

    @Override
    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.jmsHeaderCorrelationID = correlationID;
        return this;
    }

    @Override
    public String getJMSCorrelationID() {
        return this.jmsHeaderCorrelationID;
    }

    @Override
    public JMSProducer setJMSType(String type) {
        this.jmsHeaderType = type;
        return this;
    }

    @Override
    public String getJMSType() {
        return this.jmsHeaderType;
    }

    @Override
    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.jmsHeaderReplyTo = replyTo;
        return this;
    }

    @Override
    public Destination getJMSReplyTo() {
        return this.jmsHeaderReplyTo;
    }

    private void checkName(String name) {
        if (name == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nameCannotBeNull();
        }
        if (name.isEmpty()) {
            throw ActiveMQJMSClientBundle.BUNDLE.nameCannotBeEmpty();
        }
    }

    final class CompletionListenerWrapper
    implements CompletionListener {
        private final CompletionListener wrapped;

        CompletionListenerWrapper(CompletionListener wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void onCompletion(Message message) {
            ActiveMQJMSProducer.this.context.getThreadAwareContext().setCurrentThread(true);
            try {
                this.wrapped.onCompletion(message);
            }
            finally {
                ActiveMQJMSProducer.this.context.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        @Override
        public void onException(Message message, Exception exception) {
            ActiveMQJMSProducer.this.context.getThreadAwareContext().setCurrentThread(true);
            try {
                this.wrapped.onException(message, exception);
            }
            finally {
                ActiveMQJMSProducer.this.context.getThreadAwareContext().clearCurrentThread(true);
            }
        }
    }
}

