/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class SecurityFormatter {
    public static String toJSON(Set<Role> roles) {
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        JsonArrayBuilder sendRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder consumeRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder createDurableQueueRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder deleteDurableQueueRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder createNonDurableQueueRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder deleteNonDurableQueueRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder manageRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder browseRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder createAddressRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder deleteAddressRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder viewRoles = JsonLoader.createArrayBuilder();
        JsonArrayBuilder editRoles = JsonLoader.createArrayBuilder();
        for (Role role : roles) {
            if (role.isSend()) {
                sendRoles.add(role.getName());
            }
            if (role.isConsume()) {
                consumeRoles.add(role.getName());
            }
            if (role.isCreateDurableQueue()) {
                createDurableQueueRoles.add(role.getName());
            }
            if (role.isDeleteDurableQueue()) {
                deleteDurableQueueRoles.add(role.getName());
            }
            if (role.isCreateNonDurableQueue()) {
                createNonDurableQueueRoles.add(role.getName());
            }
            if (role.isDeleteNonDurableQueue()) {
                deleteNonDurableQueueRoles.add(role.getName());
            }
            if (role.isManage()) {
                manageRoles.add(role.getName());
            }
            if (role.isBrowse()) {
                browseRoles.add(role.getName());
            }
            if (role.isCreateAddress()) {
                createAddressRoles.add(role.getName());
            }
            if (role.isDeleteAddress()) {
                deleteAddressRoles.add(role.getName());
            }
            if (role.isView()) {
                viewRoles.add(role.getName());
            }
            if (!role.isEdit()) continue;
            editRoles.add(role.getName());
        }
        return builder.add("send", sendRoles).add("consume", consumeRoles).add("createDurableQueue", createDurableQueueRoles).add("deleteDurableQueue", deleteDurableQueueRoles).add("createNonDurableQueue", createNonDurableQueueRoles).add("deleteNonDurableQueue", deleteNonDurableQueueRoles).add("manage", manageRoles).add("browse", browseRoles).add("createAddress", createAddressRoles).add("deleteAddress", deleteAddressRoles).add("view", viewRoles).add("edit", editRoles).build().toString();
    }

    public static String toJSON(String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles, String viewRoles, String editRoles) {
        return JsonLoader.createObjectBuilder().add("send", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(sendRoles))).add("consume", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(consumeRoles))).add("createDurableQueue", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(createDurableQueueRoles))).add("deleteDurableQueue", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(deleteDurableQueueRoles))).add("createNonDurableQueue", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(createNonDurableQueueRoles))).add("deleteNonDurableQueue", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(deleteNonDurableQueueRoles))).add("manage", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(manageRoles))).add("browse", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(browseRoles))).add("createAddress", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(createAddressRoles))).add("deleteAddress", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(deleteAddressRoles))).add("view", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(viewRoles))).add("edit", JsonUtil.toJsonArray(SecurityFormatter.toListOfRoles(editRoles))).build().toString();
    }

    public static Set<Role> fromJSON(JsonObject json) {
        List<String> sendRoles = SecurityFormatter.getListOfRoles(json, "send");
        List<String> consumeRoles = SecurityFormatter.getListOfRoles(json, "consume");
        List<String> createDurableQueueRoles = SecurityFormatter.getListOfRoles(json, "createDurableQueue");
        List<String> deleteDurableQueueRoles = SecurityFormatter.getListOfRoles(json, "deleteDurableQueue");
        List<String> createNonDurableQueueRoles = SecurityFormatter.getListOfRoles(json, "createNonDurableQueue");
        List<String> deleteNonDurableQueueRoles = SecurityFormatter.getListOfRoles(json, "deleteNonDurableQueue");
        List<String> manageRoles = SecurityFormatter.getListOfRoles(json, "manage");
        List<String> browseRoles = SecurityFormatter.getListOfRoles(json, "browse");
        List<String> createAddressRoles = SecurityFormatter.getListOfRoles(json, "createAddress");
        List<String> deleteAddressRoles = SecurityFormatter.getListOfRoles(json, "deleteAddress");
        List<String> viewRoles = SecurityFormatter.getListOfRoles(json, "view");
        List<String> editRoles = SecurityFormatter.getListOfRoles(json, "edit");
        HashSet<String> allRoles = new HashSet<String>();
        allRoles.addAll(sendRoles);
        allRoles.addAll(consumeRoles);
        allRoles.addAll(createDurableQueueRoles);
        allRoles.addAll(deleteDurableQueueRoles);
        allRoles.addAll(createNonDurableQueueRoles);
        allRoles.addAll(deleteNonDurableQueueRoles);
        allRoles.addAll(manageRoles);
        allRoles.addAll(browseRoles);
        allRoles.addAll(createAddressRoles);
        allRoles.addAll(deleteAddressRoles);
        allRoles.addAll(viewRoles);
        allRoles.addAll(editRoles);
        HashSet<Role> roles = new HashSet<Role>(allRoles.size());
        for (String role : allRoles) {
            roles.add(new Role(role, sendRoles.contains(role), consumeRoles.contains(role), createDurableQueueRoles.contains(role), deleteDurableQueueRoles.contains(role), createNonDurableQueueRoles.contains(role), deleteNonDurableQueueRoles.contains(role), manageRoles.contains(role), browseRoles.contains(role), createAddressRoles.contains(role), deleteAddressRoles.contains(role), viewRoles.contains(role), editRoles.contains(role)));
        }
        return roles;
    }

    public static Set<Role> createSecurity(String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles) {
        List<String> createDurableQueue = SecurityFormatter.toListOfRoles(createDurableQueueRoles);
        List<String> deleteDurableQueue = SecurityFormatter.toListOfRoles(deleteDurableQueueRoles);
        List<String> createNonDurableQueue = SecurityFormatter.toListOfRoles(createNonDurableQueueRoles);
        List<String> deleteNonDurableQueue = SecurityFormatter.toListOfRoles(deleteNonDurableQueueRoles);
        List<String> send = SecurityFormatter.toListOfRoles(sendRoles);
        List<String> consume = SecurityFormatter.toListOfRoles(consumeRoles);
        List<String> manage = SecurityFormatter.toListOfRoles(manageRoles);
        List<String> browse = SecurityFormatter.toListOfRoles(browseRoles);
        List<String> createAddress = SecurityFormatter.toListOfRoles(createAddressRoles);
        List<String> deleteAddress = SecurityFormatter.toListOfRoles(deleteAddressRoles);
        HashSet<String> allRoles = new HashSet<String>();
        allRoles.addAll(createDurableQueue);
        allRoles.addAll(deleteDurableQueue);
        allRoles.addAll(createNonDurableQueue);
        allRoles.addAll(deleteNonDurableQueue);
        allRoles.addAll(send);
        allRoles.addAll(consume);
        allRoles.addAll(manage);
        allRoles.addAll(browse);
        allRoles.addAll(createAddress);
        allRoles.addAll(deleteAddress);
        HashSet<Role> roles = new HashSet<Role>(allRoles.size());
        for (String role : allRoles) {
            roles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role), browse.contains(role), createAddressRoles.contains(role), deleteAddressRoles.contains(role), false, false));
        }
        return roles;
    }

    public static List<String> getListOfRoles(JsonObject jsonObject, String permissionType) {
        return jsonObject.getJsonArray(permissionType) == null ? Collections.emptyList() : jsonObject.getJsonArray(permissionType).getValuesAs(v -> v.getString());
    }

    public static List<String> toListOfRoles(String commaSeparatedRoles) {
        if (commaSeparatedRoles == null || commaSeparatedRoles.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return (List)List.class.cast(Collections.list(new StringTokenizer(commaSeparatedRoles, ", ")));
    }
}

