/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Lifecycle;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DirectExecutor;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SuppressLog;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadCreator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ThreadPool
implements Lifecycle {
    protected Executor thread_pool;
    protected Log log;
    protected ThreadFactory thread_factory;
    protected Address address;
    protected SuppressLog<String> thread_pool_full_log;
    @Property(description="Whether or not the thread pool is enabled. If false, tasks will be run on the caller's thread")
    protected boolean enabled = true;
    @Property(description="If true, create virtual threads, otherwise create native threads")
    protected boolean use_virtual_threads;
    @Property(description="Minimum thread pool size for the thread pool")
    protected int min_threads;
    @Property(description="Maximum thread pool size for the thread pool")
    protected int max_threads = 200;
    @Property(description="Timeout (ms) to remove idle threads from the pool", type=AttributeType.TIME)
    protected long keep_alive_time = 30000L;
    @Property(description="The rejection policy to be used in the thread pool (abort, discard, run, custom etc. See Util.parseRejectionPolicy() for details")
    protected String rejection_policy = "abort";
    @Property(description="Time (in milliseconds) during which thread-pool full messages are suppressed", type=AttributeType.TIME)
    protected long thread_pool_full_suppress_time = 60000L;
    @Property(description="The number of times a thread pool needs to be full before a thread dump is logged", deprecatedMessage="ignored")
    @Deprecated(since="5.4")
    protected int thread_dumps_threshold = 1;
    @Property(description="Path to which the thread dump will be written. Ignored if null", systemProperty={"jgroups.threaddump.path"}, deprecatedMessage="ignored")
    @Deprecated(since="5.4")
    protected String thread_dump_path;
    @Property(description="Dump threads when the thread pool is full")
    protected boolean thread_dumps_enabled;
    @Property(description="Increases max_threads by the view size + delta if enabled (https://issues.redhat.com/browse/JGRP-2655)")
    protected boolean increase_max_size_dynamically = true;
    @Property(description="If the view is greater than the max thread pool size, the latter is set to view size + delta. Only enabled if increase_max_size_dynamically is true")
    protected int delta = 10;
    @ManagedAttribute(description="The number of messages dropped because the thread pool was full", type=AttributeType.SCALAR)
    protected final LongAdder num_rejected_msgs = new LongAdder();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Executor getThreadPool() {
        return this.thread_pool;
    }

    public ThreadPool setThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            this.destroy();
        }
        this.thread_pool = thread_pool;
        return this;
    }

    public ThreadPool setThreadFactory(ThreadFactory factory) {
        this.thread_factory = factory;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.thread_factory;
    }

    public boolean isShutdown() {
        return this.thread_pool instanceof ExecutorService && ((ExecutorService)this.thread_pool).isShutdown();
    }

    public int getMinThreads() {
        return this.min_threads;
    }

    public ThreadPool setMinThreads(int size) {
        this.min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
        return this;
    }

    public int getMaxThreads() {
        return this.max_threads;
    }

    public ThreadPool setMaxThreads(int size) {
        this.max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
        return this;
    }

    public long getKeepAliveTime() {
        return this.keep_alive_time;
    }

    public ThreadPool setKeepAliveTime(long time) {
        this.keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public ThreadPool setRejectionPolicy(String policy) {
        RejectedExecutionHandler p = Util.parseRejectionPolicy(policy);
        this.rejection_policy = policy;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setRejectedExecutionHandler(p);
        }
        return this;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        Executor t = this.thread_pool;
        return t instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)t).getRejectedExecutionHandler() : null;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setRejectedExecutionHandler(handler);
        }
    }

    public long getThreadPoolFullSuppressTime() {
        return this.thread_pool_full_suppress_time;
    }

    public ThreadPool setThreadPoolFullSuppressTime(long t) {
        this.thread_pool_full_suppress_time = t;
        return this;
    }

    public boolean getThreadDumpsEnabled() {
        return this.thread_dumps_enabled;
    }

    public ThreadPool setThreadDumpsEnabled(boolean b) {
        this.thread_dumps_enabled = b;
        return this;
    }

    @Deprecated
    public int getThreadDumpsThreshold() {
        return 0;
    }

    @Deprecated
    public ThreadPool setThreadDumpsThreshold(int t) {
        return this;
    }

    public Address getAddress() {
        return this.address;
    }

    public ThreadPool setAddress(Address a) {
        this.address = a;
        return this;
    }

    public boolean getIncreaseMaxSizeDynamically() {
        return this.increase_max_size_dynamically;
    }

    public ThreadPool setIncreaseMaxSizeDynamically(boolean b) {
        this.increase_max_size_dynamically = b;
        return this;
    }

    public int getDelta() {
        return this.delta;
    }

    public ThreadPool setDelta(int d) {
        this.delta = d;
        return this;
    }

    public long numberOfRejectedMessages() {
        return this.num_rejected_msgs.sum();
    }

    public ThreadPool log(Log l) {
        this.log = l;
        return this;
    }

    public boolean useVirtualThreads() {
        return this.use_virtual_threads;
    }

    public ThreadPool useVirtualThreads(boolean b) {
        this.use_virtual_threads = b;
        return this;
    }

    @Deprecated
    public int getNumberOfThreadDumps() {
        return -1;
    }

    @Deprecated
    public void resetThreadDumps() {
    }

    @ManagedAttribute(description="Current number of threads in the thread pool", type=AttributeType.SCALAR)
    public int getThreadPoolSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Current number of active threads in the thread pool", type=AttributeType.SCALAR)
    public int getThreadPoolSizeActive() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getActiveCount();
        }
        return 0;
    }

    @ManagedAttribute(description="Largest number of threads in the thread pool", type=AttributeType.SCALAR)
    public int getLargestSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getLargestPoolSize();
        }
        return 0;
    }

    public void resetStats() {
        this.num_rejected_msgs.reset();
    }

    @Override
    public void init() throws Exception {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        this.thread_pool_full_log = new SuppressLog(this.log, "ThreadPoolFull");
        if (this.enabled) {
            if (this.thread_factory == null) {
                this.thread_factory = new DefaultThreadFactory("thread-pool", true, true);
            }
            this.thread_pool = ThreadCreator.createThreadPool(this.min_threads, this.max_threads, this.keep_alive_time, this.rejection_policy, new SynchronousQueue<Runnable>(), this.thread_factory, this.use_virtual_threads, this.log);
        } else {
            this.thread_pool = new DirectExecutor();
        }
    }

    @Override
    public void destroy() {
        if (this.thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ThreadPool removeExpired() {
        this.thread_pool_full_log.removeExpired(this.thread_pool_full_suppress_time);
        return this;
    }

    public void doExecute(Runnable task) {
        this.thread_pool.execute(task);
    }

    public Executor pool() {
        return this.thread_pool;
    }

    public boolean execute(Runnable task) {
        try {
            this.thread_pool.execute(task);
            return true;
        }
        catch (RejectedExecutionException ex) {
            this.num_rejected_msgs.increment();
            String thread_dump = this.thread_dumps_enabled ? String.format(". Threads:\n%s", Util.dumpThreads()) : "";
            this.thread_pool_full_log.log(SuppressLog.Level.warn, "thread-pool-full", this.thread_pool_full_suppress_time, this.address, this.max_threads, this.getThreadPoolSize(), thread_dump);
            return false;
        }
        catch (Throwable t) {
            this.log.error("failure submitting task to thread pool", t);
            this.num_rejected_msgs.increment();
            return false;
        }
    }

    public String toString() {
        return this.thread_pool != null ? this.thread_pool.toString() : "n/a";
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }
}

