/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Global;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.RTTHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AverageMinMax;

public class RpcStats {
    protected final AtomicInteger sync_unicasts = new AtomicInteger(0);
    protected final AtomicInteger async_unicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_multicasts = new AtomicInteger(0);
    protected final AtomicInteger async_multicasts = new AtomicInteger(0);
    protected final AtomicInteger sync_anycasts = new AtomicInteger(0);
    protected final AtomicInteger async_anycasts = new AtomicInteger(0);
    protected volatile Map<Address, Result> stats;
    protected volatile Map<Address, RTTStat> rtt_stats;

    public RpcStats(boolean extended_stats) {
        this.extendedStats(extended_stats);
    }

    public int unicasts(boolean sync) {
        return sync ? this.sync_unicasts.get() : this.async_unicasts.get();
    }

    public int multicasts(boolean sync) {
        return sync ? this.sync_multicasts.get() : this.async_multicasts.get();
    }

    public int anycasts(boolean sync) {
        return sync ? this.sync_anycasts.get() : this.async_anycasts.get();
    }

    public boolean extendedStats() {
        return this.stats != null;
    }

    public RpcStats extendedStats(boolean f) {
        if (f) {
            if (this.stats == null) {
                this.stats = new ConcurrentHashMap<Address, Result>();
            }
        } else {
            this.stats = null;
        }
        return this;
    }

    public void reset() {
        if (this.stats != null) {
            this.stats.clear();
        }
        if (this.rtt_stats != null) {
            this.rtt_stats.clear();
        }
        for (AtomicInteger ai : Arrays.asList(this.sync_unicasts, this.async_unicasts, this.sync_multicasts, this.async_multicasts, this.sync_anycasts, this.async_anycasts)) {
            ai.set(0);
        }
    }

    public void add(Type type, Address dest, boolean sync, long time) {
        this.update(type, sync);
        this.addToResults(dest, sync, time);
    }

    public void addAnycast(boolean sync, long time, Collection<Address> dests) {
        this.update(Type.ANYCAST, sync);
        if (dests != null) {
            for (Address dest : dests) {
                this.addToResults(dest, sync, time);
            }
        }
    }

    public void addRTTStats(Address sender, RTTHeader hdr) {
        if (hdr == null) {
            return;
        }
        if (this.rtt_stats == null) {
            this.rtt_stats = new ConcurrentHashMap<Address, RTTStat>();
        }
        Address key = sender == null ? Global.NULL_ADDRESS : sender;
        RTTStat rtt_stat = this.rtt_stats.computeIfAbsent(key, k -> new RTTStat());
        rtt_stat.add(hdr);
    }

    public void retainAll(Collection<Address> members) {
        Map<Address, Result> map;
        if (members == null || (map = this.stats) == null) {
            return;
        }
        map.keySet().retainAll(members);
        if (this.rtt_stats != null) {
            this.rtt_stats.keySet().retainAll(members);
        }
    }

    public String printStatsByDest() {
        if (this.stats == null) {
            return "(no stats)";
        }
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry<Address, Result> entry : this.stats.entrySet()) {
            Address dst = entry.getKey();
            sb.append(String.format("%s: %s\n", dst == Global.NULL_ADDRESS ? "<all>" : dst, entry.getValue()));
        }
        return sb.toString();
    }

    public String printRTTStatsByDest() {
        if (this.rtt_stats == null) {
            return "(no RTT stats)";
        }
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry<Address, RTTStat> entry : this.rtt_stats.entrySet()) {
            Address dst = entry.getKey();
            sb.append(String.format("%s:\n%s\n", dst == Global.NULL_ADDRESS ? "<all>" : dst, entry.getValue()));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("sync mcasts: %d, async mcasts: %d, sync ucasts: %d, async ucasts: %d, sync acasts: %d, async acasts: %d", this.sync_multicasts.get(), this.async_multicasts.get(), this.sync_unicasts.get(), this.async_unicasts.get(), this.sync_anycasts.get(), this.async_anycasts.get());
    }

    protected void update(Type type, boolean sync) {
        switch (type) {
            case MULTICAST: {
                if (sync) {
                    this.sync_multicasts.incrementAndGet();
                    break;
                }
                this.async_multicasts.incrementAndGet();
                break;
            }
            case UNICAST: {
                if (sync) {
                    this.sync_unicasts.incrementAndGet();
                    break;
                }
                this.async_unicasts.incrementAndGet();
                break;
            }
            case ANYCAST: {
                if (sync) {
                    this.sync_anycasts.incrementAndGet();
                    break;
                }
                this.async_anycasts.incrementAndGet();
            }
        }
    }

    protected void addToResults(Address dest, boolean sync, long time) {
        Map<Address, Result> map = this.stats;
        if (map == null) {
            return;
        }
        if (dest == null) {
            dest = Global.NULL_ADDRESS;
        }
        Result res = map.computeIfAbsent(dest, k -> new Result());
        res.add(sync, time);
    }

    protected static class RTTStat {
        protected final AverageMinMax total_time = new AverageMinMax();
        protected final AverageMinMax down_req_time = new AverageMinMax();
        protected final AverageMinMax network_req_time = new AverageMinMax();
        protected final AverageMinMax network_rsp_time = new AverageMinMax();
        protected final AverageMinMax req_up_time = new AverageMinMax();
        protected final AverageMinMax rsp_up_time = new AverageMinMax();
        protected final AverageMinMax processing_time = new AverageMinMax();

        protected RTTStat() {
        }

        protected void add(RTTHeader hdr) {
            if (hdr == null) {
                return;
            }
            long tmp = hdr.totalTime();
            if (tmp > 0L) {
                this.total_time.add(tmp);
            }
            if ((tmp = hdr.downRequest()) > 0L) {
                this.down_req_time.add(tmp);
            }
            if ((tmp = hdr.networkRequest()) > 0L) {
                this.network_req_time.add(tmp);
            }
            if ((tmp = hdr.networkResponse()) > 0L) {
                this.network_rsp_time.add(tmp);
            }
            if ((tmp = hdr.upReq()) > 0L) {
                this.req_up_time.add(tmp);
            }
            if ((tmp = hdr.processingTime()) > 0L) {
                this.processing_time.add(tmp);
            }
            if ((tmp = hdr.upRsp()) > 0L) {
                this.rsp_up_time.add(tmp);
            }
        }

        public String toString() {
            return String.format("  total: %s\n  down-req: %s\n  network req: %s\n  network rsp: %s\n  up-req: %s\n  up-rsp: %s\n  processing time: %s\n", this.total_time.toString(TimeUnit.NANOSECONDS), this.down_req_time.toString(TimeUnit.NANOSECONDS), this.network_req_time.toString(TimeUnit.NANOSECONDS), this.network_rsp_time.toString(TimeUnit.NANOSECONDS), this.req_up_time.toString(TimeUnit.NANOSECONDS), this.rsp_up_time.toString(TimeUnit.NANOSECONDS), this.processing_time.toString(TimeUnit.NANOSECONDS));
        }
    }

    protected static class Result {
        protected long sync;
        protected long async;
        protected final AverageMinMax avg = new AverageMinMax();

        protected Result() {
        }

        protected long sync() {
            return this.sync;
        }

        protected long async() {
            return this.async;
        }

        protected long min() {
            return this.avg.min();
        }

        protected long max() {
            return this.avg.max();
        }

        protected synchronized double avg() {
            return this.avg.average();
        }

        protected synchronized void add(boolean sync, long time) {
            if (sync) {
                ++this.sync;
            } else {
                ++this.async;
            }
            if (time > 0L) {
                this.avg.add(time);
            }
        }

        public String toString() {
            double avg_us = this.avg() / 1000.0;
            double min_us = (double)this.avg.min() / 1000.0;
            double max_us = (double)this.avg.max() / 1000.0;
            return String.format("async: %d, sync: %d, round-trip min/avg/max (us): %.2f / %.2f / %.2f", this.async, this.sync, min_us, avg_us, max_us);
        }
    }

    public static enum Type {
        MULTICAST,
        UNICAST,
        ANYCAST;

    }
}

