/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSSecurityException;
import java.io.DataInput;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.AutoCreateResult;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQCompositeConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSingleConsumerBrokerExchange;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.server.TempResourceObserver;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.AbstractRemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.actors.ThresholdActor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.BrokerSubscriptionInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.transport.TransmitCallback;
import org.apache.activemq.util.ByteSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWireConnection
extends AbstractRemotingConnection
implements SecurityAuth,
TempResourceObserver {
    private final Object lockSend = new Object();
    private static final int MINIMAL_SIZE_ESTIAMTE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final KeepAliveInfo PING = new KeepAliveInfo();
    private final OpenWireProtocolManager protocolManager;
    private volatile ScheduledFuture ttlCheck;
    private final OpenWireFormat inWireFormat;
    private final OpenWireFormat outWireFormat;
    private AMQConnectionContext context;
    private final int actorThresholdBytes;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final Map<String, SessionId> sessionIdMap = new ConcurrentHashMap<String, SessionId>();
    private final Map<ConsumerId, AMQConsumerBrokerExchange> consumerExchanges = new ConcurrentHashMap<ConsumerId, AMQConsumerBrokerExchange>();
    private final Map<ProducerId, AMQProducerBrokerExchange> producerExchanges = new ConcurrentHashMap<ProducerId, AMQProducerBrokerExchange>();
    private final Map<SessionId, AMQSession> sessions = new ConcurrentHashMap<SessionId, AMQSession>();
    private final CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();
    private volatile ConnectionState state;
    private volatile boolean noLocal;
    private final Map<TransactionId, Transaction> txMap = new ConcurrentHashMap<TransactionId, Transaction>();
    private final ActiveMQServer server;
    private ServerSession internalSession;
    private final OperationContext operationContext;
    private static final AtomicLongFieldUpdater<OpenWireConnection> LAST_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(OpenWireConnection.class, "lastSent");
    private volatile long lastSent = -1L;
    private volatile boolean autoRead = true;
    private ConnectionEntry connectionEntry;
    private boolean useKeepAlive;
    private long maxInactivityDuration;
    private volatile ThresholdActor<Command> openWireActor;
    private final Set<SimpleString> knownDestinations = new ConcurrentHashSet();
    private final AtomicBoolean disableTtl = new AtomicBoolean(false);
    private String validatedUser = null;
    CommandProcessor commandProcessorInstance = new CommandProcessor();

    public void block() {
        this.openWireActor.pauseProcessing();
    }

    public void unblock() {
        this.openWireActor.resumeProcessing();
    }

    public OpenWireConnection(Connection connection, ActiveMQServer server, OpenWireProtocolManager openWireProtocolManager, OpenWireFormat wf, Executor executor) {
        this(connection, server, openWireProtocolManager, wf, executor, 0x100000);
    }

    public OpenWireConnection(Connection connection, ActiveMQServer server, OpenWireProtocolManager openWireProtocolManager, OpenWireFormat wf, Executor executor, int actorThresholdBytes) {
        super(connection, executor);
        this.server = server;
        this.operationContext = server.newOperationContext();
        this.protocolManager = openWireProtocolManager;
        this.inWireFormat = wf;
        this.outWireFormat = wf.copy();
        this.useKeepAlive = openWireProtocolManager.isUseKeepAlive();
        this.maxInactivityDuration = openWireProtocolManager.getMaxInactivityDuration();
        this.actorThresholdBytes = actorThresholdBytes;
    }

    public String getUsername() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getUserName();
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public OpenWireConnection getRemotingConnection() {
        return this;
    }

    public String getSecurityDomain() {
        return this.protocolManager.getSecurityDomain();
    }

    public String getPassword() {
        ConnectionInfo info = this.getConnectionInfo();
        if (info == null) {
            return null;
        }
        return info.getPassword();
    }

    private ConnectionInfo getConnectionInfo() {
        if (this.state == null) {
            return null;
        }
        return this.state.getInfo();
    }

    private void bufferSent() {
        LAST_SENT_UPDATER.lazySet(this, System.currentTimeMillis());
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        super.bufferReceived(connectionID, buffer);
        try {
            Command command = (Command)this.inWireFormat.unmarshal((DataInput)buffer);
            this.logCommand(command, true);
            ThresholdActor<Command> localVisibleActor = this.openWireActor;
            if (localVisibleActor != null) {
                localVisibleActor.act((Object)command);
            } else {
                this.act(command);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            this.sendException(e);
        }
    }

    public void restoreAutoRead() {
        if (!this.autoRead) {
            this.autoRead = true;
            this.openWireActor.flush();
        }
    }

    public void blockConnection() {
        this.autoRead = false;
        this.disableAutoRead();
    }

    private void disableAutoRead() {
        this.getTransportConnection().setAutoRead(false);
        this.disableTtl();
    }

    protected void flushedActor() {
        this.getTransportConnection().setAutoRead(this.autoRead);
        if (this.autoRead) {
            this.enableTtl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void act(Command command) {
        block19: {
            try {
                this.recoverOperationContext();
                if (AuditLogger.isAnyLoggingEnabled()) {
                    AuditLogger.setRemoteAddress((String)this.getRemoteAddress());
                }
                if (this.protocolManager.invokeIncoming(command, this) != null) {
                    logger.debug("Interceptor rejected OpenWire command: {}", (Object)command);
                    this.disconnect(true);
                    return;
                }
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (command.getClass() == KeepAliveInfo.class) break block19;
                Response response = null;
                try {
                    this.setLastCommand(command);
                    response = command.visit((CommandVisitor)this.commandProcessorInstance);
                }
                catch (Exception e) {
                    logger.warn("Errors occurred during the buffering operation ", (Throwable)e);
                    if (responseRequired) {
                        response = this.convertException(e);
                    }
                }
                finally {
                    this.setLastCommand(null);
                }
                if (response instanceof ExceptionResponse) {
                    ExceptionResponse exceptionResponse = (ExceptionResponse)response;
                    Throwable cause = exceptionResponse.getException();
                    if (!responseRequired) {
                        this.serviceException(cause);
                        response = null;
                    }
                    if (command instanceof ConnectionInfo) {
                        this.delayedStop(2000, cause.getMessage(), cause);
                    }
                }
                if (responseRequired && response == null) {
                    response = new Response();
                    response.setCorrelationId(commandId);
                }
                if (this.context != null && this.context.isDontSendReponse()) {
                    this.context.setDontSendReponse(false);
                    response = null;
                }
                this.sendAsyncResponse(commandId, response);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                this.sendException(e);
            }
            finally {
                this.clearupOperationContext();
            }
        }
    }

    private void sendAsyncResponse(final int commandId, final Response response) throws Exception {
        if (response != null) {
            this.operationContext.executeOnCompletion(new IOCallback(){
                final /* synthetic */ OpenWireConnection this$0;
                {
                    this.this$0 = this$0;
                }

                public void done() {
                    if (!this.this$0.protocolManager.isStopping()) {
                        try {
                            response.setCorrelationId(commandId);
                            this.this$0.dispatchSync((Command)response);
                        }
                        catch (Exception e) {
                            this.this$0.sendException(e);
                        }
                    }
                }

                public void onError(int errorCode, String errorMessage) {
                    this.this$0.sendException(new IOException(errorCode + "-" + errorMessage));
                }
            });
        }
    }

    public void sendException(Exception e) {
        Command command;
        Response resp = this.convertException(e);
        if (this.context != null && (command = this.context.getLastCommand()) != null) {
            resp.setCorrelationId(command.getCommandId());
        }
        try {
            this.dispatch((Command)resp);
        }
        catch (IOException e2) {
            logger.warn(e.getMessage(), (Throwable)e2);
        }
    }

    private Response convertException(Exception e) {
        ExceptionResponse resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : (e instanceof ActiveMQNonExistentQueueException ? new ExceptionResponse((Throwable)new InvalidDestinationException(e.getMessage())) : new ExceptionResponse((Throwable)e));
        return resp;
    }

    private void setLastCommand(Command command) {
        if (this.context != null) {
            this.context.setLastCommand(command);
        }
    }

    public void destroy() {
        this.fail(null, null);
    }

    public void disconnect(boolean criticalError) {
        this.disconnect(null, null, criticalError);
    }

    public void flush() {
        this.checkInactivity();
    }

    public void close() {
        this.destroy();
    }

    private void checkInactivity() {
        if (!this.useKeepAlive) {
            return;
        }
        long dur = System.currentTimeMillis() - this.lastSent;
        if (dur >= this.maxInactivityDuration / 2L) {
            this.sendCommand((Command)PING);
        }
    }

    private void callFailureListeners(ActiveMQException me) {
        ArrayList listenersClone = new ArrayList(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void sendHandshake() {
        WireFormatInfo info = this.inWireFormat.getPreferedWireFormatInfo();
        this.sendCommand((Command)info);
    }

    public ConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(Command command) throws IOException {
        if (this.protocolManager.invokeOutgoing(command, this) != null) {
            return;
        }
        this.logCommand(command, false);
        try {
            ByteSequence bytes = this.outWireFormat.marshal((Object)command);
            int bufferSize = bytes.length;
            int maxChunkSize = this.protocolManager.getOpenwireMaxPacketChunkSize();
            Object object = this.lockSend;
            synchronized (object) {
                if (maxChunkSize > 0 && bufferSize > maxChunkSize) {
                    this.chunkSend(bytes, bufferSize, maxChunkSize);
                } else {
                    ActiveMQBuffer buffer = this.transportConnection.createTransportBuffer(bufferSize);
                    buffer.writeBytes(bytes.data, bytes.offset, bufferSize);
                    this.transportConnection.write(buffer, false, false);
                }
            }
            this.bufferSent();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("error sending", t);
        }
    }

    private void chunkSend(ByteSequence bytes, int bufferSize, int maxChunkSize) {
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a big packet sized as {} with smaller packets of {}", (Object)bufferSize, (Object)maxChunkSize);
        }
        while (bytes.remaining() > 0) {
            int chunkSize = Math.min(bytes.remaining(), maxChunkSize);
            if (logger.isTraceEnabled()) {
                logger.trace("Sending a partial packet of {} bytes, starting at {}", (Object)chunkSize, (Object)bytes.remaining());
            }
            ActiveMQBuffer chunk = this.transportConnection.createTransportBuffer(chunkSize);
            chunk.writeBytes(bytes.data, bytes.offset, chunkSize);
            this.transportConnection.write(chunk, false, false);
            bytes.setOffset(bytes.getOffset() + chunkSize);
        }
    }

    public void dispatchAsync(Command message) throws Exception {
        this.dispatchSync(message);
    }

    public void dispatchSync(Command message) throws Exception {
        this.processDispatch(message);
    }

    public void serviceException(Throwable e) throws Exception {
        ConnectionError ce = new ConnectionError();
        ce.setException(e);
        this.dispatchAsync((Command)ce);
    }

    public void dispatch(Command command) throws IOException {
        this.physicalSend(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) throws IOException {
        MessageDispatch messageDispatch = (MessageDispatch)(command.isMessageDispatch() ? command : null);
        try {
            if (!this.stopping.get()) {
                if (messageDispatch != null) {
                    this.protocolManager.preProcessDispatch(messageDispatch);
                }
                this.dispatch(command);
            }
        }
        catch (IOException e) {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onFailure();
                }
                messageDispatch = null;
                throw e;
            }
        }
        finally {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onSuccess();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsumerBrokerExchange(ConsumerId id, AMQSession amqSession, List<AMQConsumer> consumerList) {
        AMQConsumerBrokerExchange result = this.consumerExchanges.get(id);
        if (result == null) {
            result = consumerList.size() == 1 ? new AMQSingleConsumerBrokerExchange(amqSession, consumerList.get(0)) : new AMQCompositeConsumerBrokerExchange(amqSession, consumerList);
            Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
            synchronized (map) {
                this.consumerExchanges.put(id, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AMQProducerBrokerExchange getProducerBrokerExchange(ProducerId id) throws IOException {
        AMQProducerBrokerExchange result = this.producerExchanges.get(id);
        if (result == null) {
            Map<ProducerId, AMQProducerBrokerExchange> map = this.producerExchanges;
            synchronized (map) {
                SessionState ss;
                result = new AMQProducerBrokerExchange();
                result.setConnectionContext(this.context);
                if (this.context.isReconnect() || this.context.isNetworkConnection()) {
                    result.setLastStoredSequenceId(0L);
                }
                if ((ss = this.state.getSessionState(id.getParentId())) != null) {
                    result.setProducerState(ss.getProducerState(id));
                }
                this.producerExchanges.put(id, result);
            }
        }
        return result;
    }

    public void deliverMessage(MessageDispatch dispatch) {
        Message m = dispatch.getMessage();
        if (m != null) {
            long endTime = System.currentTimeMillis();
            m.setBrokerOutTime(endTime);
        }
        this.sendCommand((Command)dispatch);
    }

    public OpenWireFormat wireFormat() {
        return this.inWireFormat;
    }

    private void rollbackInProgressLocalTransactions() {
        for (Transaction tx : this.txMap.values()) {
            tx.tryRollback();
        }
    }

    private void shutdown(boolean fail) {
        try {
            if (fail) {
                this.transportConnection.forceClose();
            } else {
                this.transportConnection.close();
            }
        }
        finally {
            ScheduledFuture ttlCheckToCancel = this.ttlCheck;
            this.ttlCheck = null;
            if (ttlCheckToCancel != null) {
                ttlCheckToCancel.cancel(true);
            }
        }
    }

    private void disconnect(ActiveMQException me, String reason, boolean fail) {
        ThresholdActor<Command> localActor = this.openWireActor;
        if (localActor != null) {
            localActor.flush();
        }
        if (this.context == null || this.destroyed) {
            return;
        }
        this.state.shutdown();
        try {
            for (SessionId sessionId : this.sessionIdMap.values()) {
                AMQSession session = this.sessions.get(sessionId);
                if (session == null) continue;
                session.close(fail);
            }
            this.internalSession.close(false);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.destroyed = true;
        Command command = this.context.getLastCommand();
        if (command != null && command.isResponseRequired()) {
            Response lastResponse = new Response();
            lastResponse.setCorrelationId(command.getCommandId());
            try {
                this.dispatchSync((Command)lastResponse);
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (fail) {
            this.shutdown(fail);
        }
    }

    public void disconnect(String reason, boolean fail) {
        this.disconnect(null, reason, fail);
    }

    public void fail(ActiveMQException me, String message) {
        ThresholdActor<Command> localVisibleActor = this.openWireActor;
        if (localVisibleActor != null) {
            localVisibleActor.requestShutdown();
        }
        if (this.executor != null) {
            this.executor.execute(() -> this.doFail(me, message));
        } else {
            this.doFail(me, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFail(ActiveMQException me, String message) {
        this.recoverOperationContext();
        try {
            block14: {
                if (me != null && !(me instanceof ActiveMQRemoteDisconnectException)) {
                    ActiveMQClientLogger.LOGGER.connectionFailureDetected(this.transportConnection.getProtocolConnection().getProtocolName(), this.transportConnection.getRemoteAddress(), me.getMessage(), me.getType());
                }
                try {
                    if (this.getConnectionInfo() == null) break block14;
                    this.protocolManager.removeConnection(this.getClientID(), this);
                }
                catch (Throwable throwable) {
                    try {
                        this.disconnect(false);
                    }
                    catch (Throwable e) {
                        logger.debug("OpenWireConnection::disconnect failure", e);
                    }
                    this.operationContext.executeOnCompletion(new IOCallback(){

                        public void done() {
                            OpenWireConnection.this.rollbackInProgressLocalTransactions();
                        }

                        public void onError(int errorCode, String errorMessage) {
                            OpenWireConnection.this.rollbackInProgressLocalTransactions();
                        }
                    });
                    throw throwable;
                }
            }
            try {
                this.disconnect(false);
            }
            catch (Throwable e) {
                logger.debug("OpenWireConnection::disconnect failure", e);
            }
            this.operationContext.executeOnCompletion(new /* invalid duplicate definition of identical inner class */);
            this.shutdown(true);
        }
        finally {
            try {
                this.transportConnection.close();
            }
            catch (Throwable e2) {
                logger.warn(e2.getMessage(), e2);
            }
        }
    }

    private void delayedStop(int waitTimeMillis, String reason, Throwable cause) {
        if (waitTimeMillis > 0) {
            try {
                this.protocolManager.getScheduledPool().schedule(() -> {
                    this.fail(new ActiveMQException(reason, cause, ActiveMQExceptionType.GENERIC_EXCEPTION), reason);
                    logger.warn("Stopping {} because {}", (Object)this.transportConnection.getRemoteAddress(), (Object)reason);
                }, (long)waitTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                logger.warn("Cannot stop connection. This exception will be ignored.", t);
            }
        }
    }

    public AMQConnectionContext getContext() {
        return this.context;
    }

    public void updateClient(ConnectionControl control) throws Exception {
        if (this.protocolManager.isUpdateClusterClients()) {
            this.dispatchAsync((Command)control);
        }
    }

    public AMQConnectionContext initContext(ConnectionInfo info) throws Exception {
        WireFormatInfo wireFormatInfo = this.inWireFormat.getPreferedWireFormatInfo();
        if (wireFormatInfo != null && wireFormatInfo.getVersion() <= 2) {
            info.setClientMaster(true);
        }
        this.state = new ConnectionState(info);
        this.context = new AMQConnectionContext();
        this.state.reset(info);
        String clientId = info.getClientId();
        this.context.setBroker(this.protocolManager);
        this.context.setClientId(clientId);
        this.context.setClientMaster(info.isClientMaster());
        this.context.setConnection(this);
        this.context.setConnectionId(info.getConnectionId());
        this.context.setFaultTolerant(info.isFaultTolerant());
        this.context.setUserName(info.getUserName());
        this.context.setWireFormatInfo(wireFormatInfo);
        this.context.setReconnect(info.isFailoverReconnect());
        this.context.setConnectionState(this.state);
        if (info.getClientIp() == null) {
            info.setClientIp(this.getRemoteAddress());
        }
        this.createInternalSession(info);
        this.openWireActor = new ThresholdActor(this.executor, this::act, this.actorThresholdBytes, OpenWireConnection::getSize, this::disableAutoRead, this::flushedActor);
        return this.context;
    }

    private static int getSize(Command command) {
        if (command instanceof ActiveMQMessage) {
            ActiveMQMessage activeMQMessage = (ActiveMQMessage)command;
            return activeMQMessage.getSize();
        }
        return 1024;
    }

    private void createInternalSession(ConnectionInfo info) throws Exception {
        this.internalSession = this.server.createSession(UUIDGenerator.getInstance().generateStringUUID(), this.context.getUserName(), info.getPassword(), -1, (RemotingConnection)this, true, false, false, false, null, null, true, this.operationContext, this.protocolManager.getPrefixes(), this.protocolManager.getSecurityDomain(), this.validatedUser, false);
    }

    public boolean sendCommand(Command command) {
        logger.trace("sending {}", (Object)command);
        if (this.isDestroyed()) {
            return false;
        }
        try {
            this.physicalSend(command);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public void addDestination(DestinationInfo info) throws Exception {
        boolean created = false;
        org.apache.activemq.command.ActiveMQDestination dest = info.getDestination();
        if (!this.protocolManager.isSupportAdvisory() && AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            return;
        }
        SimpleString qName = SimpleString.of((String)dest.getPhysicalName());
        AutoCreateResult autoCreateResult = this.internalSession.checkAutoCreate(QueueConfiguration.of((SimpleString)qName).setRoutingType(dest.isQueue() ? RoutingType.ANYCAST : RoutingType.MULTICAST).setDurable(Boolean.valueOf(!dest.isTemporary())).setTemporary(Boolean.valueOf(dest.isTemporary())));
        if (autoCreateResult == AutoCreateResult.CREATED) {
            created = true;
            if (AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest) && this.protocolManager.isSuppressInternalManagementObjects()) {
                this.internalSession.getAddress(qName).setInternal(true);
            }
        } else if (autoCreateResult == AutoCreateResult.NOT_FOUND) {
            throw new InvalidDestinationException(dest.getDestinationTypeAsString() + " " + dest.getPhysicalName() + " does not exist.");
        }
        if (dest.isTemporary() && !this.tempDestinationExists(info.getDestination().getPhysicalName())) {
            this.state.addTempDestination(info);
            if (logger.isDebugEnabled()) {
                logger.debug("{} added temp destination to state: {} ; {}", new Object[]{this, info.getDestination().getPhysicalName(), this.state.getTempDestinations().size()});
            }
        }
        if (created && !AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 0, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
        }
    }

    public void updateConsumer(ConsumerControl consumerControl) {
        ConsumerId consumerId = consumerControl.getConsumerId();
        AMQConsumerBrokerExchange exchange = this.consumerExchanges.get(consumerId);
        if (exchange != null) {
            exchange.updateConsumerPrefetchSize(consumerControl.getPrefetch());
        }
    }

    public void addConsumer(ConsumerInfo info) throws Exception {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.getState();
        if (cs == null) {
            throw new IllegalStateException("Cannot add a consumer to a connection that had not been registered: " + String.valueOf(connectionId));
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException(String.valueOf(this.server) + " Cannot add a consumer to a session that had not been registered: " + String.valueOf(sessionId));
        }
        if (!ss.getConsumerIds().contains(info.getConsumerId())) {
            AMQSession amqSession = this.sessions.get(sessionId);
            if (amqSession == null) {
                throw new IllegalStateException("Session not exist! : " + String.valueOf(sessionId));
            }
            List<AMQConsumer> consumersList = amqSession.createConsumer(info, new SlowConsumerDetection());
            this.addConsumerBrokerExchange(info.getConsumerId(), amqSession, consumersList);
            ss.addConsumer(info);
            info.setLastDeliveredSequenceId(-2L);
            if (consumersList.isEmpty()) {
                return;
            }
            consumersList.forEach(c -> c.start());
            if (AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)info.getDestination()) && AdvisorySupport.isTempDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)info.getDestination())) {
                List<DestinationInfo> tmpDests = this.protocolManager.getTemporaryDestinations();
                for (DestinationInfo di : tmpDests) {
                    ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)di.getDestination());
                    String originalConnectionId = di.getConnectionId().getValue();
                    this.protocolManager.fireAdvisory(this.context, topic, (Command)di, info.getConsumerId(), originalConnectionId);
                }
            }
        }
    }

    public void setConnectionEntry(ConnectionEntry connectionEntry) {
        this.connectionEntry = connectionEntry;
    }

    public boolean checkDataReceived() {
        if (this.disableTtl.get()) {
            return true;
        }
        return super.checkDataReceived();
    }

    public void setUpTtl(long inactivityDuration, long inactivityDurationInitialDelay, boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
        this.maxInactivityDuration = inactivityDuration;
        if (this.useKeepAlive) {
            this.ttlCheck = this.protocolManager.getScheduledPool().schedule(() -> {
                if (inactivityDuration >= 0L) {
                    this.connectionEntry.ttl = inactivityDuration;
                }
            }, inactivityDurationInitialDelay, TimeUnit.MILLISECONDS);
            this.checkInactivity();
        }
    }

    public void addKnownDestination(SimpleString address) {
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch(address.toString());
        if (!addressSettings.isAutoDeleteAddresses().booleanValue() && !addressSettings.isAutoDeleteQueues().booleanValue()) {
            this.knownDestinations.add(address);
        }
    }

    public boolean containsKnownDestination(SimpleString address) {
        return this.knownDestinations.contains(address);
    }

    public void tempQueueDeleted(SimpleString queueName) {
        this.tempDestinationDeleted(queueName, (org.apache.activemq.command.ActiveMQDestination)new ActiveMQTempQueue(queueName.toString()));
    }

    public void tempAddressDeleted(SimpleString addressName) {
        this.tempDestinationDeleted(addressName, (org.apache.activemq.command.ActiveMQDestination)new ActiveMQTempTopic(addressName.toString()));
    }

    private void tempDestinationDeleted(SimpleString name, org.apache.activemq.command.ActiveMQDestination dest) {
        this.state.removeTempDestination(dest);
        if (logger.isDebugEnabled()) {
            logger.debug("{} removed temp destination from state: {} ; {}", new Object[]{this, name, this.state.getTempDestinations().size()});
        }
        if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 1, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            try {
                this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
            }
            catch (Exception e) {
                logger.warn("Failed to fire advisory on {}", (Object)topic, (Object)e);
            }
        }
    }

    public void disableTtl() {
        this.disableTtl.set(true);
    }

    public void enableTtl() {
        this.disableTtl.set(false);
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public List<DestinationInfo> getTemporaryDestinations() {
        return this.state.getTempDestinations();
    }

    public boolean isSuppressInternalManagementObjects() {
        return this.protocolManager.isSuppressInternalManagementObjects();
    }

    public boolean isSuppportAdvisory() {
        return this.protocolManager.isSupportAdvisory();
    }

    public String getValidatedUser() {
        return this.validatedUser;
    }

    public void setValidatedUser(String validatedUser) {
        this.validatedUser = validatedUser;
    }

    public void addSessions(Set<SessionId> sessionSet) {
        for (SessionId sid : sessionSet) {
            this.addSession(this.getState().getSessionState(sid).getInfo());
        }
    }

    public AMQSession addSession(SessionInfo ss) {
        AMQSession amqSession = new AMQSession(this.getState().getInfo(), ss, this.server, this, this.protocolManager, this.coreMessageObjectPools);
        amqSession.initialize();
        amqSession.start();
        this.sessions.put(ss.getSessionId(), amqSession);
        this.sessionIdMap.put(amqSession.getCoreSession().getName(), ss.getSessionId());
        return amqSession;
    }

    public void removeSession(AMQConnectionContext context, SessionInfo info) throws Exception {
        AMQSession session = this.sessions.remove(info.getSessionId());
        if (session != null) {
            this.sessionIdMap.remove(session.getCoreSession().getName());
            session.close();
        }
    }

    public AMQSession getSession(SessionId sessionId) {
        return this.sessions.get(sessionId);
    }

    public void removeDestination(org.apache.activemq.command.ActiveMQDestination dest) throws Exception {
        if (!dest.isTemporary()) {
            logger.warn("OpenWire client sending a queue remove towards {}", (Object)dest.getPhysicalName());
        }
        if (dest.isQueue()) {
            try {
                this.server.destroyQueue(SimpleString.of((String)dest.getPhysicalName()), (SecurityAuth)this.getRemotingConnection());
            }
            catch (ActiveMQNonExistentQueueException neq) {
                logger.debug("queue never existed");
            }
        } else {
            try {
                this.server.removeAddressInfo(SimpleString.of((String)dest.getPhysicalName()), (SecurityAuth)this.getRemotingConnection(), true);
            }
            catch (ActiveMQAddressDoesNotExistException neq) {
                logger.debug("address never existed");
            }
        }
        if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest)) {
            AMQConnectionContext context = this.getContext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 1, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)dest);
            this.protocolManager.fireAdvisory(context, topic, (Command)advInfo);
        }
    }

    private void propagateLastSequenceId(SessionState sessionState, long lastDeliveredSequenceId) {
        for (ConsumerState consumerState : sessionState.getConsumerStates()) {
            consumerState.getInfo().setLastDeliveredSequenceId(lastDeliveredSequenceId);
        }
    }

    private boolean tempDestinationExists(String name) {
        boolean result = false;
        for (DestinationInfo destinationInfo : this.state.getTempDestinations()) {
            if (!destinationInfo.getDestination().getPhysicalName().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void recoverOperationContext() {
        this.server.getStorageManager().setContext(this.operationContext);
    }

    private void clearupOperationContext() {
        if (this.server != null && this.server.getStorageManager() != null) {
            this.server.getStorageManager().clearContext();
        }
    }

    private Transaction lookupTX(TransactionId txID, AMQSession session) throws Exception {
        Transaction transaction;
        if (txID == null) {
            return null;
        }
        if (txID.isXATransaction()) {
            XidImpl xid = OpenWireUtil.toXID(txID);
            transaction = this.server.getResourceManager().getTransaction((Xid)xid);
        } else {
            transaction = this.txMap.get(txID);
        }
        if (transaction == null) {
            return null;
        }
        if (session != null && transaction.getProtocolData() != session) {
            transaction.setProtocolData((Object)session);
        }
        return transaction;
    }

    public static XAException newXAException(String s, int errorCode) {
        XAException xaException = new XAException(s + " xaErrorCode:" + errorCode);
        xaException.errorCode = errorCode;
        return xaException;
    }

    public boolean isSupportsFlowControl() {
        return true;
    }

    public String getProtocolName() {
        return "OPENWIRE";
    }

    public String getClientID() {
        return this.context != null ? this.context.getClientId() : null;
    }

    public CoreMessageObjectPools getCoreMessageObjectPools() {
        return this.coreMessageObjectPools;
    }

    public void logCommand(Command command, boolean in) {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder().append("OpenWire(").append(this.getRemoteAddress()).append(", ").append(this.getID()).append("):");
            if (in) {
                message.append(" IN << ");
            } else {
                message.append("OUT >> ");
            }
            message.append((Object)Objects.requireNonNullElse(command, "NULL"));
            logger.trace(message.toString());
        }
    }

    public class CommandProcessor
    implements CommandVisitor {
        public AMQConnectionContext getContext() {
            return OpenWireConnection.this.getContext();
        }

        public Response processAddConnection(ConnectionInfo info) throws Exception {
            try {
                OpenWireConnection.this.protocolManager.validateUser(OpenWireConnection.this, info);
                if (OpenWireConnection.this.transportConnection.getRouter() != null && OpenWireConnection.this.protocolManager.getRoutingHandler().route(OpenWireConnection.this, info)) {
                    OpenWireConnection.this.shutdown(true);
                    return null;
                }
                OpenWireConnection.this.destroyed = false;
                OpenWireConnection.this.protocolManager.addConnection(OpenWireConnection.this, info);
            }
            catch (Exception e) {
                ExceptionResponse resp = new ExceptionResponse((Throwable)e);
                return resp;
            }
            if (info.isManageable() && OpenWireConnection.this.protocolManager.isUpdateClusterClients()) {
                ConnectionControl command = OpenWireConnection.this.protocolManager.newConnectionControl();
                command.setFaultTolerant(OpenWireConnection.this.protocolManager.isFaultTolerantConfiguration());
                if (info.isFailoverReconnect()) {
                    command.setRebalanceConnection(false);
                }
                OpenWireConnection.this.dispatchAsync((Command)command);
            }
            return null;
        }

        public Response processBrokerSubscriptionInfo(BrokerSubscriptionInfo brokerSubscriptionInfo) throws Exception {
            return null;
        }

        public Response processAddProducer(ProducerInfo info) throws Exception {
            SessionId sessionId = info.getProducerId().getParentId();
            ConnectionState cs = OpenWireConnection.this.getState();
            if (cs == null) {
                throw new IllegalStateException("Cannot add a producer to a connection that had not been registered: " + String.valueOf(sessionId.getParentId()));
            }
            SessionState ss = cs.getSessionState(sessionId);
            if (ss == null) {
                throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + String.valueOf(sessionId));
            }
            if (!ss.getProducerIds().contains(info.getProducerId())) {
                org.apache.activemq.command.ActiveMQDestination destination = info.getDestination();
                AMQSession session = OpenWireConnection.this.getSession(info.getProducerId().getParentId());
                if (destination != null) {
                    session.checkDestinationForSendPermission(destination);
                    if (!AdvisorySupport.isAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)destination)) {
                        OpenWireConnection.this.addDestination(new DestinationInfo(this.getContext().getConnectionId(), 0, destination));
                    }
                }
                ss.addProducer(info);
                session.getCoreSession().addProducer(info.getProducerId().toString(), "OPENWIRE", info.getDestination() != null ? info.getDestination().getPhysicalName() : null);
            }
            return null;
        }

        public Response processAddConsumer(ConsumerInfo info) throws Exception {
            OpenWireConnection.this.addConsumer(info);
            return null;
        }

        public Response processRemoveDestination(DestinationInfo info) throws Exception {
            org.apache.activemq.command.ActiveMQDestination dest = info.getDestination();
            OpenWireConnection.this.removeDestination(dest);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processRemoveProducer(ProducerId id) throws Exception {
            SessionState ss;
            ConnectionState cs = OpenWireConnection.this.getState();
            if (cs != null && (ss = cs.getSessionState(id.getParentId())) != null) {
                ss.removeProducer(id);
            }
            Map<ProducerId, AMQProducerBrokerExchange> map = OpenWireConnection.this.producerExchanges;
            synchronized (map) {
                OpenWireConnection.this.producerExchanges.remove(id);
                OpenWireConnection.this.getSession(id.getParentId()).getCoreSession().removeProducer(id.toString());
            }
            return null;
        }

        public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) throws Exception {
            SessionState session = OpenWireConnection.this.state.getSessionState(id);
            if (session == null) {
                throw new IllegalStateException("Cannot remove session that had not been registered: " + String.valueOf(id));
            }
            session.shutdown();
            for (ProducerId producerId : session.getProducerIds()) {
                this.processRemoveProducer(producerId);
            }
            for (ConsumerId consumerId : session.getConsumerIds()) {
                this.processRemoveConsumer(consumerId, lastDeliveredSequenceId);
            }
            OpenWireConnection.this.state.removeSession(id);
            OpenWireConnection.this.propagateLastSequenceId(session, lastDeliveredSequenceId);
            OpenWireConnection.this.removeSession(OpenWireConnection.this.context, session.getInfo());
            return null;
        }

        public Response processRemoveSubscription(RemoveSubscriptionInfo subInfo) throws Exception {
            SimpleString subQueueName = ActiveMQDestination.createQueueNameForSubscription((boolean)true, (String)subInfo.getClientId(), (String)subInfo.getSubscriptionName());
            OpenWireConnection.this.server.destroyQueue(subQueueName);
            return null;
        }

        public Response processRollbackTransaction(TransactionInfo info) throws Exception {
            Transaction tx = OpenWireConnection.this.lookupTX(info.getTransactionId(), null);
            if (tx == null) {
                throw new IllegalStateException("Transaction not started, " + String.valueOf(info.getTransactionId()));
            }
            final AMQSession amqSession = tx != null ? (AMQSession)tx.getProtocolData() : null;
            if (info.getTransactionId().isXATransaction() && tx == null) {
                throw OpenWireConnection.newXAException("Transaction '" + String.valueOf(info.getTransactionId()) + "' has not been started.", -4);
            }
            if (tx != null && amqSession != null) {
                amqSession.getCoreSession().resetTX(tx);
                tx.addOperation((TransactionOperation)new TransactionOperationAbstract(this){
                    final /* synthetic */ CommandProcessor this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void beforeRollback(Transaction tx) throws Exception {
                        this.this$1.returnReferences(tx, amqSession);
                    }
                });
            }
            if (info.getTransactionId().isXATransaction()) {
                ResourceManager resourceManager = OpenWireConnection.this.server.getResourceManager();
                XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                if (tx == null) {
                    if (resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                        XAException ex = new XAException("transaction has been heuristically committed: " + String.valueOf(xid));
                        ex.errorCode = 7;
                        throw ex;
                    }
                    if (resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                        XAException ex = new XAException("transaction has been heuristically rolled back: " + String.valueOf(xid));
                        ex.errorCode = 6;
                        throw ex;
                    }
                    logger.trace("xarollback into {}, xid={} forcing a rollback regular", (Object)tx, (Object)xid);
                    try {
                        if (amqSession != null) {
                            amqSession.getCoreSession().rollback(false);
                        }
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                    XAException ex = new XAException("Cannot find xid in resource manager: " + String.valueOf(xid));
                    ex.errorCode = -4;
                    throw ex;
                }
                if (tx.getState() == Transaction.State.SUSPENDED) {
                    logger.trace("xarollback into {} sending tx back as it was suspended", (Object)tx);
                    resourceManager.putTransaction((Xid)xid, tx, (RemotingConnection)OpenWireConnection.this);
                    XAException ex = new XAException("Cannot commit transaction, it is suspended " + String.valueOf(xid));
                    ex.errorCode = -6;
                    throw ex;
                }
                tx.rollback();
            } else if (tx != null) {
                tx.rollback();
            }
            return null;
        }

        private void returnReferences(Transaction tx, AMQSession session) throws Exception {
            if (session == null || session.isClosed()) {
                return;
            }
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper != null) {
                List ackRefs = oper.getReferencesToAcknowledge();
                ListIterator referenceIterator = ackRefs.listIterator(ackRefs.size());
                while (referenceIterator.hasPrevious()) {
                    MessageReference ref = (MessageReference)referenceIterator.previous();
                    ServerConsumer consumer = null;
                    if (ref.hasConsumerId()) {
                        consumer = session.getCoreSession().locateConsumer(ref.getConsumerId());
                    }
                    if (consumer == null) continue;
                    referenceIterator.remove();
                    ref.incrementDeliveryCount();
                    consumer.backToDelivering(ref);
                    AMQConsumer amqConsumer = (AMQConsumer)consumer.getProtocolData();
                    amqConsumer.addRolledback(ref);
                }
            }
        }

        public Response processShutdown(ShutdownInfo info) throws Exception {
            OpenWireConnection.this.shutdown(false);
            return null;
        }

        public Response processWireFormat(WireFormatInfo command) throws Exception {
            OpenWireConnection.this.inWireFormat.renegotiateWireFormat(command);
            OpenWireConnection.this.outWireFormat.renegotiateWireFormat(command);
            OpenWireConnection.this.protocolManager.sendBrokerInfo(OpenWireConnection.this);
            OpenWireConnection.this.protocolManager.configureInactivityParams(OpenWireConnection.this, command);
            return null;
        }

        public Response processAddDestination(DestinationInfo dest) throws Exception {
            ExceptionResponse resp = null;
            try {
                OpenWireConnection.this.addDestination(dest);
            }
            catch (Exception e) {
                resp = e instanceof ActiveMQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
            }
            return resp;
        }

        public Response processAddSession(SessionInfo info) throws Exception {
            if (OpenWireConnection.this.state != null && !OpenWireConnection.this.state.getSessionIds().contains(info.getSessionId())) {
                OpenWireConnection.this.addSession(info);
                OpenWireConnection.this.state.addSession(info);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processBeginTransaction(TransactionInfo info) throws Exception {
            final TransactionId txID = info.getTransactionId();
            try {
                OpenWireConnection.this.internalSession.resetTX(null);
                if (txID.isXATransaction()) {
                    XidImpl xid = OpenWireUtil.toXID(txID);
                    OpenWireConnection.this.internalSession.xaStart((Xid)xid);
                    final ResourceManager resourceManager = OpenWireConnection.this.server.getResourceManager();
                    Transaction transaction = resourceManager.getTransaction((Xid)xid);
                    transaction.addOperation((TransactionOperation)new TransactionOperationAbstract(this, (Xid)xid){
                        final /* synthetic */ Xid val$xid;
                        final /* synthetic */ CommandProcessor this$1;
                        {
                            this.val$xid = xid;
                            this.this$1 = this$1;
                        }

                        public void afterCommit(Transaction tx) {
                            this.removeFromResourceManager();
                        }

                        public void afterRollback(Transaction tx) {
                            this.removeFromResourceManager();
                        }

                        private void removeFromResourceManager() {
                            try {
                                resourceManager.removeTransaction(this.val$xid, (RemotingConnection)this.this$1.OpenWireConnection.this.getRemotingConnection());
                            }
                            catch (ActiveMQException activeMQException) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    Transaction transaction = OpenWireConnection.this.internalSession.newTransaction();
                    OpenWireConnection.this.txMap.put(txID, transaction);
                    transaction.addOperation((TransactionOperation)new TransactionOperationAbstract(this){
                        final /* synthetic */ CommandProcessor this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void afterCommit(Transaction tx) {
                            this.removeFromTxMap();
                        }

                        public void afterRollback(Transaction tx) {
                            this.removeFromTxMap();
                        }

                        private void removeFromTxMap() {
                            this.this$1.OpenWireConnection.this.txMap.remove(txID);
                        }
                    });
                }
            }
            finally {
                OpenWireConnection.this.internalSession.resetTX(null);
            }
            return null;
        }

        public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
            return this.processCommit(info, true);
        }

        private Response processCommit(TransactionInfo info, boolean onePhase) throws Exception {
            TransactionId txID = info.getTransactionId();
            Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
            if (tx == null) {
                throw new IllegalStateException("Transaction not started, " + String.valueOf(txID));
            }
            if (txID.isXATransaction()) {
                ResourceManager resourceManager = OpenWireConnection.this.server.getResourceManager();
                XidImpl xid = OpenWireUtil.toXID(txID);
                logger.trace("XAcommit into {}, xid={}", (Object)tx, (Object)xid);
                if (tx == null) {
                    if (resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                        XAException ex = new XAException("transaction has been heuristically committed: " + String.valueOf(xid));
                        ex.errorCode = 7;
                        throw ex;
                    }
                    if (resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                        XAException ex = new XAException("transaction has been heuristically rolled back: " + String.valueOf(xid));
                        ex.errorCode = 6;
                        throw ex;
                    }
                    logger.trace("XAcommit into {}, xid={} cannot find it", (Object)tx, (Object)xid);
                    XAException ex = new XAException("Cannot find xid in resource manager: " + String.valueOf(xid));
                    ex.errorCode = -4;
                    throw ex;
                }
                if (tx.getState() == Transaction.State.SUSPENDED) {
                    resourceManager.putTransaction((Xid)xid, tx, (RemotingConnection)OpenWireConnection.this);
                    XAException ex = new XAException("Cannot commit transaction, it is suspended " + String.valueOf(xid));
                    ex.errorCode = -6;
                    throw ex;
                }
                tx.commit(onePhase);
            } else if (tx != null) {
                AMQSession amqSession = (AMQSession)tx.getProtocolData();
                if (amqSession != null) {
                    amqSession.getCoreSession().resetTX(tx);
                    amqSession.getCoreSession().commit();
                } else {
                    tx.commit(true);
                }
            }
            return null;
        }

        public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
            return this.processCommit(info, false);
        }

        public Response processForgetTransaction(TransactionInfo info) throws Exception {
            TransactionId txID = info.getTransactionId();
            if (txID.isXATransaction()) {
                try {
                    XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                    OpenWireConnection.this.internalSession.xaForget((Xid)xid);
                }
                catch (Exception e) {
                    logger.warn("Error during method invocation", (Throwable)e);
                    throw e;
                }
            } else {
                OpenWireConnection.this.txMap.remove(txID);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processPrepareTransaction(TransactionInfo info) throws Exception {
            block6: {
                TransactionId txID = info.getTransactionId();
                try {
                    if (txID.isXATransaction()) {
                        try {
                            XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                            OpenWireConnection.this.internalSession.xaPrepare((Xid)xid);
                            break block6;
                        }
                        catch (Exception e) {
                            logger.warn("Error during method invocation", (Throwable)e);
                            throw e;
                        }
                    }
                    Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
                    tx.prepare();
                }
                finally {
                    OpenWireConnection.this.internalSession.resetTX(null);
                }
            }
            return new IntegerResponse(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processEndTransaction(TransactionInfo info) throws Exception {
            TransactionId txID = info.getTransactionId();
            if (txID.isXATransaction()) {
                try {
                    Transaction tx = OpenWireConnection.this.lookupTX(txID, null);
                    OpenWireConnection.this.internalSession.resetTX(tx);
                    try {
                        XidImpl xid = OpenWireUtil.toXID(info.getTransactionId());
                        OpenWireConnection.this.internalSession.xaEnd((Xid)xid);
                    }
                    finally {
                        OpenWireConnection.this.internalSession.resetTX(null);
                    }
                }
                catch (Exception e) {
                    logger.warn("Error during method invocation", (Throwable)e);
                    throw e;
                }
            }
            return null;
        }

        public Response processBrokerInfo(BrokerInfo arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processConnectionControl(ConnectionControl connectionControl) throws Exception {
            return null;
        }

        public Response processConnectionError(ConnectionError arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processConsumerControl(ConsumerControl consumerControl) throws Exception {
            try {
                OpenWireConnection.this.updateConsumer(consumerControl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Response processControlCommand(ControlCommand arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processFlush(FlushCommand arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processKeepAlive(KeepAliveInfo arg0) throws Exception {
            throw new IllegalStateException("not implemented! ");
        }

        public Response processMessage(Message messageSend) throws Exception {
            ProducerId producerId = messageSend.getProducerId();
            AMQProducerBrokerExchange producerExchange = OpenWireConnection.this.getProducerBrokerExchange(producerId);
            AMQConnectionContext pcontext = producerExchange.getConnectionContext();
            ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
            boolean sendProducerAck = !messageSend.isResponseRequired() && producerInfo.getWindowSize() > 0 && !pcontext.isInRecoveryMode();
            AMQSession session = OpenWireConnection.this.getSession(producerId.getParentId());
            Transaction tx = OpenWireConnection.this.lookupTX(messageSend.getTransactionId(), session);
            if (messageSend.getTransactionId() != null && tx == null) {
                throw new IllegalStateException("Transaction not started, " + String.valueOf(messageSend.getTransactionId()));
            }
            session.getCoreSession().resetTX(tx);
            try {
                session.send(producerInfo, messageSend, sendProducerAck);
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.markAsRollbackOnly(new ActiveMQException(e.getMessage()));
                } else if (e instanceof ActiveMQNonExistentQueueException && producerInfo.getDestination() == null) {
                    OpenWireConnection.this.sendException(e);
                }
                throw e;
            }
            return null;
        }

        public Response processMessageAck(MessageAck ack) throws Exception {
            block3: {
                AMQSession session = OpenWireConnection.this.getSession(ack.getConsumerId().getParentId());
                Transaction tx = OpenWireConnection.this.lookupTX(ack.getTransactionId(), session);
                if (ack.getTransactionId() != null && tx == null) {
                    throw new IllegalStateException("Transaction not started, " + String.valueOf(ack.getTransactionId()));
                }
                session.getCoreSession().resetTX(tx);
                try {
                    AMQConsumerBrokerExchange consumerBrokerExchange = OpenWireConnection.this.consumerExchanges.get(ack.getConsumerId());
                    consumerBrokerExchange.acknowledge(ack);
                }
                catch (Exception e) {
                    if (tx == null) break block3;
                    tx.markAsRollbackOnly(new ActiveMQException(e.getMessage()));
                }
            }
            return null;
        }

        public Response processMessageDispatch(MessageDispatch arg0) throws Exception {
            return null;
        }

        public Response processMessageDispatchNotification(MessageDispatchNotification arg0) throws Exception {
            return null;
        }

        public Response processMessagePull(MessagePull arg0) throws Exception {
            AMQConsumerBrokerExchange amqConsumerBrokerExchange = OpenWireConnection.this.consumerExchanges.get(arg0.getConsumerId());
            if (amqConsumerBrokerExchange == null) {
                throw new IllegalStateException("Consumer does not exist");
            }
            amqConsumerBrokerExchange.processMessagePull(arg0);
            return null;
        }

        public Response processProducerAck(ProducerAck arg0) throws Exception {
            return null;
        }

        public Response processRecoverTransactions(TransactionInfo info) throws Exception {
            List xids = OpenWireConnection.this.server.getResourceManager().getInDoubtTransactions();
            ArrayList<XATransactionId> recovered = new ArrayList<XATransactionId>();
            for (Xid xid : xids) {
                XATransactionId amqXid = new XATransactionId(xid);
                recovered.add(amqXid);
            }
            return new DataArrayResponse((DataStructure[])recovered.toArray(new TransactionId[recovered.size()]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws Exception {
            for (SessionState sessionState : OpenWireConnection.this.state.getSessionStates()) {
                OpenWireConnection.this.propagateLastSequenceId(sessionState, lastDeliveredSequenceId);
            }
            try {
                OpenWireConnection.this.protocolManager.removeConnection(OpenWireConnection.this.getClientID(), OpenWireConnection.this);
            }
            finally {
                OpenWireConnection.this.disconnect(false);
            }
            return null;
        }

        public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) throws Exception {
            if (OpenWireConnection.this.destroyed) {
                return null;
            }
            SessionId sessionId = id.getParentId();
            SessionState ss = OpenWireConnection.this.state.getSessionState(sessionId);
            if (ss == null) {
                throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + String.valueOf(sessionId));
            }
            ConsumerState consumerState = ss.removeConsumer(id);
            if (consumerState == null) {
                throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + String.valueOf(id));
            }
            ConsumerInfo info = consumerState.getInfo();
            info.setLastDeliveredSequenceId(lastDeliveredSequenceId);
            AMQConsumerBrokerExchange consumerBrokerExchange = OpenWireConnection.this.consumerExchanges.remove(id);
            consumerBrokerExchange.removeConsumer();
            return null;
        }
    }

    class SlowConsumerDetection
    implements SlowConsumerDetectionListener {
        SlowConsumerDetection() {
        }

        public void onSlowConsumer(ServerConsumer consumer) {
            Object object;
            if (consumer.getProtocolData() != null && (object = consumer.getProtocolData()) instanceof AMQConsumer) {
                AMQConsumer amqConsumer = (AMQConsumer)object;
                ActiveMQTopic topic = AdvisorySupport.getSlowConsumerAdvisoryTopic((org.apache.activemq.command.ActiveMQDestination)amqConsumer.getOpenwireDestination());
                ActiveMQMessage advisoryMessage = new ActiveMQMessage();
                try {
                    advisoryMessage.setStringProperty("consumerId", amqConsumer.getId().toString());
                    OpenWireConnection.this.protocolManager.fireAdvisory(OpenWireConnection.this.context, topic, (Command)advisoryMessage, amqConsumer.getId(), null);
                }
                catch (Exception e) {
                    logger.warn("Error during method invocation", (Throwable)e);
                }
            }
        }
    }
}

