/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.netty.GrpcSslContexts;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.arrow.driver.jdbc.shaded.io.netty.channel.EventLoopGroup;
import org.apache.arrow.driver.jdbc.shaded.io.netty.channel.ServerChannel;
import org.apache.arrow.driver.jdbc.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.apache.arrow.driver.jdbc.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Location;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;

public class NettyClientBuilder {
    private static final int MAX_CHANNEL_TRACE_EVENTS = 0;
    protected BufferAllocator allocator;
    protected Location location;
    protected boolean forceTls = false;
    protected int maxInboundMessageSize = Integer.MAX_VALUE;
    protected InputStream trustedCertificates = null;
    protected InputStream clientCertificate = null;
    protected InputStream clientKey = null;
    protected String overrideHostname = null;
    protected List<FlightClientMiddleware.Factory> middleware = new ArrayList<FlightClientMiddleware.Factory>();
    protected boolean verifyServer = true;

    public NettyClientBuilder() {
    }

    public NettyClientBuilder(BufferAllocator allocator, Location location) {
        this.allocator = Preconditions.checkNotNull(allocator);
        this.location = Preconditions.checkNotNull(location);
    }

    public NettyClientBuilder useTls() {
        this.forceTls = true;
        return this;
    }

    public NettyClientBuilder overrideHostname(String hostname) {
        this.overrideHostname = hostname;
        return this;
    }

    public NettyClientBuilder maxInboundMessageSize(int maxSize) {
        Preconditions.checkArgument(maxSize > 0);
        this.maxInboundMessageSize = maxSize;
        return this;
    }

    public NettyClientBuilder trustedCertificates(InputStream stream) {
        this.trustedCertificates = Preconditions.checkNotNull(stream);
        return this;
    }

    public NettyClientBuilder clientCertificate(InputStream clientCertificate, InputStream clientKey) {
        Preconditions.checkNotNull(clientKey);
        this.clientCertificate = Preconditions.checkNotNull(clientCertificate);
        this.clientKey = Preconditions.checkNotNull(clientKey);
        return this;
    }

    public BufferAllocator allocator() {
        return this.allocator;
    }

    public NettyClientBuilder allocator(BufferAllocator allocator) {
        this.allocator = Preconditions.checkNotNull(allocator);
        return this;
    }

    public NettyClientBuilder location(Location location) {
        this.location = Preconditions.checkNotNull(location);
        return this;
    }

    public List<FlightClientMiddleware.Factory> middleware() {
        return Collections.unmodifiableList(this.middleware);
    }

    public NettyClientBuilder intercept(FlightClientMiddleware.Factory factory) {
        this.middleware.add(factory);
        return this;
    }

    public NettyClientBuilder verifyServer(boolean verifyServer) {
        this.verifyServer = verifyServer;
        return this;
    }

    public NettyChannelBuilder build() {
        NettyChannelBuilder builder;
        switch (this.location.getUri().getScheme()) {
            case "grpc": 
            case "grpc+tcp": 
            case "grpc+tls": {
                builder = NettyChannelBuilder.forAddress(this.location.toSocketAddress());
                break;
            }
            case "grpc+unix": {
                builder = NettyChannelBuilder.forAddress(this.location.toSocketAddress());
                try {
                    try {
                        builder.channelType(Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.epoll.EpollDomainSocketChannel").asSubclass(ServerChannel.class));
                        EventLoopGroup elg = Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.epoll.EpollEventLoopGroup").asSubclass(EventLoopGroup.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        builder.eventLoopGroup(elg);
                    }
                    catch (ClassNotFoundException e) {
                        builder.channelType(Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel").asSubclass(ServerChannel.class));
                        EventLoopGroup elg = Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup").asSubclass(EventLoopGroup.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        builder.eventLoopGroup(elg);
                    }
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new UnsupportedOperationException("Could not find suitable Netty native transport implementation for domain socket address.");
                }
            }
            default: {
                throw new IllegalArgumentException("Scheme is not supported: " + this.location.getUri().getScheme());
            }
        }
        if (this.forceTls || "grpc+tls".equals(this.location.getUri().getScheme())) {
            boolean hasKeyCertPair;
            builder.useTransportSecurity();
            boolean hasTrustedCerts = this.trustedCertificates != null;
            boolean bl = hasKeyCertPair = this.clientCertificate != null && this.clientKey != null;
            if (!this.verifyServer && (hasTrustedCerts || hasKeyCertPair)) {
                throw new IllegalArgumentException("FlightClient has been configured to disable server verification, but certificate options have been specified.");
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (!this.verifyServer) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (this.trustedCertificates != null || this.clientCertificate != null || this.clientKey != null) {
                if (this.trustedCertificates != null) {
                    sslContextBuilder.trustManager(this.trustedCertificates);
                }
                if (this.clientCertificate != null && this.clientKey != null) {
                    sslContextBuilder.keyManager(this.clientCertificate, this.clientKey);
                }
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            if (this.overrideHostname != null) {
                builder.overrideAuthority(this.overrideHostname);
            }
        } else {
            builder.usePlaintext();
        }
        ((NettyChannelBuilder)builder.maxTraceEvents(0)).maxInboundMessageSize(this.maxInboundMessageSize).maxInboundMetadataSize(this.maxInboundMessageSize);
        return builder;
    }
}

