/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.text;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.Text;
import org.apache.arrow.driver.jdbc.utils.DateTimeUtils;

public class ArrowFlightJdbcVarCharVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final Getter getter;

    public ArrowFlightJdbcVarCharVectorAccessor(VarCharVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this(vector::get, currentRowSupplier, setCursorWasNull);
    }

    public ArrowFlightJdbcVarCharVectorAccessor(LargeVarCharVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this(vector::get, currentRowSupplier, setCursorWasNull);
    }

    ArrowFlightJdbcVarCharVectorAccessor(Getter getter, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = getter;
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public String getObject() {
        byte[] bytes = this.getBytes();
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public String getString() {
        return this.getObject();
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.getter.get(this.getCurrentRow());
        this.wasNull = bytes == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return bytes;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        String value = this.getString();
        if (value == null || value.equalsIgnoreCase("false") || value.equals("0")) {
            return false;
        }
        if (value.equalsIgnoreCase("true") || value.equals("1")) {
            return true;
        }
        throw new SQLException("It is not possible to convert this value to boolean: " + value);
    }

    @Override
    public byte getByte() throws SQLException {
        try {
            return Byte.parseByte(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public short getShort() throws SQLException {
        try {
            return Short.parseShort(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getInt() throws SQLException {
        try {
            return Integer.parseInt(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long getLong() throws SQLException {
        try {
            return Long.parseLong(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public float getFloat() throws SQLException {
        try {
            return Float.parseFloat(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public double getDouble() throws SQLException {
        try {
            return Double.parseDouble(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        try {
            return new BigDecimal(this.getString());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        try {
            return BigDecimal.valueOf(this.getLong(), i);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getAsciiStream() {
        String textValue = this.getString();
        if (textValue == null) {
            return null;
        }
        return new ByteArrayInputStream(textValue.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream getUnicodeStream() {
        byte[] value = this.getBytes();
        if (value == null) {
            return null;
        }
        Text textValue = new Text(value);
        return new ByteArrayInputStream(textValue.getBytes(), 0, (int)textValue.getLength());
    }

    @Override
    public Reader getCharacterStream() {
        return new CharArrayReader(this.getString().toCharArray());
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        try {
            Date date = Date.valueOf(this.getString());
            if (calendar == null) {
                return date;
            }
            long milliseconds = date.getTime();
            return new Date(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        try {
            Time time = Time.valueOf(this.getString());
            if (calendar == null) {
                return time;
            }
            long milliseconds = time.getTime();
            return new Time(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        try {
            Timestamp timestamp = Timestamp.valueOf(this.getString());
            if (calendar == null) {
                return timestamp;
            }
            long milliseconds = timestamp.getTime();
            return new Timestamp(DateTimeUtils.applyCalendarOffset(milliseconds, calendar));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @FunctionalInterface
    static interface Getter {
        public byte[] get(int var1);
    }
}

