/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeStampVectorGetter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.DateUtility;

public class ArrowFlightJdbcTimeStampVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final TimeZone timeZone;
    private final ArrowFlightJdbcTimeStampVectorGetter.Getter getter;
    private final TimeUnit timeUnit;
    private final LongToLocalDateTime longToLocalDateTime;
    private final ArrowFlightJdbcTimeStampVectorGetter.Holder holder = new ArrowFlightJdbcTimeStampVectorGetter.Holder();
    private final boolean isZoned;

    public ArrowFlightJdbcTimeStampVectorAccessor(TimeStampVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = ArrowFlightJdbcTimeStampVectorGetter.createGetter(vector);
        this.isZoned = ArrowFlightJdbcTimeStampVectorAccessor.getVectorIsZoned(vector);
        this.timeZone = ArrowFlightJdbcTimeStampVectorAccessor.getTimeZoneForVector(vector);
        this.timeUnit = ArrowFlightJdbcTimeStampVectorAccessor.getTimeUnitForVector(vector);
        this.longToLocalDateTime = ArrowFlightJdbcTimeStampVectorAccessor.getLongToLocalDateTimeForVector(vector, this.timeZone);
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public <T> T getObject(Class<T> type) throws SQLException {
        Object value;
        if (!this.isZoned & Set.of(OffsetDateTime.class, ZonedDateTime.class, Instant.class).contains(type)) {
            throw new SQLException("Vectors without timezones can't be converted to objects with offset/tz info.");
        }
        if (type == OffsetDateTime.class) {
            value = this.getOffsetDateTime();
        } else if (type == LocalDateTime.class) {
            value = this.getLocalDateTime(null);
        } else if (type == ZonedDateTime.class) {
            value = this.getZonedDateTime();
        } else if (type == Instant.class) {
            value = this.getInstant();
        } else if (type == Timestamp.class) {
            value = this.getObject();
        } else {
            throw new SQLException("Object type not supported for TimeStamp Vector");
        }
        return (T)(!type.isPrimitive() && this.wasNull ? null : type.cast(value));
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    private ZonedDateTime getZonedDateTime() {
        LocalDateTime localDateTime = this.getLocalDateTime(null);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(this.timeZone.toZoneId());
    }

    private OffsetDateTime getOffsetDateTime() {
        LocalDateTime localDateTime = this.getLocalDateTime(null);
        if (localDateTime == null) {
            return null;
        }
        ZoneOffset offset = this.timeZone.toZoneId().getRules().getOffset(localDateTime);
        return localDateTime.atOffset(offset);
    }

    private Instant getInstant() {
        LocalDateTime localDateTime = this.getLocalDateTime(null);
        if (localDateTime == null) {
            return null;
        }
        ZoneOffset offset = this.timeZone.toZoneId().getRules().getOffset(localDateTime);
        return localDateTime.toInstant(offset);
    }

    private LocalDateTime getLocalDateTime(Calendar calendar) {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return null;
        }
        long value = this.holder.value;
        LocalDateTime localDateTime = this.longToLocalDateTime.fromLong(value);
        if (calendar != null && this.isZoned) {
            TimeZone timeZone = calendar.getTimeZone();
            long millis = this.timeUnit.toMillis(value);
            localDateTime = localDateTime.minus(timeZone.getOffset(millis) - this.timeZone.getOffset(millis), ChronoUnit.MILLIS);
        }
        return localDateTime;
    }

    @Override
    public Date getDate(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return new Date(this.getTimestampWithOffset(calendar, localDateTime).getTime());
    }

    @Override
    public Time getTime(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return new Time(this.getTimestampWithOffset(calendar, localDateTime).getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        LocalDateTime localDateTime = this.getLocalDateTime(calendar);
        if (localDateTime == null) {
            return null;
        }
        return this.getTimestampWithOffset(calendar, localDateTime);
    }

    private Timestamp getTimestampWithOffset(Calendar calendar, LocalDateTime localDateTime) {
        if (calendar != null && !this.isZoned) {
            TimeZone timeZone = calendar.getTimeZone();
            long millis = Timestamp.valueOf(localDateTime).getTime();
            localDateTime = localDateTime.minus(timeZone.getOffset(millis) - this.timeZone.getOffset(millis), ChronoUnit.MILLIS);
        }
        return Timestamp.valueOf(localDateTime);
    }

    protected static TimeUnit getTimeUnitForVector(TimeStampVector vector) {
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        switch (arrowType.getUnit()) {
            case NANOSECOND: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECOND: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECOND: {
                return TimeUnit.MILLISECONDS;
            }
            case SECOND: {
                return TimeUnit.SECONDS;
            }
        }
        throw new UnsupportedOperationException("Invalid Arrow time unit");
    }

    protected static LongToLocalDateTime getLongToLocalDateTimeForVector(TimeStampVector vector, TimeZone timeZone) {
        String timeZoneID = timeZone.getID();
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        switch (arrowType.getUnit()) {
            case NANOSECOND: {
                return nanoseconds -> DateUtility.getLocalDateTimeFromEpochNano(nanoseconds, timeZoneID);
            }
            case MICROSECOND: {
                return microseconds -> DateUtility.getLocalDateTimeFromEpochMicro(microseconds, timeZoneID);
            }
            case MILLISECOND: {
                return milliseconds -> DateUtility.getLocalDateTimeFromEpochMilli(milliseconds, timeZoneID);
            }
            case SECOND: {
                return seconds -> DateUtility.getLocalDateTimeFromEpochMilli(TimeUnit.SECONDS.toMillis(seconds), timeZoneID);
            }
        }
        throw new UnsupportedOperationException("Invalid Arrow time unit");
    }

    protected static TimeZone getTimeZoneForVector(TimeStampVector vector) {
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        String timezoneName = Objects.requireNonNullElse(arrowType.getTimezone(), "UTC");
        return TimeZone.getTimeZone(timezoneName);
    }

    protected static boolean getVectorIsZoned(TimeStampVector vector) {
        ArrowType.Timestamp arrowType = (ArrowType.Timestamp)vector.getField().getFieldType().getType();
        return arrowType.getTimezone() != null;
    }

    static interface LongToLocalDateTime {
        public LocalDateTime fromLong(long var1);
    }
}

