/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.converter.impl;

import org.apache.arrow.driver.jdbc.converter.impl.BaseAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.IntVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.TypedValue;

public class IntAvaticaParameterConverter
extends BaseAvaticaParameterConverter {
    private final ArrowType.Int type;

    public IntAvaticaParameterConverter(ArrowType.Int type) {
        this.type = type;
    }

    @Override
    public boolean bindParameter(FieldVector vector, TypedValue typedValue, int index) {
        Number value = (Number)typedValue.value;
        if (vector instanceof TinyIntVector) {
            ((TinyIntVector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof SmallIntVector) {
            ((SmallIntVector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof IntVector) {
            ((IntVector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof BigIntVector) {
            ((BigIntVector)vector).setSafe(index, value.longValue());
            return true;
        }
        if (vector instanceof UInt1Vector) {
            ((UInt1Vector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof UInt2Vector) {
            ((UInt2Vector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof UInt4Vector) {
            ((UInt4Vector)vector).setSafe(index, value.intValue());
            return true;
        }
        if (vector instanceof UInt8Vector) {
            ((UInt8Vector)vector).setSafe(index, value.longValue());
            return true;
        }
        return false;
    }

    @Override
    public AvaticaParameter createParameter(Field field) {
        return this.createParameter(field, this.type.getIsSigned());
    }
}

