/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.MetaImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.TypedValue;
import org.apache.arrow.driver.jdbc.utils.AvaticaParameterBinder;
import org.apache.arrow.driver.jdbc.utils.ConvertUtils;

public class ArrowFlightMetaImpl
extends MetaImpl {
    private final Map<StatementHandleKey, ArrowFlightSqlClientHandler.PreparedStatement> statementHandlePreparedStatementMap = new ConcurrentHashMap<StatementHandleKey, ArrowFlightSqlClientHandler.PreparedStatement>();

    public ArrowFlightMetaImpl(AvaticaConnection connection) {
        super(connection);
        this.setDefaultConnectionProperties();
    }

    static Meta.Signature newSignature(String sql, Schema resultSetSchema, Schema parameterSchema) {
        ArrayList<ColumnMetaData> columnMetaData = resultSetSchema == null ? new ArrayList() : ConvertUtils.convertArrowFieldsToColumnMetaDataList(resultSetSchema.getFields());
        ArrayList<AvaticaParameter> parameters = parameterSchema == null ? new ArrayList() : ConvertUtils.convertArrowFieldsToAvaticaParameters(parameterSchema.getFields());
        return new Meta.Signature(columnMetaData, sql, parameters, Collections.emptyMap(), null, Meta.StatementType.SELECT);
    }

    @Override
    public void closeStatement(Meta.StatementHandle statementHandle) {
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = this.statementHandlePreparedStatementMap.remove(new StatementHandleKey(statementHandle));
        if (preparedStatement != null) {
            preparedStatement.close();
        }
    }

    @Override
    public void commit(Meta.ConnectionHandle connectionHandle) {
    }

    @Override
    public Meta.ExecuteResult execute(Meta.StatementHandle statementHandle, List<TypedValue> typedValues, long maxRowCount) {
        Preconditions.checkArgument(this.connection.id.equals(statementHandle.connectionId), "Connection IDs are not consistent");
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = this.getPreparedStatement(statementHandle);
        if (preparedStatement == null) {
            throw new IllegalStateException("Prepared statement not found: " + String.valueOf(statementHandle));
        }
        new AvaticaParameterBinder(preparedStatement, ((ArrowFlightConnection)this.connection).getBufferAllocator()).bind(typedValues);
        if (statementHandle.signature == null) {
            long updatedCount = preparedStatement.executeUpdate();
            return new Meta.ExecuteResult(Collections.singletonList(Meta.MetaResultSet.count(statementHandle.connectionId, statementHandle.id, updatedCount)));
        }
        return new Meta.ExecuteResult(Collections.singletonList(Meta.MetaResultSet.create(statementHandle.connectionId, statementHandle.id, true, statementHandle.signature, null)));
    }

    @Override
    public Meta.ExecuteResult execute(Meta.StatementHandle statementHandle, List<TypedValue> typedValues, int maxRowsInFirstFrame) {
        return this.execute(statementHandle, typedValues, (long)maxRowsInFirstFrame);
    }

    @Override
    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle statementHandle, List<List<TypedValue>> parameterValuesList) throws IllegalStateException {
        Preconditions.checkArgument(this.connection.id.equals(statementHandle.connectionId), "Connection IDs are not consistent");
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = this.getPreparedStatement(statementHandle);
        if (preparedStatement == null) {
            throw new IllegalStateException("Prepared statement not found: " + String.valueOf(statementHandle));
        }
        AvaticaParameterBinder binder = new AvaticaParameterBinder(preparedStatement, ((ArrowFlightConnection)this.connection).getBufferAllocator());
        for (int i = 0; i < parameterValuesList.size(); ++i) {
            binder.bind(parameterValuesList.get(i), i);
        }
        long[] updatedCounts = new long[]{preparedStatement.executeUpdate()};
        return new Meta.ExecuteBatchResult(updatedCounts);
    }

    @Override
    public Meta.Frame fetch(Meta.StatementHandle statementHandle, long offset, int fetchMaxRowCount) {
        throw AvaticaConnection.HELPER.wrap(String.format("%s does not use frames.", this), AvaticaConnection.HELPER.unsupported());
    }

    private ArrowFlightSqlClientHandler.PreparedStatement prepareForHandle(String query, Meta.StatementHandle handle) {
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = ((ArrowFlightConnection)this.connection).getClientHandler().prepare(query);
        handle.signature = ArrowFlightMetaImpl.newSignature(query, preparedStatement.getDataSetSchema(), preparedStatement.getParameterSchema());
        this.statementHandlePreparedStatementMap.put(new StatementHandleKey(handle), preparedStatement);
        return preparedStatement;
    }

    @Override
    public Meta.StatementHandle prepare(Meta.ConnectionHandle connectionHandle, String query, long maxRowCount) {
        Meta.StatementHandle handle = super.createStatement(connectionHandle);
        this.prepareForHandle(query, handle);
        return handle;
    }

    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle statementHandle, String query, long maxRowCount, Meta.PrepareCallback prepareCallback) throws NoSuchStatementException {
        return this.prepareAndExecute(statementHandle, query, maxRowCount, -1, prepareCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle handle, String query, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        try {
            ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = this.prepareForHandle(query, handle);
            Meta.StatementType statementType = preparedStatement.getType();
            long updateCount = statementType.equals((Object)Meta.StatementType.UPDATE) ? preparedStatement.executeUpdate() : -1L;
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                callback.assign(handle.signature, null, updateCount);
            }
            callback.execute();
            Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(handle.connectionId, handle.id, false, handle.signature, null);
            return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
        }
        catch (SQLTimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new NoSuchStatementException(handle);
        }
    }

    @Override
    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle statementHandle, List<String> queries) throws NoSuchStatementException {
        return null;
    }

    @Override
    public void rollback(Meta.ConnectionHandle connectionHandle) {
    }

    @Override
    public boolean syncResults(Meta.StatementHandle statementHandle, QueryState queryState, long offset) throws NoSuchStatementException {
        return false;
    }

    void setDefaultConnectionProperties() {
        this.connProps.setDirty(false).setAutoCommit(true).setReadOnly(true).setCatalog(null).setSchema(null).setTransactionIsolation(0);
    }

    ArrowFlightSqlClientHandler.PreparedStatement getPreparedStatement(Meta.StatementHandle statementHandle) {
        return this.statementHandlePreparedStatementMap.get(new StatementHandleKey(statementHandle));
    }

    private static final class StatementHandleKey {
        public final String connectionId;
        public final int id;

        StatementHandleKey(Meta.StatementHandle statementHandle) {
            this.connectionId = statementHandle.connectionId;
            this.id = statementHandle.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatementHandleKey that = (StatementHandleKey)o;
            if (this.id != that.id) {
                return false;
            }
            return this.connectionId.equals(that.connectionId);
        }

        public int hashCode() {
            int result = this.connectionId.hashCode();
            result = 31 * result + this.id;
            return result;
        }
    }
}

