/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Choice;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERNull;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DEROctetString;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.HashedId;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.oer.its.SequenceOfCertificate;

public class SignerIdentifier
extends ASN1Object
implements ASN1Choice {
    public static final int digest = 0;
    public static final int certificate = 1;
    public static final int self = 2;
    public static final int extension = 3;
    private final int choice;
    private final ASN1Encodable object;

    public SignerIdentifier(int n, ASN1Encodable aSN1Encodable) {
        this.choice = n;
        this.object = aSN1Encodable;
    }

    public static final SignerIdentifier getInstance(Object object) {
        if (object instanceof SignerIdentifier) {
            return (SignerIdentifier)object;
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object);
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: {
                return new SignerIdentifier(aSN1TaggedObject.getTagNo(), HashedId.HashedId8.getInstance(aSN1TaggedObject.getObject()));
            }
            case 1: {
                return new SignerIdentifier(aSN1TaggedObject.getTagNo(), SequenceOfCertificate.getInstance(aSN1TaggedObject.getObject()));
            }
            case 2: {
                break;
            }
        }
        throw new IllegalArgumentException("unknown choice " + aSN1TaggedObject.getTagNo());
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.object);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getObject() {
        return this.object;
    }

    public static class Builder {
        private ASN1Encodable encodable;
        private int choice;

        public Builder setEncodable(ASN1Encodable aSN1Encodable) {
            this.encodable = aSN1Encodable;
            return this;
        }

        public Builder setChoice(int n) {
            this.choice = n;
            return this;
        }

        public Builder digest(HashedId.HashedId8 hashedId8) {
            this.choice = 0;
            this.encodable = hashedId8;
            return this;
        }

        public Builder certificate(SequenceOfCertificate sequenceOfCertificate) {
            this.choice = 1;
            this.encodable = sequenceOfCertificate;
            return this;
        }

        public Builder self() {
            this.choice = 2;
            this.encodable = DERNull.INSTANCE;
            return this;
        }

        public Builder extension(byte[] byArray) {
            this.choice = 3;
            this.encodable = new DEROctetString(byArray);
            return this;
        }

        public SignerIdentifier build() {
            return new SignerIdentifier(this.choice, this.encodable);
        }
    }
}

