/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

