/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.rounding;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.CommonUtil;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class DefaultRoundingPolicy
implements RoundingPolicy {
    private static final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(DefaultRoundingPolicy.class);
    public final @UnknownKeyFor @NonNull @Initialized long chunkSize;
    private static final @UnknownKeyFor @NonNull @Initialized int MIN_PAGE_SIZE = 4096;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_CHUNK_SIZE = 0x40000000;
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_CHUNK_SIZE;
    public static final @UnknownKeyFor @NonNull @Initialized DefaultRoundingPolicy DEFAULT_ROUNDING_POLICY;

    private static @UnknownKeyFor @NonNull @Initialized int validateAndCalculatePageShifts(@UnknownKeyFor @NonNull @Initialized int pageSize) {
        if (pageSize < 4096) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: " + 4096 + ")");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(pageSize);
    }

    private static @UnknownKeyFor @NonNull @Initialized int validateAndCalculateChunkSize(@UnknownKeyFor @NonNull @Initialized int pageSize, @UnknownKeyFor @NonNull @Initialized int maxOrder) {
        if (maxOrder > 14) {
            throw new IllegalArgumentException("maxOrder: " + maxOrder + " (expected: 0-14)");
        }
        int chunkSize = pageSize;
        for (int i = maxOrder; i > 0; --i) {
            if (chunkSize > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", pageSize, maxOrder, 0x40000000));
            }
            chunkSize <<= 1;
        }
        return chunkSize;
    }

    private DefaultRoundingPolicy(@UnknownKeyFor @NonNull @Initialized long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getRoundedSize(@UnknownKeyFor @NonNull @Initialized long requestSize) {
        return requestSize < this.chunkSize ? CommonUtil.nextPowerOfTwo(requestSize) : requestSize;
    }

    static {
        int defaultPageSize = Integer.getInteger("org.apache.arrow.driver.jdbc.shaded.org.apache.memory.allocator.pageSize", 8192);
        Throwable pageSizeFallbackCause = null;
        try {
            DefaultRoundingPolicy.validateAndCalculatePageShifts(defaultPageSize);
        }
        catch (Throwable t) {
            pageSizeFallbackCause = t;
            defaultPageSize = 8192;
        }
        int defaultMaxOrder = Integer.getInteger("org.apache.arrow.driver.jdbc.shaded.org.apache.memory.allocator.maxOrder", 11);
        Throwable maxOrderFallbackCause = null;
        try {
            DefaultRoundingPolicy.validateAndCalculateChunkSize(defaultPageSize, defaultMaxOrder);
        }
        catch (Throwable t) {
            maxOrderFallbackCause = t;
            defaultMaxOrder = 11;
        }
        DEFAULT_CHUNK_SIZE = DefaultRoundingPolicy.validateAndCalculateChunkSize(defaultPageSize, defaultMaxOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dorg.apache.memory.allocator.pageSize: {}", (Object)defaultPageSize);
            logger.debug("-Dorg.apache.memory.allocator.maxOrder: {}", (Object)defaultMaxOrder);
        }
        DEFAULT_ROUNDING_POLICY = new DefaultRoundingPolicy(DEFAULT_CHUNK_SIZE);
    }
}

