/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory;

import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class BoundsChecking {
    public static final @UnknownKeyFor @NonNull @Initialized boolean BOUNDS_CHECKING_ENABLED;
    static final @UnknownKeyFor @NonNull @Initialized Logger logger;

    private BoundsChecking() {
    }

    static {
        String newProperty;
        String unsafeFlagValue;
        logger = LoggerFactory.getLogger(BoundsChecking.class);
        String envProperty = System.getenv("ARROW_ENABLE_UNSAFE_MEMORY_ACCESS");
        String oldProperty = System.getProperty("drill.enable_unsafe_memory_access");
        if (oldProperty != null) {
            logger.warn("\"drill.enable_unsafe_memory_access\" has been renamed to \"arrow.enable_unsafe_memory_access\"");
            logger.warn("\"arrow.enable_unsafe_memory_access\" can be set to:  true (to not check) or false (to check, default)");
        }
        if ((unsafeFlagValue = (newProperty = System.getProperty("arrow.enable_unsafe_memory_access"))) == null) {
            unsafeFlagValue = oldProperty;
        }
        if (unsafeFlagValue == null) {
            unsafeFlagValue = envProperty;
        }
        BOUNDS_CHECKING_ENABLED = !"true".equals(unsafeFlagValue);
    }
}

