/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.AllocationOutcome;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.AllocationOutcomeDetails;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.arrow.driver.jdbc.shaded.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@ThreadSafe
class Accountant
implements AutoCloseable {
    protected final @Nullable @UnknownKeyFor @Initialized Accountant parent;
    private final @UnknownKeyFor @NonNull @Initialized String name;
    protected final @UnknownKeyFor @NonNull @Initialized long reservation;
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong peakAllocation = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong allocationLimit = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong locallyHeldMemory = new AtomicLong();

    public Accountant(@Nullable @UnknownKeyFor @Initialized Accountant parent, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized long reservation, @UnknownKeyFor @NonNull @Initialized long maxAllocation) {
        Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkArgument(reservation >= 0L, "The initial reservation size must be non-negative.");
        Preconditions.checkArgument(maxAllocation >= 0L, "The maximum allocation limit must be non-negative.");
        Preconditions.checkArgument(reservation <= maxAllocation, "The initial reservation size must be <= the maximum allocation.");
        Preconditions.checkArgument(reservation == 0L || parent != null, "The root accountant can't reserve memory.");
        this.parent = parent;
        this.name = name;
        this.reservation = reservation;
        this.allocationLimit.set(maxAllocation);
        if (reservation != 0L) {
            Preconditions.checkArgument(parent != null, "parent must not be null");
            AllocationOutcome outcome = parent.allocateBytes(reservation);
            if (!outcome.isOk()) {
                throw new OutOfMemoryException(String.format("Failure trying to allocate initial reservation for Allocator. Attempted to allocate %d bytes.", reservation), outcome.getDetails());
            }
        }
    }

    @UnknownKeyFor @NonNull @Initialized AllocationOutcome allocateBytes(@UnknownKeyFor @NonNull @Initialized long size) {
        AllocationOutcome.Status status = this.allocateBytesInternal(size);
        if (status.isOk()) {
            return AllocationOutcome.SUCCESS_INSTANCE;
        }
        AllocationOutcomeDetails details = new AllocationOutcomeDetails();
        status = this.allocateBytesInternal(size, details);
        return new AllocationOutcome(status, details);
    }

    private @UnknownKeyFor @NonNull @Initialized AllocationOutcome.Status allocateBytesInternal(@UnknownKeyFor @NonNull @Initialized long size, @Nullable @UnknownKeyFor @Initialized AllocationOutcomeDetails details) {
        AllocationOutcome.Status status = this.allocate(size, true, false, details);
        if (!status.isOk()) {
            this.releaseBytes(size);
        }
        return status;
    }

    private @UnknownKeyFor @NonNull @Initialized AllocationOutcome.Status allocateBytesInternal(@UnknownKeyFor @NonNull @Initialized long size) {
        return this.allocateBytesInternal(size, null);
    }

    private void updatePeak() {
        long previousPeak;
        long currentMemory = this.locallyHeldMemory.get();
        while (currentMemory > (previousPeak = this.peakAllocation.get()) && !this.peakAllocation.compareAndSet(previousPeak, currentMemory)) {
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean forceAllocate(@UnknownKeyFor @NonNull @Initialized long size) {
        AllocationOutcome.Status outcome = this.allocate(size, true, true, null);
        return outcome.isOk();
    }

    private @UnknownKeyFor @NonNull @Initialized AllocationOutcome.Status allocate(@UnknownKeyFor @NonNull @Initialized long size, @UnknownKeyFor @NonNull @Initialized boolean incomingUpdatePeak, @UnknownKeyFor @NonNull @Initialized boolean forceAllocation, @Nullable @UnknownKeyFor @Initialized AllocationOutcomeDetails details) {
        AllocationOutcome.Status finalOutcome;
        boolean updatePeak;
        long newLocal;
        long oldLocal = this.locallyHeldMemory.getAndAdd(size);
        boolean overflow = ((oldLocal ^ (newLocal = oldLocal + size)) & (size ^ newLocal)) < 0L;
        long beyondReservation = newLocal - this.reservation;
        boolean beyondLimit = overflow || newLocal > this.allocationLimit.get();
        boolean bl = updatePeak = forceAllocation || incomingUpdatePeak && !beyondLimit;
        if (details != null) {
            boolean allocationFailed = true;
            long allocatedLocal = 0L;
            if (!beyondLimit) {
                allocatedLocal = size - Math.min(beyondReservation, size);
                allocationFailed = false;
            }
            details.pushEntry(this, newLocal - size, size, allocatedLocal, allocationFailed);
        }
        AllocationOutcome.Status parentOutcome = AllocationOutcome.Status.SUCCESS;
        if (beyondReservation > 0L && this.parent != null) {
            long parentRequest = Math.min(beyondReservation, size);
            parentOutcome = this.parent.allocate(parentRequest, updatePeak, forceAllocation, details);
        }
        if (beyondLimit) {
            finalOutcome = AllocationOutcome.Status.FAILED_LOCAL;
        } else {
            AllocationOutcome.Status status = finalOutcome = parentOutcome.isOk() ? AllocationOutcome.Status.SUCCESS : AllocationOutcome.Status.FAILED_PARENT;
        }
        if (updatePeak) {
            this.updatePeak();
        }
        return finalOutcome;
    }

    public void releaseBytes(@UnknownKeyFor @NonNull @Initialized long size) {
        long newSize = this.locallyHeldMemory.addAndGet(-size);
        Preconditions.checkArgument(newSize >= 0L, "Accounted size went negative.");
        long originalSize = newSize + size;
        if (originalSize > this.reservation && this.parent != null) {
            long possibleAmountToReleaseToParent = originalSize - this.reservation;
            long actualToReleaseToParent = Math.min(size, possibleAmountToReleaseToParent);
            this.parent.releaseBytes(actualToReleaseToParent);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isOverLimit() {
        return this.getAllocatedMemory() > this.getLimit() || this.parent != null && this.parent.isOverLimit();
    }

    @Override
    public void close() {
        if (this.parent != null) {
            this.parent.releaseBytes(this.reservation);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized long getLimit() {
        return this.allocationLimit.get();
    }

    public @UnknownKeyFor @NonNull @Initialized long getInitReservation() {
        return this.reservation;
    }

    public void setLimit(@UnknownKeyFor @NonNull @Initialized long newLimit) {
        this.allocationLimit.set(newLimit);
    }

    public @UnknownKeyFor @NonNull @Initialized long getAllocatedMemory() {
        return this.locallyHeldMemory.get();
    }

    public @UnknownKeyFor @NonNull @Initialized long getPeakMemoryAllocation() {
        return this.peakAllocation.get();
    }

    public @UnknownKeyFor @NonNull @Initialized long getHeadroom() {
        long localHeadroom = this.allocationLimit.get() - this.locallyHeldMemory.get();
        if (this.parent == null) {
            return localHeadroom;
        }
        long reservedHeadroom = Math.max(0L, this.reservation - this.locallyHeldMemory.get());
        return Math.min(localHeadroom, this.parent.getHeadroom() + reservedHeadroom);
    }
}

