/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlScenarioProducer
implements FlightSqlProducer {
    private final BufferAllocator allocator;

    public FlightSqlScenarioProducer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    static Schema getQuerySchema() {
        return new Schema(Collections.singletonList(new Field("id", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null, new FlightSqlColumnMetadata.Builder().tableName("test").isAutoIncrement(true).isCaseSensitive(false).typeName("type_test").schemaName("schema_test").isSearchable(true).catalogName("catalog_test").precision(100).build().getMetadataMap()), null)));
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        IntegrationAssertions.assertTrue("Expect to be one of the two queries used on tests", request.getQuery().equals("SELECT PREPARED STATEMENT") || request.getQuery().equals("UPDATE PREPARED STATEMENT"));
        FlightSql.ActionCreatePreparedStatementResult result = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(ByteString.copyFromUtf8((String)(request.getQuery() + " HANDLE"))).build();
        listener.onNext((Object)new Result(Any.pack((Message)result).toByteArray()));
        listener.onCompleted();
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        IntegrationAssertions.assertTrue("Expect to be one of the two queries used on tests", request.getPreparedStatementHandle().toStringUtf8().equals("SELECT PREPARED STATEMENT HANDLE") || request.getPreparedStatementHandle().toStringUtf8().equals("UPDATE PREPARED STATEMENT HANDLE"));
        listener.onCompleted();
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(command.getQuery(), "SELECT STATEMENT");
        ByteString handle = ByteString.copyFromUtf8((String)"SELECT STATEMENT HANDLE");
        FlightSql.TicketStatementQuery ticket = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(handle).build();
        return this.getFlightInfoForSchema(ticket, descriptor, FlightSqlScenarioProducer.getQuerySchema());
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(command.getPreparedStatementHandle().toStringUtf8(), "SELECT PREPARED STATEMENT HANDLE");
        return this.getFlightInfoForSchema(command, descriptor, FlightSqlScenarioProducer.getQuerySchema());
    }

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return new SchemaResult(FlightSqlScenarioProducer.getQuerySchema());
    }

    public void getStreamStatement(FlightSql.TicketStatementQuery ticket, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQuerySchema());
    }

    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlScenarioProducer.getQuerySchema());
    }

    private Runnable acceptPutReturnConstant(FlightProducer.StreamListener<PutResult> ackStream, long value) {
        return () -> {
            FlightSql.DoPutUpdateResult build = FlightSql.DoPutUpdateResult.newBuilder().setRecordCount(value).build();
            ArrowBuf buffer = this.allocator.buffer((long)build.getSerializedSize());
            Throwable throwable = null;
            try {
                buffer.writeBytes(build.toByteArray());
                ackStream.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                ackStream.onCompleted();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (buffer != null) {
                    FlightSqlScenarioProducer.$closeResource(throwable, (AutoCloseable)buffer);
                }
            }
        };
    }

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(command.getQuery(), "UPDATE STATEMENT");
        return this.acceptPutReturnConstant(ackStream, 10000L);
    }

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(command.getPreparedStatementHandle().toStringUtf8(), "UPDATE PREPARED STATEMENT HANDLE");
        return this.acceptPutReturnConstant(ackStream, 20000L);
    }

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        IntegrationAssertions.assertEquals(command.getPreparedStatementHandle().toStringUtf8(), "SELECT PREPARED STATEMENT HANDLE");
        IntegrationAssertions.assertEquals(FlightSqlScenarioProducer.getQuerySchema(), flightStream.getSchema());
        return () -> ackStream.onCompleted();
    }

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getInfoCount(), 2);
        IntegrationAssertions.assertEquals(request.getInfo(0), 0);
        IntegrationAssertions.assertEquals(request.getInfo(1), 3);
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA);
    }

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA);
    }

    public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA);
    }

    public FlightInfo getFlightInfoTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA);
    }

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA);
    }

    private void putEmptyBatchToStreamListener(FlightProducer.ServerStreamListener stream, Schema schema) {
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            stream.start(root);
            stream.putNext();
            stream.completed();
        }
    }

    public void getStreamCatalogs(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA);
    }

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchemaFilterPattern(), "db_schema_filter_pattern");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA);
    }

    public void getStreamSchemas(FlightSql.CommandGetDbSchemas command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA);
    }

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchemaFilterPattern(), "db_schema_filter_pattern");
        IntegrationAssertions.assertEquals(request.getTableNameFilterPattern(), "table_filter_pattern");
        IntegrationAssertions.assertEquals(request.getTableTypesCount(), 2);
        IntegrationAssertions.assertEquals(request.getTableTypes(0), "table");
        IntegrationAssertions.assertEquals(request.getTableTypes(1), "view");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TABLES_SCHEMA);
    }

    public void getStreamTables(FlightSql.CommandGetTables command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TABLES_SCHEMA);
    }

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA);
    }

    public void getStreamTableTypes(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA);
    }

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA);
    }

    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getCatalog(), "catalog");
        IntegrationAssertions.assertEquals(request.getDbSchema(), "db_schema");
        IntegrationAssertions.assertEquals(request.getTable(), "table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA);
    }

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        IntegrationAssertions.assertEquals(request.getPkCatalog(), "pk_catalog");
        IntegrationAssertions.assertEquals(request.getPkDbSchema(), "pk_db_schema");
        IntegrationAssertions.assertEquals(request.getPkTable(), "pk_table");
        IntegrationAssertions.assertEquals(request.getFkCatalog(), "fk_catalog");
        IntegrationAssertions.assertEquals(request.getFkDbSchema(), "fk_db_schema");
        IntegrationAssertions.assertEquals(request.getFkTable(), "fk_table");
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA);
    }

    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA);
    }

    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA);
    }

    public void getStreamCrossReference(FlightSql.CommandGetCrossReference command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.putEmptyBatchToStreamListener(listener, FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA);
    }

    public void close() throws Exception {
    }

    public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
    }

    private <T extends Message> FlightInfo getFlightInfoForSchema(T request, FlightDescriptor descriptor, Schema schema) {
        Ticket ticket = new Ticket(Any.pack(request).toByteArray());
        List<FlightEndpoint> endpoints = Collections.singletonList(new FlightEndpoint(ticket, new Location[0]));
        return new FlightInfo(schema, descriptor, endpoints, -1L, -1L);
    }
}

