/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.Arrays;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.integration.tests.FlightSqlScenarioProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlScenario
implements Scenario {
    public static final long UPDATE_STATEMENT_EXPECTED_ROWS = 10000L;
    public static final long UPDATE_PREPARED_STATEMENT_EXPECTED_ROWS = 20000L;

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new FlightSqlScenarioProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightSqlClient sqlClient = new FlightSqlClient(client);
        this.validateMetadataRetrieval(sqlClient);
        this.validateStatementExecution(sqlClient);
        this.validatePreparedStatementExecution(sqlClient, allocator);
    }

    private void validateMetadataRetrieval(FlightSqlClient sqlClient) throws Exception {
        CallOption[] options = new CallOption[]{};
        this.validate(FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, sqlClient.getCatalogs(options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, sqlClient.getSchemas("catalog", "db_schema_filter_pattern", options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_TABLES_SCHEMA, sqlClient.getTables("catalog", "db_schema_filter_pattern", "table_filter_pattern", Arrays.asList("table", "view"), true, options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, sqlClient.getTableTypes(options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, sqlClient.getPrimaryKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA, sqlClient.getExportedKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, sqlClient.getImportedKeys(TableRef.of((String)"catalog", (String)"db_schema", (String)"table"), options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA, sqlClient.getCrossReference(TableRef.of((String)"pk_catalog", (String)"pk_db_schema", (String)"pk_table"), TableRef.of((String)"fk_catalog", (String)"fk_db_schema", (String)"fk_table"), options), sqlClient);
        this.validate(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, sqlClient.getSqlInfo(new FlightSql.SqlInfo[]{FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_READ_ONLY}, options), sqlClient);
    }

    private void validateStatementExecution(FlightSqlClient sqlClient) throws Exception {
        CallOption[] options = new CallOption[]{};
        this.validate(FlightSqlScenarioProducer.getQuerySchema(), sqlClient.execute("SELECT STATEMENT", options), sqlClient);
        IntegrationAssertions.assertEquals(sqlClient.executeUpdate("UPDATE STATEMENT", options), 10000L);
    }

    private void validatePreparedStatementExecution(FlightSqlClient sqlClient, BufferAllocator allocator) throws Exception {
        CallOption[] options = new CallOption[]{};
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT PREPARED STATEMENT", new CallOption[0]);
             VectorSchemaRoot parameters = VectorSchemaRoot.create((Schema)FlightSqlScenarioProducer.getQuerySchema(), (BufferAllocator)allocator);){
            parameters.setRowCount(1);
            preparedStatement.setParameters(parameters);
            this.validate(FlightSqlScenarioProducer.getQuerySchema(), preparedStatement.execute(options), sqlClient);
        }
        preparedStatement = sqlClient.prepare("UPDATE PREPARED STATEMENT", new CallOption[0]);
        var5_5 = null;
        try {
            IntegrationAssertions.assertEquals(preparedStatement.executeUpdate(options), 20000L);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                FlightSqlScenario.$closeResource(var5_5, (AutoCloseable)preparedStatement);
            }
        }
    }

    private void validate(Schema expectedSchema, FlightInfo flightInfo, FlightSqlClient sqlClient) throws Exception {
        Ticket ticket = ((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket();
        try (FlightStream stream = sqlClient.getStream(ticket, new CallOption[0]);){
            Schema actualSchema = stream.getSchema();
            IntegrationAssertions.assertEquals(expectedSchema, actualSchema);
        }
    }
}

