/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.integration.tests.FlightSqlScenario;
import org.apache.arrow.flight.integration.tests.FlightSqlScenarioProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlIngestionScenario
extends FlightSqlScenario {
    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        FlightSqlScenarioProducer producer = (FlightSqlScenarioProducer)super.producer(allocator, location);
        producer.getSqlInfoBuilder().withFlightSqlServerBulkIngestionTransaction(true).withFlightSqlServerBulkIngestion(true);
        return producer;
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        try (FlightSqlClient sqlClient = new FlightSqlClient(client);){
            this.validateMetadataRetrieval(sqlClient);
            this.validateIngestion(allocator, sqlClient);
        }
    }

    private void validateMetadataRetrieval(FlightSqlClient sqlClient) throws Exception {
        this.validate(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, sqlClient.getSqlInfo(new FlightSql.SqlInfo[]{FlightSql.SqlInfo.FLIGHT_SQL_SERVER_INGEST_TRANSACTIONS_SUPPORTED, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_BULK_INGESTION}), sqlClient, s -> {
            Map<Integer, Object> infoValues = this.readSqlInfoStream((FlightStream)s);
            IntegrationAssertions.assertEquals(Boolean.TRUE, infoValues.get(11));
            IntegrationAssertions.assertEquals(Boolean.TRUE, infoValues.get(10));
        });
    }

    private VectorSchemaRoot getIngestVectorRoot(BufferAllocator allocator) {
        Schema schema = FlightSqlScenarioProducer.getIngestSchema();
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
        root.setRowCount(3);
        return root;
    }

    private void validateIngestion(BufferAllocator allocator, FlightSqlClient sqlClient) {
        try (VectorSchemaRoot data = this.getIngestVectorRoot(allocator);){
            FlightSql.CommandStatementIngest.TableDefinitionOptions tableDefinitionOptions = FlightSql.CommandStatementIngest.TableDefinitionOptions.newBuilder().setIfExists(FlightSql.CommandStatementIngest.TableDefinitionOptions.TableExistsOption.TABLE_EXISTS_OPTION_REPLACE).setIfNotExist(FlightSql.CommandStatementIngest.TableDefinitionOptions.TableNotExistOption.TABLE_NOT_EXIST_OPTION_CREATE).build();
            HashMap options = new HashMap(ImmutableMap.of((Object)"key1", (Object)"val1", (Object)"key2", (Object)"val2"));
            FlightSqlClient.ExecuteIngestOptions executeIngestOptions = new FlightSqlClient.ExecuteIngestOptions("test_table", tableDefinitionOptions, true, "test_catalog", "test_schema", options);
            FlightSqlClient.Transaction transaction = new FlightSqlClient.Transaction(BULK_INGEST_TRANSACTION_ID);
            long updatedRows = sqlClient.executeIngest(data, executeIngestOptions, transaction, new CallOption[0]);
            IntegrationAssertions.assertEquals(3L, updatedRows);
        }
    }
}

