/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightRuntimeException;

final class IntegrationAssertions {
    IntegrationAssertions() {
    }

    static <T extends Throwable> T assertThrows(Class<T> clazz, AssertThrows body) {
        try {
            body.run();
        }
        catch (Throwable t) {
            if (clazz.isInstance(t)) {
                return (T)t;
            }
            throw new AssertionError("Expected exception of class " + String.valueOf(clazz) + " but got " + String.valueOf(t.getClass()), t);
        }
        throw new AssertionError((Object)("Expected exception of class " + String.valueOf(clazz) + " but did not throw."));
    }

    static void assertEquals(Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            throw new AssertionError((Object)("Expected:\n" + String.valueOf(expected) + "\nbut got:\n" + String.valueOf(actual)));
        }
    }

    static void assertEquals(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionError((Object)String.format("Expected:\n%s\nbut got:\n%s", Arrays.toString(expected), Arrays.toString(actual)));
        }
    }

    static void assertFalse(String message, boolean value) {
        if (value) {
            throw new AssertionError((Object)("Expected false: " + message));
        }
    }

    static void assertTrue(String message, boolean value) {
        if (!value) {
            throw new AssertionError((Object)("Expected true: " + message));
        }
    }

    static void assertNull(Object actual) {
        if (actual != null) {
            throw new AssertionError((Object)("Expected: null\n\nbut got: " + String.valueOf(actual)));
        }
    }

    static void assertNotNull(Object actual) {
        if (actual == null) {
            throw new AssertionError((Object)"Expected: (not null)\n\nbut got: null\n");
        }
    }

    static FlightRuntimeException toFlightRuntimeException(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return CallStatus.UNKNOWN.withCause(t).withDescription("Unknown error: " + String.valueOf(t) + "\n. Stack trace:\n" + stringWriter.toString()).toRuntimeException();
    }

    @FunctionalInterface
    static interface AssertThrows {
        public void run() throws Throwable;
    }
}

