/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.Arrays;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.integration.tests.DoExchangeEchoScenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

final class DoExchangeProducer
extends NoOpFlightProducer {
    private final BufferAllocator allocator;

    DoExchangeProducer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public void doExchange(FlightProducer.CallContext context, FlightStream reader, FlightProducer.ServerStreamListener writer) {
        FlightDescriptor descriptor = reader.getDescriptor();
        if (descriptor.isCommand() && Arrays.equals(DoExchangeEchoScenario.COMMAND, descriptor.getCommand())) {
            this.doEcho(reader, writer);
        }
        throw CallStatus.UNIMPLEMENTED.withDescription("Unsupported descriptor: " + descriptor.toString()).toRuntimeException();
    }

    private void doEcho(FlightStream reader, FlightProducer.ServerStreamListener writer) {
        VectorSchemaRoot root = null;
        VectorLoader loader = null;
        while (reader.next()) {
            if (reader.hasRoot()) {
                if (root == null) {
                    root = VectorSchemaRoot.create((Schema)reader.getSchema(), (BufferAllocator)this.allocator);
                    loader = new VectorLoader(root);
                    writer.start(root);
                }
                VectorUnloader unloader = new VectorUnloader(reader.getRoot());
                try (ArrowRecordBatch arb = unloader.getRecordBatch();){
                    loader.load(arb);
                }
                if (reader.getLatestMetadata() != null) {
                    reader.getLatestMetadata().getReferenceManager().retain();
                    writer.putNext(reader.getLatestMetadata());
                    continue;
                }
                writer.putNext();
                continue;
            }
            reader.getLatestMetadata().getReferenceManager().retain();
            writer.putMetadata(reader.getLatestMetadata());
        }
        if (root != null) {
            root.close();
        }
        writer.completed();
    }
}

