/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.integration.tests.DoExchangeProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;

final class DoExchangeEchoScenario
implements Scenario {
    public static final byte[] COMMAND = "echo".getBytes(StandardCharsets.UTF_8);

    DoExchangeEchoScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new DoExchangeProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        Schema schema = new Schema(Collections.singletonList(Field.notNullable((String)"x", (ArrowType)new ArrowType.Int(32, true))));
        try (FlightClient.ExchangeReaderWriter stream = client.doExchange(FlightDescriptor.command((byte[])COMMAND), new CallOption[0]);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);){
            FlightStream reader = stream.getReader();
            IntVector iv = (IntVector)root.getVector("x");
            iv.allocateNew();
            stream.getWriter().start(root);
            int rowCount = 10;
            for (int batchIdx = 0; batchIdx < 4; ++batchIdx) {
                for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
                    iv.setSafe(rowIdx, batchIdx + rowIdx);
                }
                root.setRowCount(rowCount);
                boolean writeMetadata = batchIdx % 2 == 0;
                byte[] rawMetadata = Integer.toString(batchIdx).getBytes(StandardCharsets.UTF_8);
                if (writeMetadata) {
                    ArrowBuf metadata = allocator.buffer((long)rawMetadata.length);
                    metadata.writeBytes(rawMetadata);
                    stream.getWriter().putNext(metadata);
                } else {
                    stream.getWriter().putNext();
                }
                IntegrationAssertions.assertTrue("Unexpected end of reader", reader.next());
                if (writeMetadata) {
                    IntegrationAssertions.assertNotNull(reader.getLatestMetadata());
                    byte[] readMetadata = new byte[rawMetadata.length];
                    reader.getLatestMetadata().readBytes(readMetadata);
                    IntegrationAssertions.assertEquals(rawMetadata, readMetadata);
                } else {
                    IntegrationAssertions.assertNull(reader.getLatestMetadata());
                }
                IntegrationAssertions.assertEquals(root.getSchema(), reader.getSchema());
                Validator.compareVectorSchemaRoot((VectorSchemaRoot)reader.getRoot(), (VectorSchemaRoot)root);
            }
            stream.getWriter().completed();
            IntegrationAssertions.assertFalse("Expected to reach end of reader", reader.next());
        }
    }
}

