/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.CancelFlightInfoResult;
import org.apache.arrow.flight.CancelStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.integration.tests.ExpirationTimeProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;

final class ExpirationTimeCancelFlightInfoScenario
implements Scenario {
    ExpirationTimeCancelFlightInfoScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new ExpirationTimeProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])"expiration".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
        CancelFlightInfoRequest request = new CancelFlightInfoRequest(info);
        CancelFlightInfoResult result = client.cancelFlightInfo(request, new CallOption[0]);
        IntegrationAssertions.assertEquals(CancelStatus.CANCELLED, result.getStatus());
        for (FlightEndpoint endpoint : info.getEndpoints()) {
            IntegrationAssertions.assertThrows(FlightRuntimeException.class, () -> {
                try (FlightStream stream = client.getStream(endpoint.getTicket(), new CallOption[0]);){
                    while (stream.next()) {
                    }
                }
            });
        }
    }
}

