/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.integration.tests.ExpirationTimeProducer;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

final class ExpirationTimeDoGetScenario
implements Scenario {
    ExpirationTimeDoGetScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new ExpirationTimeProducer(allocator);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        FlightInfo info = client.getInfo(FlightDescriptor.command((byte[])"expiration_time".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try {
            for (FlightEndpoint endpoint : info.getEndpoints()) {
                if (batches.size() == 0) {
                    IntegrationAssertions.assertFalse("endpoints[0] must not have expiration time", endpoint.getExpirationTime().isPresent());
                } else {
                    IntegrationAssertions.assertTrue("endpoints[" + batches.size() + "] must have expiration time", endpoint.getExpirationTime().isPresent());
                }
                FlightStream stream = client.getStream(endpoint.getTicket(), new CallOption[0]);
                Throwable throwable = null;
                try {
                    while (stream.next()) {
                        batches.add(new VectorUnloader(stream.getRoot()).getRecordBatch());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    ExpirationTimeDoGetScenario.$closeResource(throwable, (AutoCloseable)stream);
                }
            }
            IntegrationAssertions.assertEquals(3, batches.size());
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ExpirationTimeProducer.SCHEMA, (BufferAllocator)allocator);){
                VectorLoader loader = new VectorLoader(root);
                loader.load((ArrowRecordBatch)batches.get(0));
                IntegrationAssertions.assertEquals(1, root.getRowCount());
                IntegrationAssertions.assertEquals(0, ((UInt4Vector)root.getVector(0)).getObject(0));
                loader.load((ArrowRecordBatch)batches.get(1));
                IntegrationAssertions.assertEquals(1, root.getRowCount());
                IntegrationAssertions.assertEquals(1, ((UInt4Vector)root.getVector(0)).getObject(0));
                loader.load((ArrowRecordBatch)batches.get(2));
                IntegrationAssertions.assertEquals(1, root.getRowCount());
                IntegrationAssertions.assertEquals(2, ((UInt4Vector)root.getVector(0)).getObject(0));
            }
        }
        finally {
            AutoCloseables.close(batches);
        }
    }
}

