/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.validate;

import java.util.function.Supplier;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.validate.ValidateUtil;
import org.apache.arrow.vector.validate.ValidateVectorTypeVisitor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestValidateVectorTypeVisitor {
    private BufferAllocator allocator;
    private ValidateVectorTypeVisitor visitor = new ValidateVectorTypeVisitor();

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    private void testPositiveCase(Supplier<ValueVector> vectorGenerator) {
        try (ValueVector vector = vectorGenerator.get();){
            vector.accept((VectorVisitor)this.visitor, null);
        }
    }

    private void testNegativeCase(Supplier<ValueVector> vectorGenerator) {
        try (ValueVector vector = vectorGenerator.get();){
            Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> vector.accept((VectorVisitor)this.visitor, null));
        }
    }

    @Test
    public void testFixedWidthVectorsPositive() {
        this.testPositiveCase(() -> new TinyIntVector("vector", this.allocator));
        this.testPositiveCase(() -> new SmallIntVector("vector", this.allocator));
        this.testPositiveCase(() -> new IntVector("vector", this.allocator));
        this.testPositiveCase(() -> new BigIntVector("vector", this.allocator));
        this.testPositiveCase(() -> new UInt1Vector("vector", this.allocator));
        this.testPositiveCase(() -> new UInt2Vector("vector", this.allocator));
        this.testPositiveCase(() -> new UInt4Vector("vector", this.allocator));
        this.testPositiveCase(() -> new UInt8Vector("vector", this.allocator));
        this.testPositiveCase(() -> new BitVector("vector", this.allocator));
        this.testPositiveCase(() -> new DecimalVector("vector", this.allocator, 30, 16));
        this.testPositiveCase(() -> new DateDayVector("vector", this.allocator));
        this.testPositiveCase(() -> new DateMilliVector("vector", this.allocator));
        this.testPositiveCase(() -> new DurationVector("vector", FieldType.nullable((ArrowType)new ArrowType.Duration(TimeUnit.SECOND)), this.allocator));
        this.testPositiveCase(() -> new Float4Vector("vector", this.allocator));
        this.testPositiveCase(() -> new Float8Vector("vector", this.allocator));
        this.testPositiveCase(() -> new IntervalDayVector("vector", this.allocator));
        this.testPositiveCase(() -> new IntervalYearVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeMicroVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeMilliVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeMicroVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeSecVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeStampMicroTZVector("vector", this.allocator, "cn"));
        this.testPositiveCase(() -> new TimeStampMicroVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeStampMilliTZVector("vector", this.allocator, "cn"));
        this.testPositiveCase(() -> new TimeStampMilliVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeStampNanoTZVector("vector", this.allocator, "cn"));
        this.testPositiveCase(() -> new TimeStampNanoVector("vector", this.allocator));
        this.testPositiveCase(() -> new TimeStampSecTZVector("vector", this.allocator, "cn"));
        this.testPositiveCase(() -> new TimeStampSecVector("vector", this.allocator));
        this.testPositiveCase(() -> new FixedSizeBinaryVector("vector", this.allocator, 5));
    }

    @Test
    public void testFixedWidthVectorsNegative() {
        this.testNegativeCase(() -> new TinyIntVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
        this.testNegativeCase(() -> new SmallIntVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
        this.testNegativeCase(() -> new BigIntVector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new BigIntVector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new UInt1Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new UInt2Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new UInt4Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new UInt8Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.SMALLINT.getType()), this.allocator));
        this.testNegativeCase(() -> new BitVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new DecimalVector("vector", this.allocator, 30, -16));
        this.testNegativeCase(() -> new DateDayVector("vector", FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType()), this.allocator));
        this.testNegativeCase(() -> new DateMilliVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new Float4Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new Float8Vector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new IntervalDayVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
        this.testNegativeCase(() -> new IntervalYearVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeMilliVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeMicroVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeNanoVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeSecVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeStampMicroTZVector("vector", this.allocator, null));
        this.testNegativeCase(() -> new TimeStampMicroVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeStampMilliTZVector("vector", this.allocator, null));
        this.testNegativeCase(() -> new TimeStampMilliVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeStampNanoTZVector("vector", this.allocator, null));
        this.testNegativeCase(() -> new TimeStampNanoVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
        this.testNegativeCase(() -> new TimeStampSecTZVector("vector", this.allocator, null));
        this.testNegativeCase(() -> new TimeStampSecVector("vector", FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), this.allocator));
    }

    @Test
    public void testDecimalVector() {
        this.testPositiveCase(() -> new DecimalVector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)10, (int)10, (Integer)128)), this.allocator));
        this.testPositiveCase(() -> new DecimalVector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)38, (int)10, (Integer)128)), this.allocator));
        this.testPositiveCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)50, (int)10, (Integer)256)), this.allocator));
        this.testPositiveCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)76, (int)10, (Integer)256)), this.allocator));
        this.testNegativeCase(() -> new DecimalVector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)50, (int)10, (Integer)128)), this.allocator));
        this.testNegativeCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)100, (int)10, (Integer)256)), this.allocator));
        this.testNegativeCase(() -> new DecimalVector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)0, (int)10, (Integer)128)), this.allocator));
        this.testNegativeCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)-1, (int)10, (Integer)256)), this.allocator));
        this.testNegativeCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)30, (int)10, (Integer)64)), this.allocator));
        this.testNegativeCase(() -> new Decimal256Vector("dec", FieldType.nullable((ArrowType)ArrowType.Decimal.createDecimal((int)10, (int)20, (Integer)256)), this.allocator));
    }

    @Test
    public void testVariableWidthVectorsPositive() {
        this.testPositiveCase(() -> new VarCharVector("vector", this.allocator));
        this.testPositiveCase(() -> new VarBinaryVector("vector", this.allocator));
    }

    @Test
    public void testVariableWidthVectorsNegative() {
        this.testNegativeCase(() -> new VarCharVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
        this.testNegativeCase(() -> new VarBinaryVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
    }

    @Test
    public void testLargeVariableWidthVectorsPositive() {
        this.testPositiveCase(() -> new LargeVarCharVector("vector", this.allocator));
        this.testPositiveCase(() -> new LargeVarBinaryVector("vector", this.allocator));
    }

    @Test
    public void testLargeVariableWidthVectorsNegative() {
        this.testNegativeCase(() -> new LargeVarCharVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
        this.testNegativeCase(() -> new LargeVarBinaryVector("vector", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), this.allocator));
    }

    @Test
    public void testListVector() {
        this.testPositiveCase(() -> ListVector.empty((String)"vector", (BufferAllocator)this.allocator));
        this.testNegativeCase(() -> new ListVector("vector", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
    }

    @Test
    public void testLargeListVector() {
        this.testPositiveCase(() -> LargeListVector.empty((String)"vector", (BufferAllocator)this.allocator));
        this.testNegativeCase(() -> new LargeListVector("vector", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
    }

    @Test
    public void testFixedSizeListVector() {
        this.testPositiveCase(() -> FixedSizeListVector.empty((String)"vector", (int)10, (BufferAllocator)this.allocator));
    }

    @Test
    public void testStructVector() {
        this.testPositiveCase(() -> StructVector.empty((String)"vector", (BufferAllocator)this.allocator));
        this.testNegativeCase(() -> new StructVector("vector", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
    }

    @Test
    public void testUnionVector() {
        this.testPositiveCase(() -> UnionVector.empty((String)"vector", (BufferAllocator)this.allocator));
    }

    @Test
    public void testDenseUnionVector() {
        this.testPositiveCase(() -> DenseUnionVector.empty((String)"vector", (BufferAllocator)this.allocator));
    }

    @Test
    public void testNullVector() {
        this.testPositiveCase(() -> new NullVector("null vec"));
    }
}

