/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.validate;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.util.ValueVectorUtility;
import org.apache.arrow.vector.validate.ValidateUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestValidateVectorSchemaRoot {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testValidatePositive() {
        try (IntVector intVector = new IntVector("int vector", this.allocator);
             VarCharVector strVector = new VarCharVector("var char vector", this.allocator);){
            VectorSchemaRoot root = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{intVector, strVector});
            ValueVectorUtility.validate((VectorSchemaRoot)root);
            ValueVectorUtility.validateFull((VectorSchemaRoot)root);
            ValueVectorDataPopulator.setVector(intVector, 1, 2, 3, 4, 5);
            ValueVectorDataPopulator.setVector(strVector, "a", "b", "c", "d", "e");
            root.setRowCount(5);
            ValueVectorUtility.validate((VectorSchemaRoot)root);
            ValueVectorUtility.validateFull((VectorSchemaRoot)root);
        }
    }

    @Test
    public void testValidateNegative() {
        try (IntVector intVector = new IntVector("int vector", this.allocator);
             VarCharVector strVector = new VarCharVector("var char vector", this.allocator);){
            VectorSchemaRoot root = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{intVector, strVector});
            ValueVectorDataPopulator.setVector(intVector, 1, 2, 3, 4, 5);
            ValueVectorDataPopulator.setVector(strVector, "a", "b", "c", "d", "e");
            root.setRowCount(4);
            intVector.setValueCount(5);
            strVector.setValueCount(5);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((VectorSchemaRoot)root));
            Assert.assertTrue((boolean)e.getMessage().contains("Child vector and vector schema root have different value counts"));
            e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((VectorSchemaRoot)root));
            Assert.assertTrue((boolean)e.getMessage().contains("Child vector and vector schema root have different value counts"));
            root.setRowCount(5);
            ArrowBuf offsetBuf = strVector.getOffsetBuffer();
            offsetBuf.setInt(0L, 100);
            offsetBuf.setInt(8L, 50);
            ValueVectorUtility.validate((VectorSchemaRoot)root);
            e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validateFull((VectorSchemaRoot)root));
            Assert.assertTrue((boolean)e.getMessage().contains("The values in positions 0 and 1 of the offset buffer are decreasing"));
        }
    }
}

