/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.validate;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.ValueVectorUtility;
import org.apache.arrow.vector.validate.ValidateUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestValidateVector {
    private BufferAllocator allocator;
    private static final Charset utf8Charset = Charset.forName("UTF-8");
    private static final byte[] STR1 = "AAAAA1".getBytes(utf8Charset);
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes(utf8Charset);
    private static final byte[] STR3 = "CCCC3".getBytes(utf8Charset);

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testBaseFixedWidthVector() {
        try (IntVector vector = new IntVector("v", this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, 1, 2, 3);
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity for fixed width data buffer"));
        }
    }

    @Test
    public void testBaseVariableWidthVector() {
        try (VarCharVector vector = new VarCharVector("v", this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{STR1, STR2, STR3});
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity for data buffer"));
        }
    }

    @Test
    public void testBaseLargeVariableWidthVector() {
        try (LargeVarCharVector vector = new LargeVarCharVector("v", this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, (byte[][])new byte[][]{STR1, STR2, null, STR3});
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity for data buffer"));
        }
    }

    @Test
    public void testListVector() {
        try (ListVector vector = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, Arrays.asList(1, 2, 3), Arrays.asList(4, 5));
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataVector().setValueCount(3);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Inner vector does not contain enough elements."));
        }
    }

    @Test
    public void testLargeListVector() {
        try (LargeListVector vector = LargeListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, Arrays.asList(1, 2, 3, 4), Arrays.asList(5, 6));
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataVector().setValueCount(4);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Inner vector does not contain enough elements."));
        }
    }

    @Test
    public void testFixedSizeListVector() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"v", (int)3, (BufferAllocator)this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            ValueVectorDataPopulator.setVector(vector, Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6));
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getDataVector().setValueCount(3);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Inner vector does not contain enough elements."));
        }
    }

    @Test
    public void testStructVectorRangeEquals() {
        try (StructVector vector = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            vector.addOrGet("f0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            vector.addOrGet("f1", FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), BigIntVector.class);
            ValueVectorUtility.validate((ValueVector)vector);
            NullableStructWriter writer = vector.getWriter();
            writer.allocate();
            this.writeStructVector(writer, 1, 10L);
            this.writeStructVector(writer, 2, 20L);
            this.writeStructVector(writer, 3, 30L);
            this.writeStructVector(writer, 4, 40L);
            this.writeStructVector(writer, 5, 50L);
            writer.setValueCount(5);
            vector.getChild("f0").setValueCount(2);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Struct vector length not equal to child vector length"));
            vector.getChild("f0").setValueCount(5);
            ValueVectorUtility.validate((ValueVector)vector);
            vector.getChild("f0").getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e2 = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e2.getMessage().contains("Not enough capacity for fixed width data buffer"));
        }
    }

    @Test
    public void testUnionVector() {
        try (UnionVector vector = UnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            float4Holder.value = 1.01f;
            float4Holder.isSet = 1;
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            float8Holder.value = 2.02f;
            float8Holder.isSet = 1;
            vector.setType(0, Types.MinorType.FLOAT4);
            vector.setSafe(0, float4Holder);
            vector.setType(1, Types.MinorType.FLOAT8);
            vector.setSafe(1, float8Holder);
            vector.setValueCount(2);
            ValueVectorUtility.validate((ValueVector)vector);
            ((FieldVector)vector.getChildrenFromFields().get(0)).setValueCount(1);
            ValidateUtil.ValidateException e1 = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e1.getMessage().contains("Union vector length not equal to child vector length"));
            ((FieldVector)vector.getChildrenFromFields().get(0)).setValueCount(2);
            ValueVectorUtility.validate((ValueVector)vector);
            ((FieldVector)vector.getChildrenFromFields().get(0)).getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e2 = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e2.getMessage().contains("Not enough capacity for fixed width data buffer"));
        }
    }

    @Test
    public void testDenseUnionVector() {
        try (DenseUnionVector vector = DenseUnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            ValueVectorUtility.validate((ValueVector)vector);
            NullableFloat4Holder float4Holder = new NullableFloat4Holder();
            float4Holder.value = 1.01f;
            float4Holder.isSet = 1;
            NullableFloat8Holder float8Holder = new NullableFloat8Holder();
            float8Holder.value = 2.02f;
            float8Holder.isSet = 1;
            byte float4TypeId = vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT4.getType()));
            byte float8TypeId = vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector.setTypeId(0, float4TypeId);
            vector.setSafe(0, float4Holder);
            vector.setTypeId(1, float8TypeId);
            vector.setSafe(1, float8Holder);
            vector.setValueCount(2);
            ValueVectorUtility.validate((ValueVector)vector);
            ((FieldVector)vector.getChildrenFromFields().get(0)).getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> ValueVectorUtility.validate((ValueVector)vector));
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity for fixed width data buffer"));
        }
    }

    @Test
    public void testBaseFixedWidthVectorInstanceMethod() {
        try (IntVector vector = new IntVector("v", this.allocator);){
            vector.validate();
            ValueVectorDataPopulator.setVector(vector, 1, 2, 3);
            vector.validate();
            vector.getDataBuffer().capacity(0L);
            ValidateUtil.ValidateException e = (ValidateUtil.ValidateException)Assertions.assertThrows(ValidateUtil.ValidateException.class, () -> vector.validate());
            Assert.assertTrue((boolean)e.getMessage().contains("Not enough capacity for fixed width data buffer"));
        }
    }

    private void writeStructVector(NullableStructWriter writer, int value1, long value2) {
        writer.start();
        writer.integer("f0").writeInt(value1);
        writer.bigInt("f1").writeBigInt(value2);
        writer.end();
    }
}

