/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import junit.framework.TestCase;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.util.TestVectorAppender;
import org.apache.arrow.vector.util.VectorSchemaRootAppender;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestVectorSchemaRootAppender {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testVectorSchemaRootAppend() {
        int length1 = 5;
        int length2 = 3;
        int length3 = 2;
        try (IntVector targetChild1 = new IntVector("t1", this.allocator);
             VarCharVector targetChild2 = new VarCharVector("t2", this.allocator);
             BigIntVector targetChild3 = new BigIntVector("t3", this.allocator);
             IntVector deltaChildOne1 = new IntVector("do1", this.allocator);
             VarCharVector deltaChildOne2 = new VarCharVector("do2", this.allocator);
             BigIntVector deltaChildOne3 = new BigIntVector("do3", this.allocator);
             IntVector deltaChildTwo1 = new IntVector("dt1", this.allocator);
             VarCharVector deltaChildTwo2 = new VarCharVector("dt2", this.allocator);
             BigIntVector deltaChildTwo3 = new BigIntVector("dt3", this.allocator);){
            ValueVectorDataPopulator.setVector(targetChild1, 0, 1, null, 3, 4);
            ValueVectorDataPopulator.setVector(targetChild2, "zero", "one", null, "three", "four");
            ValueVectorDataPopulator.setVector(targetChild3, 0L, 10L, null, 30L, 40L);
            VectorSchemaRoot root1 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{targetChild1, targetChild2, targetChild3});
            root1.setRowCount(5);
            ValueVectorDataPopulator.setVector(deltaChildOne1, 5, 6, 7);
            ValueVectorDataPopulator.setVector(deltaChildOne2, "five", "six", "seven");
            ValueVectorDataPopulator.setVector(deltaChildOne3, 50L, 60L, 70L);
            VectorSchemaRoot root2 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{deltaChildOne1, deltaChildOne2, deltaChildOne3});
            root2.setRowCount(3);
            ValueVectorDataPopulator.setVector(deltaChildTwo1, null, 9);
            ValueVectorDataPopulator.setVector(deltaChildTwo2, null, "nine");
            ValueVectorDataPopulator.setVector(deltaChildTwo3, null, 90L);
            VectorSchemaRoot root3 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{deltaChildTwo1, deltaChildTwo2, deltaChildTwo3});
            root3.setRowCount(2);
            VectorSchemaRootAppender.append((VectorSchemaRoot)root1, (VectorSchemaRoot[])new VectorSchemaRoot[]{root2, root3});
            TestCase.assertEquals((int)10, (int)root1.getRowCount());
            TestCase.assertEquals((int)3, (int)root1.getFieldVectors().size());
            try (IntVector expected1 = new IntVector("", this.allocator);
                 VarCharVector expected2 = new VarCharVector("", this.allocator);
                 BigIntVector expected3 = new BigIntVector("", this.allocator);){
                ValueVectorDataPopulator.setVector(expected1, 0, 1, null, 3, 4, 5, 6, 7, null, 9);
                ValueVectorDataPopulator.setVector(expected2, "zero", "one", null, "three", "four", "five", "six", "seven", null, "nine");
                ValueVectorDataPopulator.setVector(expected3, 0L, 10L, null, 30L, 40L, 50L, 60L, 70L, null, 90L);
                TestVectorAppender.assertVectorsEqual((ValueVector)expected1, (ValueVector)root1.getVector(0));
                TestVectorAppender.assertVectorsEqual((ValueVector)expected2, (ValueVector)root1.getVector(1));
                TestVectorAppender.assertVectorsEqual((ValueVector)expected3, (ValueVector)root1.getVector(2));
            }
        }
    }

    @Test
    public void testRootWithDifferentChildCounts() {
        try (IntVector targetChild1 = new IntVector("t1", this.allocator);
             VarCharVector targetChild2 = new VarCharVector("t2", this.allocator);
             BigIntVector targetChild3 = new BigIntVector("t3", this.allocator);
             IntVector deltaChild1 = new IntVector("d1", this.allocator);
             VarCharVector deltaChild2 = new VarCharVector("d2", this.allocator);){
            ValueVectorDataPopulator.setVector(targetChild1, 0, 1, null, 3, 4);
            ValueVectorDataPopulator.setVector(targetChild2, "zero", "one", null, "three", "four");
            ValueVectorDataPopulator.setVector(targetChild3, 0L, 10L, null, 30L, 40L);
            VectorSchemaRoot root1 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{targetChild1, targetChild2, targetChild3});
            root1.setRowCount(5);
            ValueVectorDataPopulator.setVector(deltaChild1, 5, 6, 7);
            ValueVectorDataPopulator.setVector(deltaChild2, "five", "six", "seven");
            VectorSchemaRoot root2 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{deltaChild1, deltaChild2});
            root2.setRowCount(3);
            IllegalArgumentException exp = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> VectorSchemaRootAppender.append((VectorSchemaRoot)root1, (VectorSchemaRoot[])new VectorSchemaRoot[]{root2}));
            TestCase.assertEquals((String)"Vector schema roots have different numbers of child vectors.", (String)exp.getMessage());
        }
    }

    @Test
    public void testRootWithDifferentChildTypes() {
        try (IntVector targetChild1 = new IntVector("t1", this.allocator);
             VarCharVector targetChild2 = new VarCharVector("t2", this.allocator);
             IntVector deltaChild1 = new IntVector("d1", this.allocator);
             VarCharVector deltaChild2 = new VarCharVector("d2", this.allocator);){
            ValueVectorDataPopulator.setVector(targetChild1, 0, 1, null, 3, 4);
            ValueVectorDataPopulator.setVector(targetChild2, "zero", "one", null, "three", "four");
            VectorSchemaRoot root1 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{targetChild1, targetChild2});
            root1.setRowCount(5);
            ValueVectorDataPopulator.setVector(deltaChild1, 5, 6, 7);
            ValueVectorDataPopulator.setVector(deltaChild2, "five", "six", "seven");
            VectorSchemaRoot root2 = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{deltaChild2, deltaChild1});
            root2.setRowCount(3);
            IllegalArgumentException exp = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> VectorSchemaRootAppender.append((VectorSchemaRoot)root1, (VectorSchemaRoot[])new VectorSchemaRoot[]{root2}));
            TestCase.assertEquals((String)"Vector schema roots have different schemas.", (String)exp.getMessage());
        }
    }
}

