/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.table;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.GenerateSampleData;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalMonthDayNanoVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class TestUtils {
    public static final String INT_VECTOR_NAME = "intCol";
    public static final String INT_VECTOR_NAME_1 = "intCol1";
    public static final String VARCHAR_VECTOR_NAME_1 = "varcharCol1";
    public static final String VARBINARY_VECTOR_NAME_1 = "varbinaryCol1";
    public static final String FIXEDBINARY_VECTOR_NAME_1 = "varbinaryCol1";
    public static final String INT_VECTOR_NAME_2 = "intCol2";
    public static final String INT_LIST_VECTOR_NAME = "int list vector";
    public static final String BIGINT_INT_MAP_VECTOR_NAME = "bigint-int map vector";
    public static final String STRUCT_VECTOR_NAME = "struct_vector";
    public static final String UNION_VECTOR_NAME = "union_vector";

    static List<FieldVector> twoIntColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        IntVector v2 = new IntVector(INT_VECTOR_NAME_2, allocator);
        v2.allocateNew(2);
        v2.set(0, 3);
        v2.set(1, 4);
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    static List<FieldVector> intPlusVarcharColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        VarCharVector v2 = new VarCharVector(VARCHAR_VECTOR_NAME_1, allocator);
        v2.allocateNew(2);
        v2.set(0, "one".getBytes());
        v2.set(1, "two".getBytes());
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    static List<FieldVector> intPlusLargeVarcharColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        LargeVarCharVector v2 = new LargeVarCharVector(VARCHAR_VECTOR_NAME_1, allocator);
        v2.allocateNew(2);
        v2.set(0, "one".getBytes());
        v2.set(1, "two".getBytes());
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    static List<FieldVector> intPlusVarBinaryColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        VarBinaryVector v2 = new VarBinaryVector("varbinaryCol1", allocator);
        v2.allocateNew(2);
        v2.set(0, "one".getBytes());
        v2.set(1, "two".getBytes());
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    static List<FieldVector> intPlusLargeVarBinaryColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        LargeVarBinaryVector v2 = new LargeVarBinaryVector("varbinaryCol1", allocator);
        v2.allocateNew(2);
        v2.set(0, "one".getBytes());
        v2.set(1, "two".getBytes());
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    static List<FieldVector> intPlusFixedBinaryColumns(BufferAllocator allocator) {
        ArrayList<FieldVector> vectorList = new ArrayList<FieldVector>();
        IntVector v1 = TestUtils.getSimpleIntVector(allocator);
        FixedSizeBinaryVector v2 = new FixedSizeBinaryVector("varbinaryCol1", allocator, 3);
        v2.allocateNew(2);
        v2.set(0, "one".getBytes());
        v2.set(1, "two".getBytes());
        v2.setValueCount(2);
        vectorList.add((FieldVector)v1);
        vectorList.add((FieldVector)v2);
        return vectorList;
    }

    private static IntVector getSimpleIntVector(BufferAllocator allocator) {
        IntVector v1 = new IntVector(INT_VECTOR_NAME_1, allocator);
        v1.allocateNew(2);
        v1.set(0, 1);
        v1.set(1, 2);
        v1.setValueCount(2);
        return v1;
    }

    static List<FieldVector> fixedWidthVectors(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        TestUtils.numericVectors(vectors, allocator, rowCount);
        TestUtils.simpleTemporalVectors(vectors, allocator, rowCount);
        return vectors;
    }

    static List<FieldVector> numericVectors(List<FieldVector> vectors, BufferAllocator allocator, int rowCount) {
        vectors.add((FieldVector)new IntVector("int_vector", allocator));
        vectors.add((FieldVector)new BigIntVector("bigInt_vector", allocator));
        vectors.add((FieldVector)new SmallIntVector("smallInt_vector", allocator));
        vectors.add((FieldVector)new TinyIntVector("tinyInt_vector", allocator));
        vectors.add((FieldVector)new UInt1Vector("uInt1_vector", allocator));
        vectors.add((FieldVector)new UInt2Vector("uInt2_vector", allocator));
        vectors.add((FieldVector)new UInt4Vector("uInt4_vector", allocator));
        vectors.add((FieldVector)new UInt8Vector("uInt8_vector", allocator));
        vectors.add((FieldVector)new Float4Vector("float4_vector", allocator));
        vectors.add((FieldVector)new Float8Vector("float8_vector", allocator));
        vectors.forEach(vec -> GenerateSampleData.generateTestData((ValueVector)vec, (int)rowCount));
        return vectors;
    }

    static List<FieldVector> numericVectors(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        return TestUtils.numericVectors(vectors, allocator, rowCount);
    }

    static List<FieldVector> simpleTemporalVectors(List<FieldVector> vectors, BufferAllocator allocator, int rowCount) {
        vectors.add((FieldVector)new TimeSecVector("timeSec_vector", allocator));
        vectors.add((FieldVector)new TimeMilliVector("timeMilli_vector", allocator));
        vectors.add((FieldVector)new TimeMicroVector("timeMicro_vector", allocator));
        vectors.add((FieldVector)new TimeNanoVector("timeNano_vector", allocator));
        vectors.add((FieldVector)new TimeStampSecVector("timeStampSec_vector", allocator));
        vectors.add((FieldVector)new TimeStampMilliVector("timeStampMilli_vector", allocator));
        vectors.add((FieldVector)new TimeStampMicroVector("timeStampMicro_vector", allocator));
        vectors.add((FieldVector)new TimeStampNanoVector("timeStampNano_vector", allocator));
        vectors.add((FieldVector)new DateMilliVector("dateMilli_vector", allocator));
        vectors.add((FieldVector)new DateDayVector("dateDay_vector", allocator));
        vectors.forEach(vec -> GenerateSampleData.generateTestData((ValueVector)vec, (int)rowCount));
        return vectors;
    }

    static List<FieldVector> simpleTemporalVectors(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        return TestUtils.simpleTemporalVectors(vectors, allocator, rowCount);
    }

    static List<FieldVector> timezoneTemporalVectors(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        vectors.add((FieldVector)new TimeStampSecTZVector("timeStampSecTZ_vector", allocator, "UTC"));
        vectors.add((FieldVector)new TimeStampMilliTZVector("timeStampMilliTZ_vector", allocator, "UTC"));
        vectors.add((FieldVector)new TimeStampMicroTZVector("timeStampMicroTZ_vector", allocator, "UTC"));
        vectors.add((FieldVector)new TimeStampNanoTZVector("timeStampNanoTZ_vector", allocator, "UTC"));
        vectors.forEach(vec -> GenerateSampleData.generateTestData((ValueVector)vec, (int)rowCount));
        return vectors;
    }

    static List<FieldVector> intervalVectors(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        vectors.add((FieldVector)new IntervalDayVector("intervalDay_vector", allocator));
        vectors.add((FieldVector)new IntervalYearVector("intervalYear_vector", allocator));
        vectors.add((FieldVector)new IntervalMonthDayNanoVector("intervalMonthDayNano_vector", allocator));
        vectors.add((FieldVector)new DurationVector("duration_vector", new FieldType(true, (ArrowType)new ArrowType.Duration(TimeUnit.SECOND), null), allocator));
        vectors.forEach(vec -> GenerateSampleData.generateTestData((ValueVector)vec, (int)rowCount));
        return vectors;
    }

    static ListVector simpleListVector(BufferAllocator allocator) {
        int i;
        ListVector listVector = ListVector.empty((String)INT_LIST_VECTOR_NAME, (BufferAllocator)allocator);
        int innerCount = 80;
        int outerCount = 8;
        int listLength = 10;
        Types.MinorType type = Types.MinorType.INT;
        listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        listVector.allocateNew();
        IntVector dataVector = (IntVector)listVector.getDataVector();
        for (i = 0; i < 80; ++i) {
            dataVector.set(i, i);
        }
        dataVector.setValueCount(80);
        for (i = 0; i < 8; ++i) {
            BitVectorHelper.setBit((ArrowBuf)listVector.getValidityBuffer(), (long)i);
            listVector.getOffsetBuffer().setInt((long)(i * 4), i * 10);
            listVector.getOffsetBuffer().setInt((long)((i + 1) * 4), (i + 1) * 10);
        }
        listVector.setLastSet(7);
        listVector.setValueCount(8);
        return listVector;
    }

    static StructVector simpleStructVector(BufferAllocator allocator) {
        String INT_COL = "struct_int_child";
        String FLT_COL = "struct_flt_child";
        StructVector structVector = StructVector.empty((String)STRUCT_VECTOR_NAME, (BufferAllocator)allocator);
        int size = 6;
        NullableStructWriter structWriter = structVector.getWriter();
        structVector.addOrGet("struct_int_child", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
        structVector.addOrGet("struct_flt_child", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
        structVector.allocateNew();
        IntWriter intWriter = structWriter.integer("struct_int_child");
        Float8Writer float8Writer = structWriter.float8("struct_flt_child");
        for (int i = 0; i < 6; ++i) {
            structWriter.setPosition(i);
            structWriter.start();
            intWriter.writeInt(i);
            float8Writer.writeFloat8((double)i * 0.1);
            structWriter.end();
        }
        structWriter.setValueCount(6);
        return structVector;
    }

    static MapVector simpleMapVector(BufferAllocator allocator) {
        MapVector mapVector = MapVector.empty((String)BIGINT_INT_MAP_VECTOR_NAME, (BufferAllocator)allocator, (boolean)false);
        mapVector.allocateNew();
        int count = 5;
        UnionMapWriter mapWriter = mapVector.getWriter();
        for (int i = 0; i < count; ++i) {
            mapWriter.startMap();
            for (int j = 0; j < i + 1; ++j) {
                mapWriter.startEntry();
                mapWriter.key().bigInt().writeBigInt((long)j);
                mapWriter.value().integer().writeInt(j);
                mapWriter.endEntry();
            }
            mapWriter.endMap();
        }
        mapWriter.setValueCount(count);
        return mapVector;
    }

    static List<FieldVector> decimalVector(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        vectors.add((FieldVector)new DecimalVector("decimal_vector", new FieldType(true, (ArrowType)new ArrowType.Decimal(38, 10, 128), null), allocator));
        vectors.forEach(vec -> TestUtils.generateDecimalData((DecimalVector)vec, rowCount));
        return vectors;
    }

    static List<FieldVector> bitVector(BufferAllocator allocator, int rowCount) {
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        vectors.add((FieldVector)new BitVector("bit_vector", allocator));
        vectors.forEach(vec -> GenerateSampleData.generateTestData((ValueVector)vec, (int)rowCount));
        return vectors;
    }

    static UnionVector simpleUnionVector(BufferAllocator allocator) {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        UnionVector unionVector = new UnionVector(UNION_VECTOR_NAME, allocator, null, null);
        unionVector.allocateNew();
        unionVector.setType(0, Types.MinorType.UINT4);
        unionVector.setSafe(0, uInt4Holder);
        unionVector.setType(2, Types.MinorType.UINT4);
        unionVector.setSafe(2, uInt4Holder);
        unionVector.setValueCount(4);
        return unionVector;
    }

    static DenseUnionVector simpleDenseUnionVector(BufferAllocator allocator) {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        DenseUnionVector unionVector = new DenseUnionVector(UNION_VECTOR_NAME, allocator, null, null);
        unionVector.allocateNew();
        byte uint4TypeId = unionVector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.UINT4.getType()));
        unionVector.setTypeId(0, uint4TypeId);
        unionVector.setSafe(0, uInt4Holder);
        unionVector.setTypeId(2, uint4TypeId);
        unionVector.setSafe(2, uInt4Holder);
        unionVector.setValueCount(4);
        return unionVector;
    }

    private static void generateDecimalData(DecimalVector vector, int valueCount) {
        BigDecimal even = new BigDecimal("0.0543278923");
        BigDecimal odd = new BigDecimal("2.0543278923");
        for (int i = 0; i < valueCount; ++i) {
            if (i % 2 == 0) {
                vector.setSafe(i, even);
                continue;
            }
            vector.setSafe(i, odd);
        }
        vector.setValueCount(valueCount);
    }
}

