/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.BaseFileTest;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.JsonFileWriter;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJSONFile
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestJSONFile.class);

    @Test
    public void testNoBatches() throws IOException {
        Throwable throwable;
        File file = new File("target/no_batches.json");
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
                BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
                rootWriter.integer("int");
                rootWriter.uInt1("uint1");
                rootWriter.bigInt("bigInt");
                rootWriter.float4("float");
                JsonFileWriter jsonWriter = new JsonFileWriter(file, JsonFileWriter.config().pretty(true));
                jsonWriter.start(new VectorSchemaRoot(parent.getChild("root")).getSchema(), null);
                jsonWriter.close();
            }
            catch (Throwable writer) {
                throwable = writer;
                throw writer;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var3_3 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteRead() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest.json");
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeData(count, parent);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateContent(count, root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteReadComplexJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_complex.json");
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeComplexData(count, parent);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateComplexContent(count, root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteComplexJSON() throws IOException {
        File file = new File("target/mytest_write_complex.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeComplexData(count, parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateComplexContent(root.getRowCount(), root);
            this.writeJSON(file, root, null);
        }
    }

    public void writeJSON(File file, VectorSchemaRoot root, DictionaryProvider provider) throws IOException {
        JsonFileWriter writer = new JsonFileWriter(file, JsonFileWriter.config().pretty(true));
        writer.start(root.getSchema(), provider);
        writer.write(root);
        writer.close();
    }

    @Test
    public void testWriteReadUnionJSON() throws IOException {
        File file = new File("target/mytest_write_union.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeUnionData(count, parent);
            this.printVectors(parent.getChildrenFromFields());
            try (VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));){
                this.validateUnionData(count, root);
                this.writeJSON(file, root, null);
                try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
                    JsonFileReader reader = new JsonFileReader(file, readerAllocator);
                    Schema schema = reader.start();
                    LOGGER.debug("reading schema: " + schema);
                    try (VectorSchemaRoot rootFromJson = reader.read();){
                        this.validateUnionData(count, rootFromJson);
                        Validator.compareVectorSchemaRoot((VectorSchemaRoot)root, (VectorSchemaRoot)rootFromJson);
                    }
                }
            }
        }
    }

    @Test
    public void testWriteReadDateTimeJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_datetime.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeDateTimeData(count, parent);
                this.printVectors(parent.getChildrenFromFields());
                VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
                this.validateDateTimeContent(count, root);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable root) {
                throwable = root;
                throw root;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateDateTimeContent(count, root);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteReadDictionaryJSON() throws IOException {
        Object object;
        File file = new File("target/mytest_dictionary.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root = this.writeFlatDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateFlatDictionary(root, (DictionaryProvider)provider);
                this.writeJSON(file, root, (DictionaryProvider)provider);
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            object = null;
            try {
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateFlatDictionary(root, (DictionaryProvider)reader);
                }
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    TestJSONFile.$closeResource(object, (AutoCloseable)reader);
                    throw throwable2;
                }
            }
            TestJSONFile.$closeResource((Throwable)object, (AutoCloseable)reader);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadNestedDictionaryJSON() throws IOException {
        Object object;
        File file = new File("target/mytest_dict_nested.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root = this.writeNestedDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateNestedDictionary(root, (DictionaryProvider)provider);
                this.writeJSON(file, root, (DictionaryProvider)provider);
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            object = null;
            try {
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateNestedDictionary(root, (DictionaryProvider)reader);
                }
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    TestJSONFile.$closeResource(object, (AutoCloseable)reader);
                    throw throwable2;
                }
            }
            TestJSONFile.$closeResource((Throwable)object, (AutoCloseable)reader);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadDecimalJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_decimal.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeDecimalData(vectorAllocator);){
                this.printVectors(root.getFieldVectors());
                this.validateDecimalData(root);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateDecimalData(root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testSetStructLength() throws IOException {
        File file = new File("../../docs/source/format/integration_json_examples/struct.json");
        if (!file.exists()) {
            file = new File("../docs/source/format/integration_json_examples/struct.json");
        }
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
             JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                FieldVector vector = root.getVector("struct_nullable");
                Assert.assertEquals((long)7L, (long)vector.getValueCount());
            }
        }
    }

    @Test
    public void testWriteReadVarBinJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_varbin.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeVarBinaryData(count, parent);
                VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
                this.validateVarBinary(count, root);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable root) {
                throwable = root;
                throw root;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateVarBinary(count, root);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteReadMapJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_map.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeMapData(vectorAllocator);){
                this.printVectors(root.getFieldVectors());
                this.validateMapData(root);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateMapData(root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteReadNullJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_null.json");
        int valueCount = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeNullData(valueCount);){
                this.printVectors(root.getFieldVectors());
                this.validateNullData(root, valueCount);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateNullData(root, valueCount);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testRoundtripEmptyVector() throws Exception {
        List<Field> fields = Arrays.asList(Field.nullable((String)"utf8", (ArrowType)ArrowType.Utf8.INSTANCE), Field.nullable((String)"largeutf8", (ArrowType)ArrowType.LargeUtf8.INSTANCE), Field.nullable((String)"binary", (ArrowType)ArrowType.Binary.INSTANCE), Field.nullable((String)"largebinary", (ArrowType)ArrowType.LargeBinary.INSTANCE), Field.nullable((String)"fixedsizebinary", (ArrowType)new ArrowType.FixedSizeBinary(2)), Field.nullable((String)"decimal128", (ArrowType)new ArrowType.Decimal(3, 2, 128)), Field.nullable((String)"decimal128", (ArrowType)new ArrowType.Decimal(3, 2, 256)), new Field("list", FieldType.nullable((ArrowType)ArrowType.List.INSTANCE), Collections.singletonList(Field.nullable((String)"items", (ArrowType)new ArrowType.Int(32, true)))), new Field("largelist", FieldType.nullable((ArrowType)ArrowType.LargeList.INSTANCE), Collections.singletonList(Field.nullable((String)"items", (ArrowType)new ArrowType.Int(32, true)))), new Field("map", FieldType.nullable((ArrowType)new ArrowType.Map(false)), Collections.singletonList(new Field("items", FieldType.notNullable((ArrowType)ArrowType.Struct.INSTANCE), Arrays.asList(Field.notNullable((String)"keys", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"values", (ArrowType)new ArrowType.Int(32, true)))))), new Field("fixedsizelist", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), Collections.singletonList(Field.nullable((String)"items", (ArrowType)new ArrowType.Int(32, true)))), new Field("denseunion", FieldType.nullable((ArrowType)new ArrowType.Union(UnionMode.Dense, new int[]{0})), Collections.singletonList(Field.nullable((String)"items", (ArrowType)new ArrowType.Int(32, true)))), new Field("sparseunion", FieldType.nullable((ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{0})), Collections.singletonList(Field.nullable((String)"items", (ArrowType)new ArrowType.Int(32, true)))));
        for (Field field : fields) {
            Schema schema = new Schema(Collections.singletonList(field));
            VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
            Throwable throwable = null;
            try {
                Throwable throwable2;
                VectorSchemaRoot data;
                Schema readSchema2;
                Throwable throwable3;
                JsonFileWriter jsonWriter;
                Path outputPath = Files.createTempFile("arrow-", ".json", new FileAttribute[0]);
                File outputFile = outputPath.toFile();
                outputFile.deleteOnExit();
                try {
                    jsonWriter = new JsonFileWriter(outputFile, JsonFileWriter.config().pretty(true));
                    throwable3 = null;
                    try {
                        jsonWriter.start(schema, null);
                        jsonWriter.write(root);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        TestJSONFile.$closeResource(throwable3, (AutoCloseable)jsonWriter);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Test failed for empty vector of type " + field, e);
                }
                throwable3 = null;
                try (JsonFileReader reader = new JsonFileReader(outputFile, this.allocator);){
                    readSchema2 = reader.start();
                    Assert.assertEquals((Object)schema, (Object)readSchema2);
                    data = reader.read();
                    throwable2 = null;
                    try {
                        Assert.assertNotNull((Object)data);
                        Assert.assertEquals((long)data.getRowCount(), (long)0L);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (data != null) {
                            TestJSONFile.$closeResource(throwable2, (AutoCloseable)data);
                        }
                    }
                    Assert.assertNull((Object)reader.read());
                }
                catch (Throwable readSchema2) {
                    throwable3 = readSchema2;
                    throw readSchema2;
                }
                root.allocateNew();
                root.setRowCount(0);
                try {
                    jsonWriter = new JsonFileWriter(outputFile, JsonFileWriter.config().pretty(true));
                    throwable3 = null;
                    try {
                        jsonWriter.start(schema, null);
                        jsonWriter.write(root);
                    }
                    catch (Throwable readSchema2) {
                        throwable3 = readSchema2;
                        throw readSchema2;
                    }
                    finally {
                        TestJSONFile.$closeResource(throwable3, (AutoCloseable)jsonWriter);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Test failed for empty vector of type " + field, e);
                }
                reader = new JsonFileReader(outputFile, this.allocator);
                throwable3 = null;
                try {
                    readSchema2 = reader.start();
                    Assert.assertEquals((Object)schema, (Object)readSchema2);
                    data = reader.read();
                    throwable2 = null;
                    try {
                        Assert.assertNotNull((Object)data);
                        Assert.assertEquals((long)data.getRowCount(), (long)0L);
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (data != null) {
                            TestJSONFile.$closeResource(throwable2, (AutoCloseable)data);
                        }
                    }
                    Assert.assertNull((Object)reader.read());
                }
                catch (Throwable throwable7) {
                    throwable3 = throwable7;
                    throw throwable7;
                }
                finally {
                    TestJSONFile.$closeResource(throwable3, (AutoCloseable)reader);
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (root == null) continue;
                TestJSONFile.$closeResource(throwable, (AutoCloseable)root);
            }
        }
    }
}

