/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.BaseFileTest;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestArrowFile
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestArrowFile.class);

    @Test
    public void testWrite() throws IOException {
        File file = new File("target/mytest_write.arrow");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeData(count, parent);
            this.write(parent.getChild("root"), file, new ByteArrayOutputStream());
        }
    }

    @Test
    public void testWriteComplex() throws IOException {
        File file = new File("target/mytest_write_complex.arrow");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeComplexData(count, parent);
            FieldVector root = parent.getChild("root");
            this.validateComplexContent(count, new VectorSchemaRoot(root));
            this.write(root, file, new ByteArrayOutputStream());
        }
    }

    private void write(FieldVector parent, File file, OutputStream outStream) throws IOException {
        VectorSchemaRoot root = new VectorSchemaRoot(parent);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             ArrowFileWriter arrowWriter = new ArrowFileWriter(root, null, (WritableByteChannel)fileOutputStream.getChannel());){
            LOGGER.debug("writing schema: " + root.getSchema());
            arrowWriter.start();
            arrowWriter.writeBatch();
            arrowWriter.end();
        }
        if (outStream != null) {
            var6_6 = null;
            try (ArrowStreamWriter arrowWriter = new ArrowStreamWriter(root, null, outStream);){
                arrowWriter.start();
                arrowWriter.writeBatch();
                arrowWriter.end();
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testFileStreamHasEos() throws IOException {
        try (VarCharVector vector1 = TestUtils.newVarCharVector("varchar1", this.allocator);){
            vector1.allocateNewSafe();
            vector1.set(0, "foo".getBytes(StandardCharsets.UTF_8));
            vector1.set(1, "bar".getBytes(StandardCharsets.UTF_8));
            vector1.set(3, "baz".getBytes(StandardCharsets.UTF_8));
            vector1.set(4, "bar".getBytes(StandardCharsets.UTF_8));
            vector1.set(5, "baz".getBytes(StandardCharsets.UTF_8));
            vector1.setValueCount(6);
            List<Field> fields = Arrays.asList(vector1.getField());
            List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{vector1});
            VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector1.getValueCount());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));
            writer.start();
            writer.writeBatch();
            writer.end();
            byte[] bytes = out.toByteArray();
            byte[] bytesWithoutMagic = new byte[bytes.length - 8];
            System.arraycopy(bytes, 8, bytesWithoutMagic, 0, bytesWithoutMagic.length);
            try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)new ByteArrayInputStream(bytesWithoutMagic), this.allocator);){
                Assert.assertTrue((boolean)reader.loadNextBatch());
                Assert.assertFalse((boolean)reader.loadNextBatch());
            }
        }
    }
}

