/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowMessage;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.ExpectedException;

public class MessageSerializerTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    public static ArrowBuf buf(BufferAllocator alloc, byte[] bytes) {
        ArrowBuf buffer = alloc.buffer((long)bytes.length);
        buffer.writeBytes(bytes);
        return buffer;
    }

    public static byte[] array(ArrowBuf buf) {
        byte[] bytes = new byte[LargeMemoryUtil.checkedCastToInt((long)buf.readableBytes())];
        buf.readBytes(bytes);
        return bytes;
    }

    private int intToByteRoundtrip(int v, byte[] bytes) {
        MessageSerializer.intToBytes((int)v, (byte[])bytes);
        return MessageSerializer.bytesToInt((byte[])bytes);
    }

    @Test
    public void testIntToBytes() {
        int[] values;
        byte[] bytes = new byte[4];
        for (int v : values = new int[]{1, 15, 256, 65536, Integer.MAX_VALUE}) {
            Assert.assertEquals((long)this.intToByteRoundtrip(v, bytes), (long)v);
        }
    }

    @Test
    public void testWriteMessageBufferAligned() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WriteChannel out = new WriteChannel(Channels.newChannel(outputStream));
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());
        buffer.putInt(1);
        buffer.putInt(2);
        buffer.flip();
        int bytesWritten = MessageSerializer.writeMessageBuffer((WriteChannel)out, (int)8, (ByteBuffer)buffer);
        Assert.assertEquals((long)16L, (long)bytesWritten);
        buffer.rewind();
        buffer.putInt(3);
        buffer.flip();
        bytesWritten = MessageSerializer.writeMessageBuffer((WriteChannel)out, (int)4, (ByteBuffer)buffer);
        Assert.assertEquals((long)16L, (long)bytesWritten);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ReadChannel in = new ReadChannel(Channels.newChannel(inputStream));
        ByteBuffer result = ByteBuffer.allocate(32).order(ByteOrder.nativeOrder());
        in.readFully(result);
        result.rewind();
        Assert.assertEquals((long)-1L, (long)result.getInt());
        result.order(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)8L, (long)result.getInt());
        result.order(ByteOrder.nativeOrder());
        Assert.assertEquals((long)1L, (long)result.getInt());
        Assert.assertEquals((long)2L, (long)result.getInt());
        Assert.assertEquals((long)-1L, (long)result.getInt());
        result.order(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)8L, (long)result.getInt());
        result.order(ByteOrder.nativeOrder());
        Assert.assertEquals((long)3L, (long)result.getInt());
        Assert.assertEquals((long)0L, (long)result.getInt());
    }

    @Test
    public void testSchemaMessageSerialization() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long size = MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (Schema)schema);
        Assert.assertEquals((long)size, (long)out.toByteArray().length);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Schema deserialized = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(in)));
        Assert.assertEquals((Object)schema, (Object)deserialized);
        Assert.assertEquals((long)1L, (long)deserialized.getFields().size());
    }

    @Test
    public void testSchemaDictionaryMessageSerialization() throws IOException {
        DictionaryEncoding dictionary = new DictionaryEncoding(9L, false, new ArrowType.Int(8, true));
        Field field = new Field("test", new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, dictionary, null), null);
        Schema schema = new Schema(Collections.singletonList(field));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long size = MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (Schema)schema);
        Assert.assertEquals((long)size, (long)out.toByteArray().length);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Schema deserialized = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(in)));
        Assert.assertEquals((Object)schema, (Object)deserialized);
    }

    @Test
    public void testSerializeRecordBatchV4() throws IOException {
        byte[] validity = new byte[]{-1, 0};
        byte[] values = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        RootAllocator alloc = new RootAllocator(Long.MAX_VALUE);
        ArrowBuf validityb = MessageSerializerTest.buf((BufferAllocator)alloc, validity);
        ArrowBuf valuesb = MessageSerializerTest.buf((BufferAllocator)alloc, values);
        ArrowRecordBatch batch = new ArrowRecordBatch(16, Arrays.asList(new ArrowFieldNode(16L, 8L)), Arrays.asList(validityb, valuesb));
        IpcOption option = new IpcOption(false, MetadataVersion.V4);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)batch, (IpcOption)option);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ReadChannel channel = new ReadChannel(Channels.newChannel(in));
        ArrowMessage deserialized = MessageSerializer.deserializeMessageBatch((ReadChannel)channel, (BufferAllocator)alloc);
        Assert.assertEquals(ArrowRecordBatch.class, deserialized.getClass());
        MessageSerializerTest.verifyBatch((ArrowRecordBatch)deserialized, validity, values);
    }

    @Test
    public void testSerializeRecordBatchV5() throws Exception {
        byte[] validity = new byte[]{-1, 0};
        byte[] values = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        RootAllocator alloc = new RootAllocator(Long.MAX_VALUE);
        ArrowBuf validityb = MessageSerializerTest.buf((BufferAllocator)alloc, validity);
        ArrowBuf valuesb = MessageSerializerTest.buf((BufferAllocator)alloc, values);
        ArrowRecordBatch batch = new ArrowRecordBatch(16, Arrays.asList(new ArrowFieldNode(16L, 8L)), Arrays.asList(validityb, valuesb));
        IpcOption option = new IpcOption(false, MetadataVersion.V5);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)batch, (IpcOption)option);
        validityb.close();
        valuesb.close();
        batch.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ReadChannel channel = new ReadChannel(Channels.newChannel(in));
        ArrowMessage deserialized = MessageSerializer.deserializeMessageBatch((ReadChannel)channel, (BufferAllocator)alloc);
        Assert.assertEquals(ArrowRecordBatch.class, deserialized.getClass());
        MessageSerializerTest.verifyBatch((ArrowRecordBatch)deserialized, validity, values);
        deserialized.close();
        byte[] validBytes = out.toByteArray();
        byte[] missingBytes = Arrays.copyOfRange(validBytes, 0, validBytes.length - 1);
        ByteArrayInputStream in2 = new ByteArrayInputStream(missingBytes);
        ReadChannel channel2 = new ReadChannel(Channels.newChannel(in2));
        Assertions.assertThrows(IOException.class, () -> MessageSerializerTest.lambda$testSerializeRecordBatchV5$0(channel2, (BufferAllocator)alloc));
        alloc.close();
    }

    public static Schema testSchema() {
        return new Schema(Arrays.asList(new Field("testField", FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), Collections.emptyList())));
    }

    public static void verifyBatch(ArrowRecordBatch batch, byte[] validity, byte[] values) {
        Assert.assertTrue((batch != null ? 1 : 0) != 0);
        List nodes = batch.getNodes();
        Assert.assertEquals((long)1L, (long)nodes.size());
        ArrowFieldNode node = (ArrowFieldNode)nodes.get(0);
        Assert.assertEquals((long)16L, (long)node.getLength());
        Assert.assertEquals((long)8L, (long)node.getNullCount());
        List buffers = batch.getBuffers();
        Assert.assertEquals((long)2L, (long)buffers.size());
        Assert.assertArrayEquals((byte[])validity, (byte[])MessageSerializerTest.array((ArrowBuf)buffers.get(0)));
        Assert.assertArrayEquals((byte[])values, (byte[])MessageSerializerTest.array((ArrowBuf)buffers.get(1)));
    }

    private static /* synthetic */ void lambda$testSerializeRecordBatchV5$0(ReadChannel channel, BufferAllocator alloc) throws Throwable {
        MessageSerializer.deserializeMessageBatch((ReadChannel)channel, (BufferAllocator)alloc);
    }
}

