/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.writer;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SchemaChangeCallBack;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.NullableStructReaderImpl;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.SingleStructReaderImpl;
import org.apache.arrow.vector.complex.impl.SingleStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.complex.impl.UnionReader;
import org.apache.arrow.vector.complex.impl.UnionWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.FixedSizeBinaryWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.complex.writer.Float8Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import org.apache.arrow.vector.complex.writer.TimeStampNanoTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampNanoWriter;
import org.apache.arrow.vector.complex.writer.TimeStampSecTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampSecWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import org.apache.arrow.vector.holders.DecimalHolder;
import org.apache.arrow.vector.holders.DurationHolder;
import org.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import org.apache.arrow.vector.holders.IntHolder;
import org.apache.arrow.vector.holders.NullableDurationHolder;
import org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.holders.TimeStampMilliTZHolder;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.vector.util.DecimalUtility;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestComplexWriter {
    private BufferAllocator allocator;
    private static final int COUNT = 100;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void simpleNestedTypes() {
        NonNullableStructVector parent = this.populateStructVector(null);
        FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
        for (int i = 0; i < 100; ++i) {
            rootReader.setPosition(i);
            Assert.assertEquals((long)i, (long)rootReader.reader("int").readInteger().intValue());
            Assert.assertEquals((long)i, (long)rootReader.reader("bigInt").readLong());
        }
        parent.close();
    }

    @Test
    public void transferPairSchemaChange() {
        SchemaChangeCallBack callBack1 = new SchemaChangeCallBack();
        SchemaChangeCallBack callBack2 = new SchemaChangeCallBack();
        try (NonNullableStructVector parent = this.populateStructVector((CallBack)callBack1);){
            TransferPair tp = parent.getTransferPair("newVector", this.allocator, (CallBack)callBack2);
            ComplexWriterImpl writer = new ComplexWriterImpl("newWriter", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            IntWriter intWriter = rootWriter.integer("newInt");
            intWriter.writeInt(1);
            writer.setValueCount(1);
            Assert.assertTrue((boolean)callBack1.getSchemaChangedAndReset());
            Assert.assertFalse((boolean)callBack1.getSchemaChangedAndReset());
        }
    }

    private NonNullableStructVector populateStructVector(CallBack callBack) {
        NonNullableStructVector parent = new NonNullableStructVector("parent", this.allocator, new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null), callBack);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        IntWriter intWriter = rootWriter.integer("int");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        for (int i = 0; i < 100; ++i) {
            rootWriter.start();
            intWriter.writeInt(i);
            bigIntWriter.writeBigInt((long)i);
            rootWriter.end();
        }
        writer.setValueCount(100);
        return parent;
    }

    @Test
    public void nullableStruct() {
        try (NonNullableStructVector structVector = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", structVector);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            for (int i = 0; i < 100; ++i) {
                rootWriter.start();
                if (i % 2 == 0) {
                    BaseWriter.StructWriter structWriter = rootWriter.struct("struct");
                    structWriter.setPosition(i);
                    structWriter.start();
                    structWriter.bigInt("nested").writeBigInt((long)i);
                    structWriter.end();
                }
                rootWriter.end();
            }
            writer.setValueCount(100);
            this.checkNullableStruct(structVector);
        }
    }

    @Test
    public void nullableStruct2() {
        try (NonNullableStructVector structVector = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", structVector);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            BaseWriter.StructWriter structWriter = rootWriter.struct("struct");
            for (int i = 0; i < 100; ++i) {
                rootWriter.start();
                if (i % 2 == 0) {
                    structWriter.setPosition(i);
                    structWriter.start();
                    structWriter.bigInt("nested").writeBigInt((long)i);
                    structWriter.end();
                }
                rootWriter.end();
            }
            writer.setValueCount(100);
            this.checkNullableStruct(structVector);
        }
    }

    private void checkNullableStruct(NonNullableStructVector structVector) {
        FieldReader rootReader = new SingleStructReaderImpl(structVector).reader("root");
        for (int i = 0; i < 100; ++i) {
            rootReader.setPosition(i);
            Assert.assertTrue((String)("index is set: " + i), (boolean)rootReader.isSet());
            FieldReader struct = rootReader.reader("struct");
            if (i % 2 == 0) {
                Assert.assertTrue((String)("index is set: " + i), (boolean)struct.isSet());
                Assert.assertNotNull((String)("index is set: " + i), (Object)struct.readObject());
                Assert.assertEquals((long)i, (long)struct.reader("nested").readLong());
                continue;
            }
            Assert.assertFalse((String)("index is not set: " + i), (boolean)struct.isSet());
            Assert.assertNull((String)("index is not set: " + i), (Object)struct.readObject());
        }
    }

    @Test
    public void testList() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            rootWriter.start();
            rootWriter.bigInt("int").writeBigInt(0L);
            rootWriter.list("list").startList();
            rootWriter.list("list").bigInt().writeBigInt(0L);
            rootWriter.list("list").endList();
            rootWriter.end();
            rootWriter.start();
            rootWriter.bigInt("int").writeBigInt(1L);
            rootWriter.end();
            writer.setValueCount(2);
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            rootReader.setPosition(0);
            Assert.assertTrue((String)"row 0 list is not set", (boolean)rootReader.reader("list").isSet());
            Assert.assertEquals((Object)0L, (Object)rootReader.reader("list").reader().readLong());
            rootReader.setPosition(1);
            Assert.assertFalse((String)"row 1 list is set", (boolean)rootReader.reader("list").isSet());
        }
    }

    @Test
    public void listScalarType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 2 == 0) {
                        listWriter.writeInt(j);
                        continue;
                    }
                    IntHolder holder = new IntHolder();
                    holder.value = j;
                    listWriter.write(holder);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    Assert.assertEquals((long)j, (long)listReader.reader().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void testListScalarNull() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 2 == 0) {
                        listWriter.writeNull();
                        continue;
                    }
                    IntHolder holder = new IntHolder();
                    holder.value = j;
                    listWriter.write(holder);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    if (j % 2 == 0) {
                        Assert.assertFalse((String)("index is set: " + j), (boolean)listReader.reader().isSet());
                        continue;
                    }
                    Assert.assertTrue((String)("index is not set: " + j), (boolean)listReader.reader().isSet());
                    Assert.assertEquals((long)j, (long)listReader.reader().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void listDecimalType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            DecimalHolder holder = new DecimalHolder();
            holder.buffer = this.allocator.buffer(16L);
            ArrowType.Decimal arrowType = new ArrowType.Decimal(10, 0, 128);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 4 == 0) {
                        listWriter.writeDecimal(new BigDecimal(j));
                        continue;
                    }
                    if (j % 4 == 1) {
                        DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)new BigDecimal(j), (ArrowBuf)holder.buffer, (int)0, (int)16);
                        holder.start = 0L;
                        holder.scale = 0;
                        holder.precision = 10;
                        listWriter.write(holder);
                        continue;
                    }
                    if (j % 4 == 2) {
                        DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)new BigDecimal(j), (ArrowBuf)holder.buffer, (int)0, (int)16);
                        listWriter.writeDecimal(0L, holder.buffer, (ArrowType)arrowType);
                        continue;
                    }
                    byte[] value = BigDecimal.valueOf(j).unscaledValue().toByteArray();
                    listWriter.writeBigEndianBytesToDecimal(value, (ArrowType)arrowType);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    BigDecimal expected = new BigDecimal(j);
                    BigDecimal actual = listReader.reader().readBigDecimal();
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
            }
            holder.buffer.close();
        }
    }

    @Test
    public void listTimeStampMilliTZType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 2 == 0) {
                        listWriter.writeNull();
                        continue;
                    }
                    TimeStampMilliTZHolder holder = new TimeStampMilliTZHolder();
                    holder.timezone = "FakeTimeZone";
                    holder.value = j;
                    listWriter.timeStampMilliTZ().write(holder);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    if (j % 2 == 0) {
                        Assert.assertFalse((String)("index is set: " + j), (boolean)listReader.reader().isSet());
                        continue;
                    }
                    NullableTimeStampMilliTZHolder actual = new NullableTimeStampMilliTZHolder();
                    listReader.reader().read(actual);
                    Assert.assertEquals((long)j, (long)actual.value);
                    Assert.assertEquals((Object)"FakeTimeZone", (Object)actual.timezone);
                }
            }
        }
    }

    @Test
    public void listDurationType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 2 == 0) {
                        listWriter.writeNull();
                        continue;
                    }
                    DurationHolder holder = new DurationHolder();
                    holder.unit = TimeUnit.MICROSECOND;
                    holder.value = j;
                    listWriter.duration().write(holder);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    if (j % 2 == 0) {
                        Assert.assertFalse((String)("index is set: " + j), (boolean)listReader.reader().isSet());
                        continue;
                    }
                    NullableDurationHolder actual = new NullableDurationHolder();
                    listReader.reader().read(actual);
                    Assert.assertEquals((Object)TimeUnit.MICROSECOND, (Object)actual.unit);
                    Assert.assertEquals((long)j, (long)actual.value);
                }
            }
        }
    }

    @Test
    public void listFixedSizeBinaryType() throws Exception {
        ArrayList<ArrowBuf> bufs = new ArrayList<ArrowBuf>();
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    if (j % 2 == 0) {
                        listWriter.writeNull();
                        continue;
                    }
                    ArrowBuf buf = this.allocator.buffer(4L);
                    buf.setInt(0L, j);
                    FixedSizeBinaryHolder holder = new FixedSizeBinaryHolder();
                    holder.byteWidth = 4;
                    holder.buffer = buf;
                    listWriter.fixedSizeBinary().write(holder);
                    bufs.add(buf);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    if (j % 2 == 0) {
                        Assert.assertFalse((String)("index is set: " + j), (boolean)listReader.reader().isSet());
                        continue;
                    }
                    NullableFixedSizeBinaryHolder actual = new NullableFixedSizeBinaryHolder();
                    listReader.reader().read(actual);
                    Assert.assertEquals((long)j, (long)actual.buffer.getInt(0L));
                    Assert.assertEquals((long)4L, (long)actual.byteWidth);
                }
            }
        }
        AutoCloseables.close(bufs);
    }

    @Test
    public void listScalarTypeNullable() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                if (i % 2 != 0) continue;
                listWriter.setPosition(i);
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    listWriter.writeInt(j);
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                if (i % 2 == 0) {
                    Assert.assertTrue((String)("index is set: " + i), (boolean)listReader.isSet());
                    Assert.assertEquals((String)("correct length at: " + i), (long)(i % 7), (long)((List)listReader.readObject()).size());
                    continue;
                }
                Assert.assertFalse((String)("index is not set: " + i), (boolean)listReader.isSet());
                Assert.assertNull((String)("index is not set: " + i), (Object)listReader.readObject());
            }
        }
    }

    @Test
    public void listStructType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.StructWriter structWriter = listWriter.struct();
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    structWriter.start();
                    structWriter.integer("int").writeInt(j);
                    structWriter.bigInt("bigInt").writeBigInt((long)j);
                    structWriter.end();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    listReader.next();
                    Assert.assertEquals((String)("record: " + i), (long)j, (long)listReader.reader().reader("int").readInteger().intValue());
                    Assert.assertEquals((long)j, (long)listReader.reader().reader("bigInt").readLong());
                }
            }
        }
    }

    @Test
    public void listListType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    BaseWriter.ListWriter innerListWriter = listWriter.list();
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        innerListWriter.integer().writeInt(k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkListOfLists(listVector);
        }
    }

    @Test
    public void listListType2() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.ListWriter innerListWriter = listWriter.list();
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        innerListWriter.integer().writeInt(k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkListOfLists(listVector);
        }
    }

    private void checkListOfLists(ListVector listVector) {
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                FieldReader innerListReader = listReader.reader();
                for (int k = 0; k < i % 13; ++k) {
                    innerListReader.next();
                    Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void unionListListType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    BaseWriter.ListWriter innerListWriter = listWriter.list();
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        if (k % 2 == 0) {
                            innerListWriter.integer().writeInt(k);
                            continue;
                        }
                        innerListWriter.bigInt().writeBigInt((long)k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkUnionList(listVector);
        }
    }

    @Test
    public void unionListListType2() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.ListWriter innerListWriter = listWriter.list();
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        if (k % 2 == 0) {
                            innerListWriter.integer().writeInt(k);
                            continue;
                        }
                        innerListWriter.bigInt().writeBigInt((long)k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkUnionList(listVector);
        }
    }

    private void checkUnionList(ListVector listVector) {
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                FieldReader innerListReader = listReader.reader();
                for (int k = 0; k < i % 13; ++k) {
                    innerListReader.next();
                    if (k % 2 == 0) {
                        Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readInteger().intValue());
                        continue;
                    }
                    Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readLong());
                }
            }
        }
    }

    @Test
    public void testListMapType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.MapWriter innerMapWriter = listWriter.map(true);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    innerMapWriter.startMap();
                    for (int k = 0; k < i % 13; ++k) {
                        innerMapWriter.startEntry();
                        innerMapWriter.key().integer().writeInt(k);
                        if (k % 2 == 0) {
                            innerMapWriter.value().bigInt().writeBigInt((long)k);
                        }
                        innerMapWriter.endEntry();
                    }
                    innerMapWriter.endMap();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkListMap(listVector);
            MapVector mapVector = (MapVector)listVector.getDataVector();
            ArrowType arrowType = mapVector.getField().getFieldType().getType();
            Assert.assertTrue((boolean)((ArrowType.Map)arrowType).getKeysSorted());
        }
    }

    private void checkListMap(ListVector listVector) {
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                UnionMapReader mapReader = (UnionMapReader)listReader.reader();
                for (int k = 0; k < i % 13; ++k) {
                    mapReader.next();
                    Assert.assertEquals((String)("record key: " + i), (long)k, (long)mapReader.key().readInteger().intValue());
                    if (k % 2 == 0) {
                        Assert.assertEquals((String)("record value: " + i), (long)k, (long)mapReader.value().readLong());
                        continue;
                    }
                    Assert.assertNull((String)("record value: " + i), (Object)mapReader.value().readLong());
                }
            }
        }
    }

    @Test
    public void simpleUnion() throws Exception {
        ArrayList<ArrowBuf> bufs = new ArrayList<ArrowBuf>();
        UnionVector vector = new UnionVector("union", this.allocator, null, null);
        UnionWriter unionWriter = new UnionWriter(vector);
        unionWriter.allocate();
        for (int i = 0; i < 100; ++i) {
            TimeStampMilliTZHolder holder;
            unionWriter.setPosition(i);
            if (i % 5 == 0) {
                unionWriter.writeInt(i);
                continue;
            }
            if (i % 5 == 1) {
                holder = new TimeStampMilliTZHolder();
                holder.value = i;
                holder.timezone = "AsdfTimeZone";
                unionWriter.write(holder);
                continue;
            }
            if (i % 5 == 2) {
                holder = new DurationHolder();
                holder.value = i;
                holder.unit = TimeUnit.NANOSECOND;
                unionWriter.write((DurationHolder)holder);
                continue;
            }
            if (i % 5 == 3) {
                holder = new FixedSizeBinaryHolder();
                ArrowBuf buf = this.allocator.buffer(4L);
                buf.setInt(0L, i);
                holder.byteWidth = 4;
                holder.buffer = buf;
                unionWriter.write((FixedSizeBinaryHolder)holder);
                bufs.add(buf);
                continue;
            }
            unionWriter.writeFloat4((float)i);
        }
        vector.setValueCount(100);
        UnionReader unionReader = new UnionReader(vector);
        for (int i = 0; i < 100; ++i) {
            NullableTimeStampMilliTZHolder holder;
            unionReader.setPosition(i);
            if (i % 5 == 0) {
                Assert.assertEquals((float)i, (float)i, (float)unionReader.readInteger().intValue());
                continue;
            }
            if (i % 5 == 1) {
                holder = new NullableTimeStampMilliTZHolder();
                unionReader.read(holder);
                Assert.assertEquals((long)i, (long)holder.value);
                Assert.assertEquals((Object)"AsdfTimeZone", (Object)holder.timezone);
                continue;
            }
            if (i % 5 == 2) {
                holder = new NullableDurationHolder();
                unionReader.read((NullableDurationHolder)holder);
                Assert.assertEquals((long)i, (long)holder.value);
                Assert.assertEquals((Object)TimeUnit.NANOSECOND, (Object)holder.unit);
                continue;
            }
            if (i % 5 == 3) {
                holder = new NullableFixedSizeBinaryHolder();
                unionReader.read((NullableFixedSizeBinaryHolder)holder);
                Assert.assertEquals((long)i, (long)holder.buffer.getInt(0L));
                Assert.assertEquals((long)4L, (long)holder.byteWidth);
                continue;
            }
            Assert.assertEquals((double)i, (double)unionReader.readFloat().floatValue(), (double)1.0E-12);
        }
        vector.close();
        AutoCloseables.close(bufs);
    }

    @Test
    public void promotableWriter() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            Long value;
            FieldReader reader;
            int i;
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            for (int i2 = 0; i2 < 100; ++i2) {
                BigIntWriter bigIntWriter = rootWriter.bigInt("a");
                bigIntWriter.setPosition(i2);
                bigIntWriter.writeBigInt((long)i2);
            }
            Field field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
            Assert.assertEquals((Object)"a", (Object)field.getName());
            Assert.assertEquals((Object)ArrowType.Int.TYPE_TYPE, (Object)field.getType().getTypeID());
            ArrowType.Int intType = (ArrowType.Int)field.getType();
            Assert.assertEquals((long)64L, (long)intType.getBitWidth());
            Assert.assertTrue((boolean)intType.getIsSigned());
            for (int i3 = 100; i3 < 200; ++i3) {
                VarCharWriter varCharWriter = rootWriter.varChar("a");
                varCharWriter.setPosition(i3);
                byte[] bytes = Integer.toString(i3).getBytes();
                ArrowBuf tempBuf = this.allocator.buffer((long)bytes.length);
                tempBuf.setBytes(0L, bytes);
                varCharWriter.writeVarChar(0, bytes.length, tempBuf);
                tempBuf.close();
            }
            field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
            Assert.assertEquals((Object)"a", (Object)field.getName());
            Assert.assertEquals((Object)ArrowType.Union.TYPE_TYPE, (Object)field.getType().getTypeID());
            Assert.assertEquals((Object)ArrowType.Int.TYPE_TYPE, (Object)((Field)field.getChildren().get(0)).getType().getTypeID());
            Assert.assertEquals((Object)ArrowType.Utf8.TYPE_TYPE, (Object)((Field)field.getChildren().get(1)).getType().getTypeID());
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            for (i = 0; i < 100; ++i) {
                rootReader.setPosition(i);
                reader = rootReader.reader("a");
                value = reader.readLong();
                Assert.assertNotNull((String)("index: " + i), (Object)value);
                Assert.assertEquals((long)i, (long)value.intValue());
            }
            for (i = 100; i < 200; ++i) {
                rootReader.setPosition(i);
                reader = rootReader.reader("a");
                value = reader.readText();
                Assert.assertEquals((Object)Integer.toString(i), (Object)value.toString());
            }
        }
    }

    @Test
    public void promotableWriterSchema() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            rootWriter.bigInt("a");
            rootWriter.varChar("a");
            Field field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
            Assert.assertEquals((Object)"a", (Object)field.getName());
            Assert.assertEquals((Object)ArrowType.ArrowTypeID.Union, (Object)field.getType().getTypeID());
            Assert.assertEquals((Object)ArrowType.ArrowTypeID.Int, (Object)((Field)field.getChildren().get(0)).getType().getTypeID());
            ArrowType.Int intType = (ArrowType.Int)((Field)field.getChildren().get(0)).getType();
            Assert.assertEquals((long)64L, (long)intType.getBitWidth());
            Assert.assertTrue((boolean)intType.getIsSigned());
            Assert.assertEquals((Object)ArrowType.ArrowTypeID.Utf8, (Object)((Field)field.getChildren().get(1)).getType().getTypeID());
        }
    }

    private Set<String> getFieldNames(List<Field> fields) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
            if (field.getChildren().isEmpty()) continue;
            for (String name : this.getFieldNames(field.getChildren())) {
                fieldNames.add(field.getName() + "::" + name);
            }
        }
        return fieldNames;
    }

    @Test
    public void structWriterMixedCaseFieldNames() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("rootCaseSensitive", parent, false, true);
            BaseWriter.StructWriter rootWriterCaseSensitive = writer.rootAsStruct();
            rootWriterCaseSensitive.bigInt("int_field");
            rootWriterCaseSensitive.bigInt("Int_Field");
            rootWriterCaseSensitive.float4("float_field");
            rootWriterCaseSensitive.float4("Float_Field");
            BaseWriter.StructWriter structFieldWriterCaseSensitive = rootWriterCaseSensitive.struct("struct_field");
            structFieldWriterCaseSensitive.varChar("char_field");
            structFieldWriterCaseSensitive.varChar("Char_Field");
            BaseWriter.ListWriter listFieldWriterCaseSensitive = rootWriterCaseSensitive.list("list_field");
            BaseWriter.StructWriter listStructFieldWriterCaseSensitive = listFieldWriterCaseSensitive.struct();
            listStructFieldWriterCaseSensitive.bit("bit_field");
            listStructFieldWriterCaseSensitive.bit("Bit_Field");
            List fieldsCaseSensitive = ((Field)parent.getField().getChildren().get(0)).getChildren();
            Set<String> fieldNamesCaseSensitive = this.getFieldNames(fieldsCaseSensitive);
            Assert.assertEquals((long)11L, (long)fieldNamesCaseSensitive.size());
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("int_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("Int_Field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("float_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("Float_Field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("struct_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("struct_field::char_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("struct_field::Char_Field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::bit_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::Bit_Field"));
            ComplexWriterImpl writerCaseInsensitive = new ComplexWriterImpl("rootCaseInsensitive", parent, false, false);
            BaseWriter.StructWriter rootWriterCaseInsensitive = writerCaseInsensitive.rootAsStruct();
            rootWriterCaseInsensitive.bigInt("int_field");
            rootWriterCaseInsensitive.bigInt("Int_Field");
            rootWriterCaseInsensitive.float4("float_field");
            rootWriterCaseInsensitive.float4("Float_Field");
            BaseWriter.StructWriter structFieldWriterCaseInsensitive = rootWriterCaseInsensitive.struct("struct_field");
            structFieldWriterCaseInsensitive.varChar("char_field");
            structFieldWriterCaseInsensitive.varChar("Char_Field");
            BaseWriter.ListWriter listFieldWriterCaseInsensitive = rootWriterCaseInsensitive.list("list_field");
            BaseWriter.StructWriter listStructFieldWriterCaseInsensitive = listFieldWriterCaseInsensitive.struct();
            listStructFieldWriterCaseInsensitive.bit("bit_field");
            listStructFieldWriterCaseInsensitive.bit("Bit_Field");
            List fieldsCaseInsensitive = ((Field)parent.getField().getChildren().get(1)).getChildren();
            Set<String> fieldNamesCaseInsensitive = this.getFieldNames(fieldsCaseInsensitive);
            Assert.assertEquals((long)7L, (long)fieldNamesCaseInsensitive.size());
            Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("int_field"));
            Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("float_field"));
            Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("struct_field"));
            Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("struct_field::char_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$"));
            Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::bit_field"));
        }
    }

    @Test
    public void timeStampSecWriter() throws Exception {
        long expectedSecs = 981173106L;
        LocalDateTime expectedSecDateTime = LocalDateTime.of(2001, 2, 3, 4, 5, 6, 0);
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            TimeStampSecWriter timeStampSecWriter = rootWriter.timeStampSec("sec");
            timeStampSecWriter.setPosition(0);
            timeStampSecWriter.writeTimeStampSec(981173106L);
            TimeStampSecTZWriter timeStampSecTZWriter = rootWriter.timeStampSecTZ("secTZ", "UTC");
            timeStampSecTZWriter.setPosition(1);
            timeStampSecTZWriter.writeTimeStampSecTZ(981173106L);
            List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
            this.checkTimestampField((Field)children.get(0), "sec");
            this.checkTimestampTZField((Field)children.get(1), "secTZ", "UTC");
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            FieldReader secReader = rootReader.reader("sec");
            secReader.setPosition(0);
            LocalDateTime secDateTime = secReader.readLocalDateTime();
            Assert.assertEquals((Object)expectedSecDateTime, (Object)secDateTime);
            long secLong = secReader.readLong();
            Assert.assertEquals((long)981173106L, (long)secLong);
            FieldReader secTZReader = rootReader.reader("secTZ");
            secTZReader.setPosition(1);
            long secTZLong = secTZReader.readLong();
            Assert.assertEquals((long)981173106L, (long)secTZLong);
        }
    }

    @Test
    public void timeStampMilliWriters() throws Exception {
        long expectedMillis = 981173106123L;
        LocalDateTime expectedMilliDateTime = LocalDateTime.of(2001, 2, 3, 4, 5, 6, 123000000);
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            TimeStampMilliWriter timeStampWriter = rootWriter.timeStampMilli("milli");
            timeStampWriter.setPosition(0);
            timeStampWriter.writeTimeStampMilli(981173106123L);
            String tz = "UTC";
            TimeStampMilliTZWriter timeStampTZWriter = rootWriter.timeStampMilliTZ("milliTZ", tz);
            timeStampTZWriter.setPosition(0);
            timeStampTZWriter.writeTimeStampMilliTZ(981173106123L);
            List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
            this.checkTimestampField((Field)children.get(0), "milli");
            this.checkTimestampTZField((Field)children.get(1), "milliTZ", tz);
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            FieldReader milliReader = rootReader.reader("milli");
            milliReader.setPosition(0);
            LocalDateTime milliDateTime = milliReader.readLocalDateTime();
            Assert.assertEquals((Object)expectedMilliDateTime, (Object)milliDateTime);
            long milliLong = milliReader.readLong();
            Assert.assertEquals((long)981173106123L, (long)milliLong);
            FieldReader milliTZReader = rootReader.reader("milliTZ");
            milliTZReader.setPosition(0);
            long milliTZLong = milliTZReader.readLong();
            Assert.assertEquals((long)981173106123L, (long)milliTZLong);
        }
    }

    private void checkTimestampField(Field field, String name) {
        Assert.assertEquals((Object)name, (Object)field.getName());
        Assert.assertEquals((Object)ArrowType.Timestamp.TYPE_TYPE, (Object)field.getType().getTypeID());
    }

    private void checkTimestampTZField(Field field, String name, String tz) {
        this.checkTimestampField(field, name);
        Assert.assertEquals((Object)tz, (Object)((ArrowType.Timestamp)field.getType()).getTimezone());
    }

    @Test
    public void timeStampMicroWriters() throws Exception {
        long expectedMicros = 981173106123456L;
        LocalDateTime expectedMicroDateTime = LocalDateTime.of(2001, 2, 3, 4, 5, 6, 123456000);
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            TimeStampMicroWriter timeStampMicroWriter = rootWriter.timeStampMicro("micro");
            timeStampMicroWriter.setPosition(0);
            timeStampMicroWriter.writeTimeStampMicro(981173106123456L);
            String tz = "UTC";
            TimeStampMicroTZWriter timeStampMicroWriter2 = rootWriter.timeStampMicroTZ("microTZ", tz);
            timeStampMicroWriter2.setPosition(1);
            timeStampMicroWriter2.writeTimeStampMicroTZ(981173106123456L);
            List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
            this.checkTimestampField((Field)children.get(0), "micro");
            this.checkTimestampTZField((Field)children.get(1), "microTZ", tz);
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            FieldReader microReader = rootReader.reader("micro");
            microReader.setPosition(0);
            LocalDateTime microDateTime = microReader.readLocalDateTime();
            Assert.assertEquals((Object)expectedMicroDateTime, (Object)microDateTime);
            long microLong = microReader.readLong();
            Assert.assertEquals((long)981173106123456L, (long)microLong);
            microReader = rootReader.reader("microTZ");
            microReader.setPosition(1);
            long microLong2 = microReader.readLong();
            Assert.assertEquals((long)981173106123456L, (long)microLong2);
        }
    }

    @Test
    public void timeStampNanoWriters() throws Exception {
        long expectedNanos = 981173106123456789L;
        LocalDateTime expectedNanoDateTime = LocalDateTime.of(2001, 2, 3, 4, 5, 6, 123456789);
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            TimeStampNanoWriter timeStampNanoWriter = rootWriter.timeStampNano("nano");
            timeStampNanoWriter.setPosition(0);
            timeStampNanoWriter.writeTimeStampNano(981173106123456789L);
            String tz = "UTC";
            TimeStampNanoTZWriter timeStampNanoWriter2 = rootWriter.timeStampNanoTZ("nanoTZ", tz);
            timeStampNanoWriter2.setPosition(0);
            timeStampNanoWriter2.writeTimeStampNanoTZ(981173106123456789L);
            List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
            this.checkTimestampField((Field)children.get(0), "nano");
            this.checkTimestampTZField((Field)children.get(1), "nanoTZ", tz);
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            FieldReader nanoReader = rootReader.reader("nano");
            nanoReader.setPosition(0);
            LocalDateTime nanoDateTime = nanoReader.readLocalDateTime();
            Assert.assertEquals((Object)expectedNanoDateTime, (Object)nanoDateTime);
            long nanoLong = nanoReader.readLong();
            Assert.assertEquals((long)981173106123456789L, (long)nanoLong);
            nanoReader = rootReader.reader("nanoTZ");
            nanoReader.setPosition(0);
            long nanoLong2 = nanoReader.readLong();
            Assert.assertEquals((long)981173106123456789L, (long)nanoLong2);
            NullableTimeStampNanoTZHolder h = new NullableTimeStampNanoTZHolder();
            nanoReader.read(h);
            Assert.assertEquals((long)981173106123456789L, (long)h.value);
        }
    }

    @Test
    public void fixedSizeBinaryWriters() throws Exception {
        int numValues = 10;
        int byteWidth = 9;
        byte[][] values = new byte[numValues][byteWidth];
        for (int i = 0; i < numValues; ++i) {
            for (int j = 0; j < byteWidth; ++j) {
                values[i][j] = (byte)i;
            }
        }
        ArrowBuf[] bufs = new ArrowBuf[numValues];
        for (int i = 0; i < numValues; ++i) {
            bufs[i] = this.allocator.buffer((long)byteWidth);
            bufs[i].setBytes(0L, values[i]);
        }
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            String fieldName = "fixedSizeBinary";
            FixedSizeBinaryWriter fixedSizeBinaryWriter = rootWriter.fixedSizeBinary(fieldName, byteWidth);
            for (int i = 0; i < numValues; ++i) {
                fixedSizeBinaryWriter.setPosition(i);
                fixedSizeBinaryWriter.writeFixedSizeBinary(bufs[i]);
            }
            List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
            Assert.assertEquals((Object)fieldName, (Object)((Field)children.get(0)).getName());
            Assert.assertEquals((Object)ArrowType.FixedSizeBinary.TYPE_TYPE, (Object)((Field)children.get(0)).getType().getTypeID());
            FieldReader rootReader = new SingleStructReaderImpl(parent).reader("root");
            FieldReader fixedSizeBinaryReader = rootReader.reader(fieldName);
            for (int i = 0; i < numValues; ++i) {
                fixedSizeBinaryReader.setPosition(i);
                byte[] readValues = fixedSizeBinaryReader.readByteArray();
                Assert.assertArrayEquals((byte[])values[i], (byte[])readValues);
            }
        }
        AutoCloseables.close((AutoCloseable[])bufs);
    }

    @Test
    public void complexCopierWithList() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
            BaseWriter.ListWriter listWriter = rootWriter.list("list");
            BaseWriter.StructWriter innerStructWriter = listWriter.struct();
            IntWriter outerIntWriter = listWriter.integer();
            rootWriter.start();
            listWriter.startList();
            outerIntWriter.writeInt(1);
            outerIntWriter.writeInt(2);
            innerStructWriter.start();
            IntWriter intWriter = innerStructWriter.integer("a");
            intWriter.writeInt(1);
            innerStructWriter.end();
            innerStructWriter.start();
            intWriter = innerStructWriter.integer("a");
            intWriter.writeInt(2);
            innerStructWriter.end();
            listWriter.endList();
            rootWriter.end();
            writer.setValueCount(1);
            StructVector structVector = (StructVector)parent.getChild("root");
            TransferPair tp = structVector.getTransferPair(this.allocator);
            tp.splitAndTransfer(0, 1);
            NonNullableStructVector toStructVector = (NonNullableStructVector)tp.getTo();
            JsonStringHashMap toMapValue = (JsonStringHashMap)toStructVector.getObject(0);
            JsonStringArrayList object = (JsonStringArrayList)toMapValue.get((Object)"list");
            Assert.assertEquals((Object)1, (Object)object.get(0));
            Assert.assertEquals((Object)2, (Object)object.get(1));
            JsonStringHashMap innerStruct = (JsonStringHashMap)object.get(2);
            Assert.assertEquals((Object)1, (Object)innerStruct.get((Object)"a"));
            innerStruct = (JsonStringHashMap)object.get(3);
            Assert.assertEquals((Object)2, (Object)innerStruct.get((Object)"a"));
            toStructVector.close();
        }
    }

    @Test
    public void testSingleStructWriter1() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            SingleStructWriter singleStructWriter = new SingleStructWriter(parent);
            int initialCapacity = 1024;
            singleStructWriter.setInitialCapacity(initialCapacity);
            IntWriter intWriter = singleStructWriter.integer("intField");
            BigIntWriter bigIntWriter = singleStructWriter.bigInt("bigIntField");
            Float4Writer float4Writer = singleStructWriter.float4("float4Field");
            Float8Writer float8Writer = singleStructWriter.float8("float8Field");
            BaseWriter.ListWriter listWriter = singleStructWriter.list("listField");
            BaseWriter.MapWriter mapWriter = singleStructWriter.map("mapField", false);
            int intValue = 100;
            long bigIntValue = 10000L;
            float float4Value = 100.5f;
            double float8Value = 100.375;
            for (int i = 0; i < initialCapacity; ++i) {
                singleStructWriter.start();
                intWriter.writeInt(intValue + i);
                bigIntWriter.writeBigInt(bigIntValue + (long)i);
                float4Writer.writeFloat4(float4Value + (float)i);
                float8Writer.writeFloat8(float8Value + (double)i);
                listWriter.setPosition(i);
                listWriter.startList();
                listWriter.integer().writeInt(intValue + i);
                listWriter.integer().writeInt(intValue + i + 1);
                listWriter.integer().writeInt(intValue + i + 2);
                listWriter.integer().writeInt(intValue + i + 3);
                listWriter.endList();
                mapWriter.setPosition(i);
                mapWriter.startMap();
                mapWriter.startEntry();
                mapWriter.key().integer().writeInt(intValue + i);
                mapWriter.value().integer().writeInt(intValue + i + 1);
                mapWriter.endEntry();
                mapWriter.startEntry();
                mapWriter.key().integer().writeInt(intValue + i + 2);
                mapWriter.value().integer().writeInt(intValue + i + 3);
                mapWriter.endEntry();
                mapWriter.endMap();
                singleStructWriter.end();
            }
            IntVector intVector = (IntVector)parent.getChild("intField");
            BigIntVector bigIntVector = (BigIntVector)parent.getChild("bigIntField");
            Float4Vector float4Vector = (Float4Vector)parent.getChild("float4Field");
            Float8Vector float8Vector = (Float8Vector)parent.getChild("float8Field");
            int capacity = singleStructWriter.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity && capacity < initialCapacity * 2 ? 1 : 0) != 0);
            capacity = intVector.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity && capacity < initialCapacity * 2 ? 1 : 0) != 0);
            capacity = bigIntVector.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity && capacity < initialCapacity * 2 ? 1 : 0) != 0);
            capacity = float4Vector.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity && capacity < initialCapacity * 2 ? 1 : 0) != 0);
            capacity = float8Vector.getValueCapacity();
            Assert.assertTrue((capacity >= initialCapacity && capacity < initialCapacity * 2 ? 1 : 0) != 0);
            SingleStructReaderImpl singleStructReader = new SingleStructReaderImpl(parent);
            FieldReader intReader = singleStructReader.reader("intField");
            FieldReader bigIntReader = singleStructReader.reader("bigIntField");
            FieldReader float4Reader = singleStructReader.reader("float4Field");
            FieldReader float8Reader = singleStructReader.reader("float8Field");
            UnionListReader listReader = (UnionListReader)singleStructReader.reader("listField");
            UnionMapReader mapReader = (UnionMapReader)singleStructReader.reader("mapField");
            for (int i = 0; i < initialCapacity; ++i) {
                intReader.setPosition(i);
                bigIntReader.setPosition(i);
                float4Reader.setPosition(i);
                float8Reader.setPosition(i);
                listReader.setPosition(i);
                mapReader.setPosition(i);
                Assert.assertEquals((long)(intValue + i), (long)intReader.readInteger().intValue());
                Assert.assertEquals((long)(bigIntValue + (long)i), (long)bigIntReader.readLong());
                Assert.assertEquals((float)(float4Value + (float)i), (float)float4Reader.readFloat().floatValue(), (float)0.0f);
                Assert.assertEquals((double)(float8Value + (double)i), (double)float8Reader.readDouble(), (double)0.0);
                for (int j = 0; j < 4; ++j) {
                    listReader.next();
                    Assert.assertEquals((long)(intValue + i + j), (long)listReader.reader().readInteger().intValue());
                }
                for (int k = 0; k < 4; k += 2) {
                    mapReader.next();
                    Assert.assertEquals((long)(intValue + k + i), (long)mapReader.key().readInteger().intValue());
                    Assert.assertEquals((long)(intValue + k + i + 1), (long)mapReader.value().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void testListWriterWithNulls() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            listVector.setInitialCapacity(100);
            listVector.allocateNew();
            listVector.getValidityBuffer().setOne(0, (int)listVector.getValidityBuffer().capacity());
            UnionListWriter listWriter = listVector.getWriter();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.startList();
                    if (i % 4 == 0) {
                        listWriter.integer().writeNull();
                    } else {
                        listWriter.integer().writeInt(i);
                        listWriter.integer().writeInt(i * 2);
                    }
                    listWriter.endList();
                    continue;
                }
                listWriter.writeNull();
            }
            listVector.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)listReader.isSet());
                    listReader.next();
                    if (i % 4 == 0) {
                        Assert.assertNull((Object)listReader.reader().readInteger());
                        continue;
                    }
                    Assert.assertEquals((long)i, (long)listReader.reader().readInteger().intValue());
                    listReader.next();
                    Assert.assertEquals((long)(i * 2), (long)listReader.reader().readInteger().intValue());
                    continue;
                }
                Assert.assertFalse((boolean)listReader.isSet());
            }
        }
    }

    @Test
    public void testListOfListWriterWithNulls() {
        try (ListVector listVector = ListVector.empty((String)"listoflist", (BufferAllocator)this.allocator);){
            listVector.setInitialCapacity(100);
            listVector.allocateNew();
            listVector.getValidityBuffer().setOne(0, (int)listVector.getValidityBuffer().capacity());
            UnionListWriter listWriter = listVector.getWriter();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 2 == 0) {
                    listWriter.startList();
                    if (i % 4 == 0) {
                        listWriter.list().writeNull();
                    } else {
                        listWriter.list().startList();
                        listWriter.list().integer().writeNull();
                        listWriter.list().integer().writeInt(i);
                        listWriter.list().integer().writeInt(i * 2);
                        listWriter.list().endList();
                    }
                    listWriter.endList();
                    continue;
                }
                listWriter.writeNull();
            }
            listVector.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)listReader.isSet());
                    listReader.next();
                    if (i % 4 == 0) {
                        Assert.assertFalse((boolean)listReader.reader().isSet());
                        continue;
                    }
                    listReader.reader().next();
                    Assert.assertFalse((boolean)listReader.reader().reader().isSet());
                    listReader.reader().next();
                    Assert.assertEquals((long)i, (long)listReader.reader().reader().readInteger().intValue());
                    listReader.reader().next();
                    Assert.assertEquals((long)(i * 2), (long)listReader.reader().reader().readInteger().intValue());
                    continue;
                }
                Assert.assertFalse((boolean)listReader.isSet());
            }
        }
    }

    @Test
    public void testListOfListOfListWriterWithNulls() {
        try (ListVector listVector = ListVector.empty((String)"listoflistoflist", (BufferAllocator)this.allocator);){
            listVector.setInitialCapacity(100);
            listVector.allocateNew();
            listVector.getValidityBuffer().setOne(0, (int)listVector.getValidityBuffer().capacity());
            UnionListWriter listWriter = listVector.getWriter();
            for (int i = 0; i < 100; ++i) {
                listWriter.setPosition(i);
                if (i % 4 == 0) {
                    listWriter.writeNull();
                    continue;
                }
                listWriter.startList();
                if (i % 4 == 1) {
                    listWriter.list().writeNull();
                } else if (i % 4 == 2) {
                    listWriter.list().startList();
                    listWriter.list().list().writeNull();
                    listWriter.list().endList();
                } else {
                    listWriter.list().startList();
                    listWriter.list().list().startList();
                    listWriter.list().list().integer().writeNull();
                    listWriter.list().list().integer().writeInt(i);
                    listWriter.list().list().integer().writeInt(i * 2);
                    listWriter.list().list().endList();
                    listWriter.list().endList();
                }
                listWriter.endList();
            }
            listVector.setValueCount(100);
            UnionListReader listReader = new UnionListReader(listVector);
            for (int i = 0; i < 100; ++i) {
                listReader.setPosition(i);
                if (i % 4 == 0) {
                    Assert.assertFalse((boolean)listReader.isSet());
                    continue;
                }
                Assert.assertTrue((boolean)listReader.isSet());
                listReader.next();
                if (i % 4 == 1) {
                    Assert.assertFalse((boolean)listReader.reader().isSet());
                    continue;
                }
                if (i % 4 == 2) {
                    listReader.reader().next();
                    Assert.assertFalse((boolean)listReader.reader().reader().isSet());
                    continue;
                }
                listReader.reader().next();
                listReader.reader().reader().next();
                Assert.assertFalse((boolean)listReader.reader().reader().reader().isSet());
                listReader.reader().reader().next();
                Assert.assertEquals((long)i, (long)listReader.reader().reader().reader().readInteger().intValue());
                listReader.reader().reader().next();
                Assert.assertEquals((long)(i * 2), (long)listReader.reader().reader().reader().readInteger().intValue());
            }
        }
    }

    @Test
    public void testStructOfList() {
        int size;
        FieldReader childListReader;
        NullableStructWriter structWriter2;
        try (StructVector structVector = StructVector.empty((String)"struct1", (BufferAllocator)this.allocator);){
            structVector.addOrGetList("childList1");
            NullableStructReaderImpl structReader = structVector.getReader();
            FieldReader childListReader2 = structReader.reader("childList1");
            Assert.assertNotNull((Object)childListReader2);
        }
        structVector = StructVector.empty((String)"struct2", (BufferAllocator)this.allocator);
        var2_2 = null;
        try {
            structVector.addOrGetList("childList2");
            structWriter2 = structVector.getWriter();
            structWriter2.start();
            BaseWriter.ListWriter listWriter = structWriter2.list("childList2");
            listWriter.startList();
            listWriter.integer().writeInt(10);
            listWriter.endList();
            structWriter2.end();
            NullableStructReaderImpl structReader = structVector.getReader();
            FieldReader childListReader3 = structReader.reader("childList2");
            int size2 = childListReader3.size();
            Assert.assertEquals((long)1L, (long)size2);
            int data = childListReader3.reader().readInteger();
            Assert.assertEquals((long)10L, (long)data);
        }
        catch (Throwable structWriter2) {
            var2_2 = structWriter2;
            throw structWriter2;
        }
        finally {
            if (structVector != null) {
                TestComplexWriter.$closeResource(var2_2, (AutoCloseable)structVector);
            }
        }
        structVector = StructVector.empty((String)"struct3", (BufferAllocator)this.allocator);
        var2_2 = null;
        try {
            structVector.addOrGetList("childList3");
            structWriter2 = structVector.getWriter();
            for (int i = 0; i < 5; ++i) {
                structWriter2.setPosition(i);
                structWriter2.start();
                BaseWriter.ListWriter listWriter = structWriter2.list("childList3");
                listWriter.startList();
                listWriter.integer().writeInt(i);
                listWriter.endList();
                structWriter2.end();
            }
            NullableStructReaderImpl structReader = structVector.getReader();
            structReader.setPosition(3);
            childListReader = structReader.reader("childList3");
            size = childListReader.size();
            Assert.assertEquals((long)1L, (long)size);
            int data = (Integer)((List)childListReader.readObject()).get(0);
            Assert.assertEquals((long)3L, (long)data);
        }
        catch (Throwable structWriter3) {
            var2_2 = structWriter3;
            throw structWriter3;
        }
        finally {
            if (structVector != null) {
                TestComplexWriter.$closeResource(var2_2, (AutoCloseable)structVector);
            }
        }
        structVector = StructVector.empty((String)"struct4", (BufferAllocator)this.allocator);
        var2_2 = null;
        try {
            structVector.addOrGetList("childList4");
            structWriter2 = structVector.getWriter();
            for (int i = 0; i < 5; ++i) {
                structWriter2.setPosition(i);
                structWriter2.start();
                structWriter2.writeNull();
                structWriter2.end();
            }
            NullableStructReaderImpl structReader = structVector.getReader();
            structReader.setPosition(3);
            childListReader = structReader.reader("childList4");
            size = childListReader.size();
            Assert.assertEquals((long)0L, (long)size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (structVector != null) {
                TestComplexWriter.$closeResource(var2_2, (AutoCloseable)structVector);
            }
        }
    }

    @Test
    public void testMap() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter mapWriter = writer.rootAsMap(false);
            for (int i = 0; i < 100; ++i) {
                mapWriter.startMap();
                for (int j = 0; j < i % 7; ++j) {
                    mapWriter.startEntry();
                    if (j % 2 == 0) {
                        mapWriter.key().integer().writeInt(j);
                        mapWriter.value().integer().writeInt(j + 1);
                    } else {
                        IntHolder keyHolder = new IntHolder();
                        keyHolder.value = j;
                        IntHolder valueHolder = new IntHolder();
                        valueHolder.value = j + 1;
                        mapWriter.key().integer().write(keyHolder);
                        mapWriter.value().integer().write(valueHolder);
                    }
                    mapWriter.endEntry();
                }
                mapWriter.endMap();
            }
            writer.setValueCount(100);
            UnionMapReader mapReader = (UnionMapReader)new SingleStructReaderImpl(parent).reader("root");
            for (int i = 0; i < 100; ++i) {
                mapReader.setPosition(i);
                for (int j = 0; j < i % 7; ++j) {
                    mapReader.next();
                    Assert.assertEquals((long)j, (long)mapReader.key().readInteger().intValue());
                    Assert.assertEquals((long)(j + 1), (long)mapReader.value().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void testMapWithNulls() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter mapWriter = writer.rootAsMap(false);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().integer().writeNull();
            mapWriter.value().integer().writeInt(1);
            mapWriter.endEntry();
            mapWriter.endMap();
            writer.setValueCount(1);
            UnionMapReader mapReader = (UnionMapReader)new SingleStructReaderImpl(parent).reader("root");
            Assert.assertNull((Object)mapReader.key().readInteger());
            Assert.assertEquals((long)1L, (long)mapReader.value().readInteger().intValue());
        }
    }

    @Test
    public void testMapWithListKey() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter mapWriter = writer.rootAsMap(false);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().list().startList();
            for (int i = 0; i < 3; ++i) {
                mapWriter.key().list().integer().writeInt(i);
            }
            mapWriter.key().list().endList();
            mapWriter.value().integer().writeInt(1);
            mapWriter.endEntry();
            mapWriter.endMap();
            writer.setValueCount(1);
            UnionMapReader mapReader = (UnionMapReader)new SingleStructReaderImpl(parent).reader("root");
            mapReader.key().next();
            Assert.assertEquals((long)0L, (long)mapReader.key().reader().readInteger().intValue());
            mapReader.key().next();
            Assert.assertEquals((long)1L, (long)mapReader.key().reader().readInteger().intValue());
            mapReader.key().next();
            Assert.assertEquals((long)2L, (long)mapReader.key().reader().readInteger().intValue());
            Assert.assertEquals((long)1L, (long)mapReader.value().readInteger().intValue());
        }
    }

    @Test
    public void testMapWithStructKey() {
        try (NonNullableStructVector parent = NonNullableStructVector.empty((String)"parent", (BufferAllocator)this.allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter mapWriter = writer.rootAsMap(false);
            mapWriter.startMap();
            mapWriter.startEntry();
            mapWriter.key().struct().start();
            mapWriter.key().struct().integer("value1").writeInt(1);
            mapWriter.key().struct().integer("value2").writeInt(2);
            mapWriter.key().struct().end();
            mapWriter.value().integer().writeInt(1);
            mapWriter.endEntry();
            mapWriter.endMap();
            writer.setValueCount(1);
            UnionMapReader mapReader = (UnionMapReader)new SingleStructReaderImpl(parent).reader("root");
            Assert.assertEquals((long)1L, (long)mapReader.key().reader("value1").readInteger().intValue());
            Assert.assertEquals((long)2L, (long)mapReader.key().reader("value2").readInteger().intValue());
            Assert.assertEquals((long)1L, (long)mapReader.value().readInteger().intValue());
        }
    }
}

