/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.HashMap;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestSplitAndTransfer {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    private void populateVarcharVector(VarCharVector vector, int valueCount, String[] compareArray) {
        for (int i = 0; i < valueCount; i += 3) {
            String s = String.format("%010d", i);
            vector.set(i, s.getBytes());
            if (compareArray == null) continue;
            compareArray[i] = s;
        }
        vector.setValueCount(valueCount);
    }

    @Test
    public void test() throws Exception {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);){
            int[][] startLengths;
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            String[] compareArray = new String[500];
            this.populateVarcharVector(varCharVector, 500, compareArray);
            TransferPair tp = varCharVector.getTransferPair(this.allocator);
            VarCharVector newVarCharVector = (VarCharVector)tp.getTo();
            for (int[] startLength : startLengths = new int[][]{{0, 201}, {201, 0}, {201, 200}, {401, 99}}) {
                int start = startLength[0];
                int length = startLength[1];
                tp.splitAndTransfer(start, length);
                for (int i = 0; i < length; ++i) {
                    boolean expectedSet;
                    boolean bl = expectedSet = (start + i) % 3 == 0;
                    if (expectedSet) {
                        byte[] expectedValue = compareArray[start + i].getBytes();
                        Assert.assertFalse((boolean)newVarCharVector.isNull(i));
                        Assert.assertArrayEquals((byte[])expectedValue, (byte[])newVarCharVector.get(i));
                        continue;
                    }
                    Assert.assertTrue((boolean)newVarCharVector.isNull(i));
                }
                newVarCharVector.clear();
            }
        }
    }

    @Test
    public void testMemoryConstrainedTransfer() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);){
            int[][] startLengths;
            this.allocator.setLimit(32768L);
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 1000;
            this.populateVarcharVector(varCharVector, 1000, null);
            TransferPair tp = varCharVector.getTransferPair(this.allocator);
            VarCharVector newVarCharVector = (VarCharVector)tp.getTo();
            for (int[] startLength : startLengths = new int[][]{{0, 700}, {700, 299}}) {
                int start = startLength[0];
                int length = startLength[1];
                tp.splitAndTransfer(start, length);
                newVarCharVector.clear();
            }
        }
    }

    @Test
    public void testTransfer() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            String[] compareArray = new String[500];
            this.populateVarcharVector(varCharVector, 500, compareArray);
            TransferPair tp = varCharVector.getTransferPair(this.allocator);
            VarCharVector newVarCharVector = (VarCharVector)tp.getTo();
            tp.transfer();
            Assert.assertEquals((long)0L, (long)varCharVector.valueCount);
            Assert.assertEquals((long)500L, (long)newVarCharVector.valueCount);
            for (int i = 0; i < 500; ++i) {
                boolean expectedSet;
                boolean bl = expectedSet = i % 3 == 0;
                if (expectedSet) {
                    byte[] expectedValue = compareArray[i].getBytes();
                    Assert.assertFalse((boolean)newVarCharVector.isNull(i));
                    Assert.assertArrayEquals((byte[])expectedValue, (byte[])newVarCharVector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)newVarCharVector.isNull(i));
            }
            newVarCharVector.clear();
        }
    }

    @Test
    public void testCopyValueSafe() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);
             VarCharVector newVarCharVector = new VarCharVector("newvector", this.allocator);){
            int i;
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.makeTransferPair((ValueVector)newVarCharVector);
            for (i = 0; i < 500; ++i) {
                tp.copyValueSafe(i, i);
            }
            newVarCharVector.setValueCount(500);
            for (i = 0; i < 500; ++i) {
                boolean expectedSet;
                boolean bl = expectedSet = i % 3 == 0;
                if (expectedSet) {
                    Assert.assertFalse((boolean)varCharVector.isNull(i));
                    Assert.assertFalse((boolean)newVarCharVector.isNull(i));
                    Assert.assertArrayEquals((byte[])varCharVector.get(i), (byte[])newVarCharVector.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)newVarCharVector.isNull(i));
            }
        }
    }

    @Test
    public void testSplitAndTransferNon() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.getTransferPair(this.allocator);
            VarCharVector newVarCharVector = (VarCharVector)tp.getTo();
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newVarCharVector.getValueCount());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testSplitAndTransferAll() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.getTransferPair(this.allocator);
            VarCharVector newVarCharVector = (VarCharVector)tp.getTo();
            tp.splitAndTransfer(0, 500);
            Assert.assertEquals((long)500L, (long)newVarCharVector.getValueCount());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testInvalidStartIndex() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);
             VarCharVector newVarCharVector = new VarCharVector("newvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.makeTransferPair((ValueVector)newVarCharVector);
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> tp.splitAndTransfer(500, 10));
            Assert.assertEquals((Object)"Invalid parameters startIndex: 500, length: 10 for valueCount: 500", (Object)e.getMessage());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testInvalidLength() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);
             VarCharVector newVarCharVector = new VarCharVector("newvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.makeTransferPair((ValueVector)newVarCharVector);
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> tp.splitAndTransfer(0, 1000));
            Assert.assertEquals((Object)"Invalid parameters startIndex: 0, length: 1000 for valueCount: 500", (Object)e.getMessage());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testZeroStartIndexAndLength() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);
             VarCharVector newVarCharVector = new VarCharVector("newvector", this.allocator);){
            varCharVector.allocateNew(0L, 0);
            boolean valueCount = false;
            this.populateVarcharVector(varCharVector, 0, null);
            TransferPair tp = varCharVector.makeTransferPair((ValueVector)newVarCharVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newVarCharVector.getValueCount());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testZeroLength() {
        try (VarCharVector varCharVector = new VarCharVector("myvector", this.allocator);
             VarCharVector newVarCharVector = new VarCharVector("newvector", this.allocator);){
            varCharVector.allocateNew(10000L, 1000);
            int valueCount = 500;
            this.populateVarcharVector(varCharVector, 500, null);
            TransferPair tp = varCharVector.makeTransferPair((ValueVector)newVarCharVector);
            tp.splitAndTransfer(500, 0);
            Assert.assertEquals((long)0L, (long)newVarCharVector.getValueCount());
            newVarCharVector.clear();
        }
    }

    @Test
    public void testUnionVectorZeroStartIndexAndLength() {
        try (UnionVector unionVector = UnionVector.empty((String)"myvector", (BufferAllocator)this.allocator);
             UnionVector newUnionVector = UnionVector.empty((String)"newvector", (BufferAllocator)this.allocator);){
            unionVector.allocateNew();
            boolean valueCount = false;
            unionVector.setValueCount(0);
            TransferPair tp = unionVector.makeTransferPair((ValueVector)newUnionVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newUnionVector.getValueCount());
            newUnionVector.clear();
        }
    }

    @Test
    public void testFixedWidthVectorZeroStartIndexAndLength() {
        try (IntVector intVector = new IntVector("myvector", this.allocator);
             IntVector newIntVector = new IntVector("newvector", this.allocator);){
            intVector.allocateNew(0);
            boolean valueCount = false;
            intVector.setValueCount(0);
            TransferPair tp = intVector.makeTransferPair((ValueVector)newIntVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newIntVector.getValueCount());
            newIntVector.clear();
        }
    }

    @Test
    public void testBitVectorZeroStartIndexAndLength() {
        try (BitVector bitVector = new BitVector("myvector", this.allocator);
             BitVector newBitVector = new BitVector("newvector", this.allocator);){
            bitVector.allocateNew(0);
            boolean valueCount = false;
            bitVector.setValueCount(0);
            TransferPair tp = bitVector.makeTransferPair((ValueVector)newBitVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newBitVector.getValueCount());
            newBitVector.clear();
        }
    }

    @Test
    public void testFixedSizeListVectorZeroStartIndexAndLength() {
        try (FixedSizeListVector listVector = FixedSizeListVector.empty((String)"list", (int)4, (BufferAllocator)this.allocator);
             FixedSizeListVector newListVector = FixedSizeListVector.empty((String)"newList", (int)4, (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            boolean valueCount = false;
            listVector.setValueCount(0);
            TransferPair tp = listVector.makeTransferPair((ValueVector)newListVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newListVector.getValueCount());
            newListVector.clear();
        }
    }

    @Test
    public void testListVectorZeroStartIndexAndLength() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector newListVector = ListVector.empty((String)"newList", (BufferAllocator)this.allocator);){
            listVector.allocateNew();
            boolean valueCount = false;
            listVector.setValueCount(0);
            TransferPair tp = listVector.makeTransferPair((ValueVector)newListVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newListVector.getValueCount());
            newListVector.clear();
        }
    }

    @Test
    public void testStructVectorZeroStartIndexAndLength() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        try (StructVector structVector = new StructVector("structvec", this.allocator, type, null);
             StructVector newStructVector = new StructVector("newStructvec", this.allocator, type, null);){
            structVector.allocateNew();
            boolean valueCount = false;
            structVector.setValueCount(0);
            TransferPair tp = structVector.makeTransferPair((ValueVector)newStructVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newStructVector.getValueCount());
            newStructVector.clear();
        }
    }

    @Test
    public void testMapVectorZeroStartIndexAndLength() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)new ArrowType.Map(false), null, metadata);
        try (MapVector mapVector = new MapVector("mapVec", this.allocator, type, null);
             MapVector newMapVector = new MapVector("newMapVec", this.allocator, type, null);){
            mapVector.allocateNew();
            boolean valueCount = false;
            mapVector.setValueCount(0);
            TransferPair tp = mapVector.makeTransferPair((ValueVector)newMapVector);
            tp.splitAndTransfer(0, 0);
            Assert.assertEquals((long)0L, (long)newMapVector.getValueCount());
            newMapVector.clear();
        }
    }
}

