/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListReader;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestFixedSizeListVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testIntType() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);){
            IntVector nested = (IntVector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                vector.setNotNull(i);
                nested.set(i * 2, i);
                nested.set(i * 2 + 1, i + 10);
            }
            vector.setValueCount(10);
            UnionFixedSizeListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                Assert.assertTrue((boolean)reader.isSet());
                Assert.assertTrue((boolean)reader.next());
                Assert.assertEquals((long)i, (long)reader.reader().readInteger().intValue());
                Assert.assertTrue((boolean)reader.next());
                Assert.assertEquals((long)(i + 10), (long)reader.reader().readInteger().intValue());
                Assert.assertFalse((boolean)reader.next());
                Assert.assertEquals(Arrays.asList(i, i + 10), (Object)reader.readObject());
            }
        }
    }

    @Test
    public void testFloatTypeNullable() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);){
            Float4Vector nested = (Float4Vector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                vector.setNotNull(i);
                nested.set(i * 2, (float)i + 0.1f);
                nested.set(i * 2 + 1, (float)i + 10.1f);
            }
            vector.setValueCount(10);
            UnionFixedSizeListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)reader.isSet());
                    Assert.assertTrue((boolean)reader.next());
                    Assert.assertEquals((double)((float)i + 0.1f), (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
                    Assert.assertTrue((boolean)reader.next());
                    Assert.assertEquals((double)((float)i + 10.1f), (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
                    Assert.assertFalse((boolean)reader.next());
                    Assert.assertEquals(Arrays.asList(Float.valueOf((float)i + 0.1f), Float.valueOf((float)i + 10.1f)), (Object)reader.readObject());
                    continue;
                }
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }

    @Test
    public void testNestedInList() {
        try (ListVector vector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            int j;
            FixedSizeListVector tuples = (FixedSizeListVector)vector.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2))).getVector();
            IntVector innerVector = (IntVector)tuples.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                int position = vector.startNewValue(i);
                for (j = 0; j < i % 7; ++j) {
                    tuples.setNotNull(position + j);
                    innerVector.set((position + j) * 2, j);
                    innerVector.set((position + j) * 2 + 1, j + 1);
                }
                vector.endValue(i, i % 7);
            }
            vector.setValueCount(10);
            UnionListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                if (i % 2 == 0) {
                    for (j = 0; j < i % 7; ++j) {
                        Assert.assertTrue((boolean)reader.next());
                        FieldReader innerListReader = reader.reader();
                        for (int k = 0; k < 2; ++k) {
                            Assert.assertTrue((boolean)innerListReader.next());
                            Assert.assertEquals((long)(k + j), (long)innerListReader.reader().readInteger().intValue());
                        }
                        Assert.assertFalse((boolean)innerListReader.next());
                    }
                    Assert.assertFalse((boolean)reader.next());
                    continue;
                }
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }

    @Test
    public void testTransferPair() {
        try (FixedSizeListVector from = new FixedSizeListVector("from", this.allocator, new FieldType(true, (ArrowType)new ArrowType.FixedSizeList(2), null), null);
             FixedSizeListVector to = new FixedSizeListVector("to", this.allocator, new FieldType(true, (ArrowType)new ArrowType.FixedSizeList(2), null), null);){
            Float4Vector nested = (Float4Vector)from.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
            from.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                from.setNotNull(i);
                nested.set(i * 2, (float)i + 0.1f);
                nested.set(i * 2 + 1, (float)i + 10.1f);
            }
            from.setValueCount(10);
            TransferPair pair = from.makeTransferPair((ValueVector)to);
            pair.copyValueSafe(0, 1);
            pair.copyValueSafe(2, 2);
            to.copyFromSafe(4, 3, (ValueVector)from);
            to.setValueCount(10);
            UnionFixedSizeListReader reader = to.getReader();
            reader.setPosition(0);
            Assert.assertFalse((boolean)reader.isSet());
            Assert.assertNull((Object)reader.readObject());
            reader.setPosition(1);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)0.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)10.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals(Arrays.asList(Float.valueOf(0.1f), Float.valueOf(10.1f)), (Object)reader.readObject());
            reader.setPosition(2);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)2.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)12.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals(Arrays.asList(Float.valueOf(2.1f), Float.valueOf(12.1f)), (Object)reader.readObject());
            reader.setPosition(3);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)4.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)14.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals(Arrays.asList(Float.valueOf(4.1f), Float.valueOf(14.1f)), (Object)reader.readObject());
            for (int i = 4; i < 10; ++i) {
                reader.setPosition(i);
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }

    @Test
    public void testConsistentChildName() throws Exception {
        try (FixedSizeListVector listVector = FixedSizeListVector.empty((String)"sourceVector", (int)2, (BufferAllocator)this.allocator);){
            String emptyListStr = listVector.getField().toString();
            Assert.assertTrue((boolean)emptyListStr.contains("$data$"));
            listVector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            String emptyVectorStr = listVector.getField().toString();
            Assert.assertTrue((boolean)emptyVectorStr.contains("$data$"));
        }
    }

    @Test
    public void testUnionFixedSizeListWriterWithNulls() throws Exception {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            int i;
            UnionFixedSizeListWriter writer = vector.getWriter();
            writer.allocate();
            int valueCount = 100;
            for (i = 0; i < 100; ++i) {
                writer.startList();
                writer.decimal().writeDecimal(new BigDecimal(i));
                writer.writeNull();
                writer.decimal().writeDecimal(new BigDecimal(i * 3));
                writer.endList();
            }
            vector.setValueCount(100);
            for (i = 0; i < 100; ++i) {
                List values = vector.getObject(i);
                Assert.assertEquals((long)3L, (long)values.size());
                Assert.assertEquals((Object)new BigDecimal(i), values.get(0));
                Assert.assertEquals(null, values.get(1));
                Assert.assertEquals((Object)new BigDecimal(i * 3), values.get(2));
            }
        }
    }

    @Test
    public void testUnionFixedSizeListWriter() throws Exception {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            int[] values1 = new int[]{1, 2, 3};
            int[] values2 = new int[]{4, 5, 6};
            int[] values3 = new int[]{7, 8, 9};
            this.writeListVector(vector1, writer1, values1);
            this.writeListVector(vector1, writer1, values2);
            this.writeListVector(vector1, writer1, values3);
            writer1.setValueCount(3);
            Assert.assertEquals((long)3L, (long)vector1.getValueCount());
            int[] realValue1 = this.convertListToIntArray(vector1.getObject(0));
            Assert.assertTrue((boolean)Arrays.equals(values1, realValue1));
            int[] realValue2 = this.convertListToIntArray(vector1.getObject(1));
            Assert.assertTrue((boolean)Arrays.equals(values2, realValue2));
            int[] realValue3 = this.convertListToIntArray(vector1.getObject(2));
            Assert.assertTrue((boolean)Arrays.equals(values3, realValue3));
        }
    }

    @Test
    public void testWriteDecimal() throws Exception {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            int i;
            UnionFixedSizeListWriter writer = vector.getWriter();
            writer.allocate();
            int valueCount = 100;
            for (i = 0; i < 100; ++i) {
                writer.startList();
                writer.decimal().writeDecimal(new BigDecimal(i));
                writer.decimal().writeDecimal(new BigDecimal(i * 2));
                writer.decimal().writeDecimal(new BigDecimal(i * 3));
                writer.endList();
            }
            vector.setValueCount(100);
            for (i = 0; i < 100; ++i) {
                List values = vector.getObject(i);
                Assert.assertEquals((long)3L, (long)values.size());
                Assert.assertEquals((Object)new BigDecimal(i), values.get(0));
                Assert.assertEquals((Object)new BigDecimal(i * 2), values.get(1));
                Assert.assertEquals((Object)new BigDecimal(i * 3), values.get(2));
            }
        }
    }

    @Test
    public void testDecimalIndexCheck() throws Exception {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer = vector.getWriter();
            writer.allocate();
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
                writer.startList();
                writer.decimal().writeDecimal(new BigDecimal(1));
                writer.decimal().writeDecimal(new BigDecimal(2));
                writer.decimal().writeDecimal(new BigDecimal(3));
                writer.decimal().writeDecimal(new BigDecimal(4));
                writer.endList();
            });
            Assert.assertEquals((Object)"values at index 0 is greater than listSize 3", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteIllegalData() throws Exception {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            int[] values1 = new int[]{1, 2, 3};
            int[] values2 = new int[]{4, 5, 6, 7, 8};
            this.writeListVector(vector1, writer1, values1);
            this.writeListVector(vector1, writer1, values2);
            writer1.setValueCount(3);
            Assert.assertEquals((long)3L, (long)vector1.getValueCount());
            int[] realValue1 = this.convertListToIntArray(vector1.getObject(0));
            Assert.assertTrue((boolean)Arrays.equals(values1, realValue1));
            int[] realValue2 = this.convertListToIntArray(vector1.getObject(1));
            Assert.assertTrue((boolean)Arrays.equals(values2, realValue2));
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"vector", (int)3, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            int[] values1 = new int[]{1, 2, 3};
            int[] values2 = new int[]{4, 5, 6};
            int[] values3 = new int[]{7, 8, 9};
            this.writeListVector(vector1, writer1, values1);
            this.writeListVector(vector1, writer1, values2);
            this.writeListVector(vector1, writer1, values3);
            writer1.setValueCount(3);
            TransferPair transferPair = vector1.getTransferPair(this.allocator);
            transferPair.splitAndTransfer(0, 2);
            FixedSizeListVector targetVector = (FixedSizeListVector)transferPair.getTo();
            Assert.assertEquals((long)2L, (long)targetVector.getValueCount());
            int[] realValue1 = this.convertListToIntArray(targetVector.getObject(0));
            Assert.assertTrue((boolean)Arrays.equals(values1, realValue1));
            int[] realValue2 = this.convertListToIntArray(targetVector.getObject(1));
            Assert.assertTrue((boolean)Arrays.equals(values2, realValue2));
            targetVector.clear();
        }
    }

    @Test
    public void testZeroWidthVector() {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"vector", (int)0, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            int[] values1 = new int[]{};
            int[] values2 = new int[]{};
            int[] values3 = null;
            int[] values4 = new int[]{};
            this.writeListVector(vector1, writer1, values1);
            this.writeListVector(vector1, writer1, values2);
            this.writeListVector(vector1, writer1, values3);
            this.writeListVector(vector1, writer1, values4);
            writer1.setValueCount(4);
            Assert.assertEquals((long)4L, (long)vector1.getValueCount());
            int[] realValue1 = this.convertListToIntArray(vector1.getObject(0));
            Assert.assertArrayEquals((int[])values1, (int[])realValue1);
            int[] realValue2 = this.convertListToIntArray(vector1.getObject(1));
            Assert.assertArrayEquals((int[])values2, (int[])realValue2);
            Assertions.assertNull((Object)vector1.getObject(2));
            int[] realValue4 = this.convertListToIntArray(vector1.getObject(3));
            Assert.assertArrayEquals((int[])values4, (int[])realValue4);
        }
    }

    @Test
    public void testVectorWithNulls() {
        try (FixedSizeListVector vector1 = FixedSizeListVector.empty((String)"vector", (int)4, (BufferAllocator)this.allocator);){
            UnionFixedSizeListWriter writer1 = vector1.getWriter();
            writer1.allocate();
            List<Integer> values1 = Arrays.asList(null, 1, 2, 3);
            List<Integer> values2 = Arrays.asList(4, null, 5, 6);
            List<Integer> values3 = null;
            List<Integer> values4 = Arrays.asList(7, 8, null, 9);
            this.writeListVector(vector1, writer1, values1);
            this.writeListVector(vector1, writer1, values2);
            this.writeListVector(vector1, writer1, values3);
            this.writeListVector(vector1, writer1, values4);
            writer1.setValueCount(4);
            Assert.assertEquals((long)4L, (long)vector1.getValueCount());
            List realValue1 = vector1.getObject(0);
            Assert.assertEquals(values1, (Object)realValue1);
            List realValue2 = vector1.getObject(1);
            Assert.assertEquals(values2, (Object)realValue2);
            List realValue3 = vector1.getObject(2);
            Assert.assertEquals(values3, (Object)realValue3);
            List realValue4 = vector1.getObject(3);
            Assert.assertEquals(values4, (Object)realValue4);
        }
    }

    private int[] convertListToIntArray(List list) {
        int[] values = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            values[i] = (Integer)list.get(i);
        }
        return values;
    }

    private void writeListVector(FixedSizeListVector vector, UnionFixedSizeListWriter writer, int[] values) {
        writer.startList();
        if (values != null) {
            for (int v : values) {
                writer.integer().writeInt(v);
            }
        } else {
            vector.setNull(writer.getPosition());
        }
        writer.endList();
    }

    private void writeListVector(FixedSizeListVector vector, UnionFixedSizeListWriter writer, List<Integer> values) {
        writer.startList();
        if (values != null) {
            for (Integer v : values) {
                if (v == null) {
                    writer.writeNull();
                    continue;
                }
                writer.integer().writeInt(v.intValue());
            }
        } else {
            vector.setNull(writer.getPosition());
        }
        writer.endList();
    }
}

