/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestBitVectorHelper {
    @Test
    public void testGetNullCount() throws Exception {
        try (RootAllocator root = new RootAllocator();){
            ArrowBuf validityBuffer = root.buffer(3L);
            validityBuffer.setByte(0L, 22);
            int count = BitVectorHelper.getNullCount((ArrowBuf)validityBuffer, (int)3);
            Assert.assertEquals((long)count, (long)1L);
            validityBuffer.close();
            validityBuffer = root.buffer(8L);
            validityBuffer.setByte(0L, 255);
            count = BitVectorHelper.getNullCount((ArrowBuf)validityBuffer, (int)8);
            Assert.assertEquals((long)count, (long)0L);
            validityBuffer.close();
            validityBuffer = root.buffer(8L);
            validityBuffer.setByte(0L, 127);
            count = BitVectorHelper.getNullCount((ArrowBuf)validityBuffer, (int)8);
            Assert.assertEquals((long)count, (long)1L);
            validityBuffer.close();
            validityBuffer = root.buffer(11L);
            validityBuffer.setByte(0L, 170);
            validityBuffer.setByte(1L, 85);
            count = BitVectorHelper.getNullCount((ArrowBuf)validityBuffer, (int)11);
            Assert.assertEquals((long)count, (long)5L);
            validityBuffer.close();
        }
    }

    @Test
    public void testAllBitsNull() {
        int bufferLength = 32768;
        try (RootAllocator allocator = new RootAllocator(32768L);
             ArrowBuf validityBuffer = allocator.buffer(32768L);){
            validityBuffer.setZero(0L, 32768L);
            int bitLength = 1024;
            Assert.assertTrue((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            bitLength = 1027;
            Assert.assertTrue((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            validityBuffer.setZero(0L, 32768L);
            bitLength = 1025;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)12L);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            validityBuffer.setZero(0L, 32768L);
            bitLength = 1025;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)1024L);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            validityBuffer.setZero(0L, 32768L);
            bitLength = 1026;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)1024L);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            validityBuffer.setZero(0L, 32768L);
            bitLength = 1027;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)1025L);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
            validityBuffer.setZero(0L, 32768L);
            bitLength = 1031;
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)1029L);
            BitVectorHelper.setBit((ArrowBuf)validityBuffer, (long)1030L);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)false));
        }
    }

    @Test
    public void testAllBitsSet() {
        int bufferLength = 32768;
        try (RootAllocator allocator = new RootAllocator(32768L);
             ArrowBuf validityBuffer = allocator.buffer(32768L);){
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            int bitLength = 1024;
            Assert.assertTrue((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            bitLength = 1028;
            Assert.assertTrue((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            bitLength = 1025;
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)12);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            bitLength = 1025;
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)1024);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            bitLength = 1026;
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)1024);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            bitLength = 1027;
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)1025);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
            MemoryUtil.UNSAFE.setMemory(validityBuffer.memoryAddress(), 32768L, (byte)-1);
            bitLength = 1031;
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)1029);
            BitVectorHelper.unsetBit((ArrowBuf)validityBuffer, (int)1030);
            Assertions.assertFalse((boolean)BitVectorHelper.checkAllBitsEqualTo((ArrowBuf)validityBuffer, (int)bitLength, (boolean)true));
        }
    }

    @Test
    public void testConcatBits() {
        try (RootAllocator allocator = new RootAllocator(0x100000L);
             ArrowBuf buf1 = allocator.buffer(1024L);
             ArrowBuf buf2 = allocator.buffer(1024L);
             ArrowBuf output = allocator.buffer(1024L);){
            buf1.setZero(0L, buf1.capacity());
            buf2.setZero(0L, buf2.capacity());
            int maxCount = 100;
            for (int i = 0; i < 100; ++i) {
                if (i % 3 != 0) continue;
                BitVectorHelper.setBit((ArrowBuf)buf1, (long)i);
                BitVectorHelper.setBit((ArrowBuf)buf2, (long)i);
            }
            this.concatAndVerify(buf1, 40, buf2, 48, output);
            this.concatAndVerify(buf1, 32, buf2, 47, output);
            this.concatAndVerify(buf1, 31, buf2, 48, output);
            this.concatAndVerify(buf1, 27, buf2, 52, output);
            this.concatAndVerify(buf1, 31, buf2, 55, output);
        }
    }

    @Test
    public void testConcatBitsInPlace() {
        try (RootAllocator allocator = new RootAllocator(0x100000L);
             ArrowBuf buf1 = allocator.buffer(1024L);
             ArrowBuf buf2 = allocator.buffer(1024L);){
            buf1.setZero(0L, buf1.capacity());
            buf2.setZero(0L, buf2.capacity());
            int maxCount = 100;
            for (int i = 0; i < 100; ++i) {
                if (i % 3 != 0) continue;
                BitVectorHelper.setBit((ArrowBuf)buf1, (long)i);
                BitVectorHelper.setBit((ArrowBuf)buf2, (long)i);
            }
            this.concatAndVerify(buf1, 40, buf2, 48, buf1);
            this.concatAndVerify(buf1, 32, buf2, 47, buf1);
            this.concatAndVerify(buf1, 31, buf2, 48, buf1);
            this.concatAndVerify(buf1, 27, buf2, 52, buf1);
            this.concatAndVerify(buf1, 31, buf2, 55, buf1);
        }
    }

    @Test
    public void testLoadValidityBuffer() {
        try (RootAllocator allocator = new RootAllocator(1024L);){
            Throwable throwable;
            ArrowBuf dst2;
            int i;
            ArrowFieldNode fieldNode = new ArrowFieldNode(1024L, 1024L);
            try (ArrowBuf buf = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)fieldNode, null, (BufferAllocator)allocator);){
                Assert.assertEquals((long)128L, (long)allocator.getAllocatedMemory());
                for (i = 0; i < 128; ++i) {
                    Assert.assertEquals((long)0L, (long)buf.getByte((long)i));
                }
            }
            fieldNode = new ArrowFieldNode(1024L, 0L);
            buf = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)fieldNode, null, (BufferAllocator)allocator);
            var5_7 = null;
            try {
                Assert.assertEquals((long)128L, (long)allocator.getAllocatedMemory());
                for (i = 0; i < 128; ++i) {
                    Assert.assertEquals((long)-1L, (long)buf.getByte((long)i));
                }
            }
            catch (Throwable i2) {
                var5_7 = i2;
                throw i2;
            }
            finally {
                if (buf != null) {
                    TestBitVectorHelper.$closeResource(var5_7, (AutoCloseable)buf);
                }
            }
            fieldNode = new ArrowFieldNode(1024L, 1024L);
            var5_7 = null;
            try (ArrowBuf src = allocator.buffer(128L);){
                dst2 = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)fieldNode, (ArrowBuf)src, (BufferAllocator)allocator);
                throwable = null;
                try {
                    Assert.assertEquals((long)128L, (long)allocator.getAllocatedMemory());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dst2 != null) {
                        TestBitVectorHelper.$closeResource(throwable, (AutoCloseable)dst2);
                    }
                }
            }
            catch (Throwable dst2) {
                var5_7 = dst2;
                throw dst2;
            }
            fieldNode = new ArrowFieldNode(1024L, 0L);
            src = allocator.buffer(128L);
            var5_7 = null;
            try {
                dst2 = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)fieldNode, (ArrowBuf)src, (BufferAllocator)allocator);
                throwable = null;
                try {
                    Assert.assertEquals((long)128L, (long)allocator.getAllocatedMemory());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (dst2 != null) {
                        TestBitVectorHelper.$closeResource(throwable, (AutoCloseable)dst2);
                    }
                }
            }
            catch (Throwable throwable4) {
                var5_7 = throwable4;
                throw throwable4;
            }
            finally {
                if (src != null) {
                    TestBitVectorHelper.$closeResource(var5_7, (AutoCloseable)src);
                }
            }
            int numNulls = 100;
            fieldNode = new ArrowFieldNode(1024L, (long)numNulls);
            try (ArrowBuf src = allocator.buffer(128L);){
                src.setZero(0L, src.capacity());
                for (int i3 = 0; i3 < numNulls; ++i3) {
                    BitVectorHelper.setBit((ArrowBuf)src, (long)i3);
                }
                try (ArrowBuf dst3 = BitVectorHelper.loadValidityBuffer((ArrowFieldNode)fieldNode, (ArrowBuf)src, (BufferAllocator)allocator);){
                    Assert.assertEquals((long)src.memoryAddress(), (long)dst3.memoryAddress());
                    Assert.assertEquals((long)128L, (long)allocator.getAllocatedMemory());
                    for (int i4 = 0; i4 < 1024; ++i4) {
                        Assert.assertEquals((long)BitVectorHelper.get((ArrowBuf)src, (int)i4), (long)BitVectorHelper.get((ArrowBuf)dst3, (int)i4));
                    }
                }
            }
        }
    }

    private void concatAndVerify(ArrowBuf buf1, int count1, ArrowBuf buf2, int count2, ArrowBuf output) {
        BitVectorHelper.concatBits((ArrowBuf)buf1, (int)count1, (ArrowBuf)buf2, (int)count2, (ArrowBuf)output);
        int outputIdx = 0;
        int i = 0;
        while (i < count1) {
            Assert.assertEquals((long)BitVectorHelper.get((ArrowBuf)output, (int)outputIdx), (long)BitVectorHelper.get((ArrowBuf)buf1, (int)i));
            ++i;
            ++outputIdx;
        }
        i = 0;
        while (i < count2) {
            Assert.assertEquals((long)BitVectorHelper.get((ArrowBuf)output, (int)outputIdx), (long)BitVectorHelper.get((ArrowBuf)buf2, (int)i));
            ++i;
            ++outputIdx;
        }
    }
}

